/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ierp;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.connector.AttachUtil;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.HttpConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.WorkflowInfo;
import kd.isc.iscb.platform.core.connector.ierp.IerpProxyContext;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteSystem;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public final class IERPConnectionFactory
implements JdbcConnectionFactory,
HttpConnectionFactory {
    @Override
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        final IerpProxyContext ctx = new IerpProxyContext(cfg);
        Connection cn = RemoteSystem.getConnection((RemoteContext)ctx);
        return new JdbcConnectionWrapper(cn, this, cfg){

            @Override
            public Object get(String property) {
                if ("ROOT_ORG_ID".equals(property)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("command", "GetRootOrgId");
                    return ctx.invoke(params);
                }
                return super.get(property);
            }
        };
    }

    @Override
    public void test(ConnectionWrapper cn) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.test((RemoteContext)ctx);
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getMetaList((RemoteContext)ctx);
    }

    @Override
    public Table getTable(JdbcConnectionWrapper cn, String table_name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getTable((RemoteContext)ctx, (String)table_name);
    }

    @Override
    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper cn, String table_name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getIndexInfo((RemoteContext)ctx, (String)table_name);
    }

    @Override
    public boolean supportsTransaction() {
        return false;
    }

    @Override
    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.classify((RemoteContext)ctx, (Table)table, judgeFields, rows, for_insert, for_update);
    }

    @Override
    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String table_name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getTableInfo((RemoteContext)ctx, (String)table_name);
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getEntityInfo((RemoteContext)ctx, (String)name);
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getEnumInfo((RemoteContext)ctx, (String)name);
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.retrieveData((RemoteContext)ctx, (String)entity, requires, filter, orderBy);
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        return this.doBizAction(cn, entity, data, judgeFields, actions, Collections.emptyMap(), proxy_user);
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.doBizActionWithParams((RemoteContext)ctx, (String)entity, data, judgeFields, actions, targetActionParams, (String)proxy_user);
    }

    @Override
    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batchData, String pk, Map<String, List<String>> judgeFields, String action, String proxy_user) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.doBatchBizAction((RemoteContext)ctx, (String)entity, batchData, (String)pk, judgeFields, (String)action, (String)proxy_user);
    }

    @Override
    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, String proxy_user) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.doBatchBizActionWithParams((RemoteContext)ctx, (String)entity, batch, (String)pk, judgeFields, (String)action, targetActionParams, (String)proxy_user);
    }

    @Override
    public boolean supportsBizBatchAction(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.doDataAction((RemoteContext)ctx, data, (String)mainTable.getName(), entryTables, judgeFields, actions);
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.callDataHandler((RemoteContext)ctx, (String)targetDataHandler, data, judgeFields, (String)proxy_user);
    }

    @Override
    public boolean supportsEvent() {
        return true;
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.detachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity);
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.attachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity, (String[])events, requires);
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean supportsRemoteDeploy() {
        return true;
    }

    @Override
    public void deploy(ConnectionWrapper cn, String ierpServerURL, String adminPassword, PermissionMode mode) {
        DynamicObject cfg = cn.getConfig();
        UserPermissionUtil.assignPermAndUpdate(cfg);
        IerpUtil.deploy(cfg, ierpServerURL, adminPassword, mode);
    }

    @Override
    public void pushPermission(ConnectionWrapper cn, Map<Object, Object> permission, String adminPassword) {
        IerpUtil.pushPermission(cn.getConfig(), permission, adminPassword);
    }

    @Override
    public void rePushEventData(ConnectionWrapper cn, List<Object> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.rePushEventData((RemoteContext)ctx, ids);
    }

    @Override
    public Map<String, InitResult> checkInitState(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        return IerpUtil.checkInitState(cn, data, adminPassword);
    }

    @Override
    public Map<String, InitResult> initEnv(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        return IerpUtil.initEnv(cn, data, adminPassword);
    }

    @Override
    public char getQuot() {
        return ' ';
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case ENTITY: 
            case TABLE: 
            case ENUM: 
            case VIEW: 
            case SERVICE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void raiseEvent(ConnectionWrapper cn, String handler, Map<String, Object> data) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        RemoteSystem.raiseEvent((RemoteContext)ctx, (String)handler, data);
    }

    @Override
    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.callService((RemoteContext)ctx, (String)service, params, (String)proxyUser);
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getServiceInfo((RemoteContext)ctx, (String)service_name);
    }

    @Override
    public List<Map<String, Object>> getServiceInfoX(ConnectionWrapper cn, String service_name) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getServiceInfoX((RemoteContext)ctx, (String)service_name);
    }

    @Override
    public AbstractInputStream getAttachmentReader(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getAttachmentReader((RemoteContext)ctx, fileInfo);
    }

    @Override
    public AbstractOutputStream getAttachmentWriter(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.getAttachmentWriter((RemoteContext)ctx, fileInfo, (int)AttachUtil.getBlockSize());
    }

    @Override
    public boolean supportsAttachment(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public boolean isAttachmentChanged(ConnectionWrapper cn, Map<String, Object> fileInfo, String md5Code) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.isAttachmentChanged((RemoteContext)ctx, fileInfo, (String)md5Code);
    }

    @Override
    public List<Map<String, Object>> retrieveAttachList(ConnectionWrapper cn, Map<String, Object> invokeParam) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.retrieveAttachList((RemoteContext)ctx, invokeParam);
    }

    @Override
    public String netSpeedTest(ConnectionWrapper cn) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        return RemoteSystem.netSpeedTest((RemoteContext)ctx);
    }

    @Override
    public List<WorkflowInfo> initiateWorkflow(ConnectionWrapper cn, String entity, String operation, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        List list = RemoteSystem.initiateWorkflow((RemoteContext)ctx, (String)entity, (String)operation, idList, (String)proxyUser, extendInfo);
        return WorkflowInfo.toList(list);
    }

    @Override
    public List<WorkflowInfo> queryWorkflowState(ConnectionWrapper cn, String entity, String operation, List<String> idList) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        List list = RemoteSystem.queryWorkflowState((RemoteContext)ctx, (String)entity, (String)operation, idList);
        return WorkflowInfo.toList(list);
    }

    @Override
    public List<WorkflowInfo> getWorkflowState(ConnectionWrapper cn, List<String> workflowInstanceIdList) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        List list = RemoteSystem.getWorkflowState((RemoteContext)ctx, workflowInstanceIdList);
        return WorkflowInfo.toList(list);
    }

    @Override
    public String getHttpURL(DynamicObject dynamicObject) {
        String protocal = D.s((Object)dynamicObject.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        String url = protocal + "://" + dynamicObject.getString("server_ip") + ":" + dynamicObject.getString("server_port") + dynamicObject.getString("web_app");
        return url;
    }

    @Override
    public void undeploy(ConnectionWrapper cn, String iscHub, String ierpServerURL, String adminPassword) {
        IerpProxyContext ctx = new IerpProxyContext(cn.getConfig());
        try {
            IerpUtil.undeploy(cn.getConfig(), ctx, iscHub, ierpServerURL, adminPassword);
        }
        catch (Throwable e) {
            if (StringUtil.getCascadeMessage((Throwable)e).contains("\u547d\u4ee4\uff08remote_undeploy\uff09\u672a\u5b9e\u73b0")) {
                throw new IscBizException(ResManager.loadKDString((String)"\u8fdc\u7aef\u82cd\u7a79\u7248\u672c\u4e0d\u652f\u6301\u201c\u53cd\u90e8\u7f72\u201d\u529f\u80fd\uff0c\u8bf7\u66f4\u65b0\u82cd\u7a79\u7248\u672c\u81f3V5.0.009\u53ca\u4ee5\u4e0a", (String)"IERPConnectionFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
            }
            throw e;
        }
    }
}

