/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.EventSrcUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class HubEventBindingUtil {
    private static final String ISC_RES_EVT_BND = "isc_res_evt_bnd";
    private static final int MAX_LENGTH = 1000;

    static DynamicObject saveEventBindingInfo(EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        DynamicObject bindInfo = BusinessDataServiceHelper.newDynamicObject((String)ISC_RES_EVT_BND);
        String triggerMetaType = HubEventBindingUtil.getTriggerMetaType(type);
        bindInfo.set("id", (Object)HubEventBindingUtil.generateBindInfoId(triggerMetaType, triggerId, entity));
        String[] split = entity.split("/");
        String entityType = split[0];
        String number = entity.substring(entityType.length() + 1);
        bindInfo.set("evt_schema_type", (Object)entityType);
        if ("all".equals(number)) {
            bindInfo.set("all_evt_schema", (Object)Boolean.TRUE);
            bindInfo.set("evt_schema", null);
        } else {
            DynamicObject dynamicObject = EventSrcUtil.getDynamicObject(number, EntityMetadataCache.getDataEntityType((String)entityType));
            long evtSchemaId = D.l((Object)dynamicObject.getPkValue());
            if (triggerId == evtSchemaId && triggerMetaType.equals(entityType)) {
                throw new IscBizException(ResManager.loadKDString((String)"\u7981\u6b62\u65b9\u6848\u76d1\u542c\u81ea\u8eab\u4e8b\u4ef6\u53c8\u89e6\u53d1\u81ea\u8eab", (String)"HubEventBindingUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            bindInfo.set("all_evt_schema", (Object)Boolean.FALSE);
            bindInfo.set("evt_schema", (Object)evtSchemaId);
        }
        bindInfo.set("trigger_type", (Object)triggerMetaType);
        bindInfo.set("trigger", (Object)triggerId);
        bindInfo.set("events", (Object)HubEventBindingUtil.trimEventsAndConcat(events));
        HubEventBindingUtil.setTagField(bindInfo, "required_fields", Json.toString(requires, (boolean)true));
        bindInfo.set("create_time", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bindInfo});
        return bindInfo;
    }

    static void deleteEventBindingInfo(EventBindingUtil.TriggerType type, long triggerId, String entity) {
        QFilter qFilter = new QFilter("id", "=", (Object)HubEventBindingUtil.generateBindInfoId(HubEventBindingUtil.getTriggerMetaType(type), triggerId, entity));
        DeleteServiceHelper.delete((String)ISC_RES_EVT_BND, (QFilter[])new QFilter[]{qFilter});
    }

    private static long generateBindInfoId(String type, long triggerId, String entity) {
        String str = type + triggerId + entity;
        return Math.abs(Hash.mur64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    private static void setTagField(DynamicObject obj, String fieldName, String value) {
        if (value.length() > 1000) {
            obj.set(fieldName + "_tag", (Object)value);
        } else {
            obj.set(fieldName, (Object)value);
        }
    }

    private static String trimEventsAndConcat(String[] events) {
        HashSet<String> set = new HashSet<String>();
        for (String e : events) {
            String evt = D.s((Object)e);
            if (evt == null) continue;
            set.add(evt);
        }
        return StringUtil.join(set);
    }

    public static String getTriggerMetaType(EventBindingUtil.TriggerType type) {
        if (type == EventBindingUtil.TriggerType.DataCopyTrigger) {
            return "isc_data_copy_trigger";
        }
        if (type == EventBindingUtil.TriggerType.APITrigger) {
            return "isc_call_api_by_evt";
        }
        if (type == EventBindingUtil.TriggerType.EntityEventTrigger) {
            return "isc_mq_bill_data_pub";
        }
        if (type == EventBindingUtil.TriggerType.ServiceFlowTrigger) {
            return "isc_service_flow";
        }
        if (type == EventBindingUtil.TriggerType.ServiceFlowEventWaiting) {
            return "isc_sf_waiting_event";
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u89e6\u53d1\u7c7b\u578b\uff1a%s", (String)"HubEventBindingUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }
}

