/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.eventlog;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.EventLogExtendInfo;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class IscEventLog {
    public static final String ISC_RES_EVT_LOG = "isc_res_evt_log";
    public static final String EVT_SCHEMA_TYPE = "evt_schema_type";
    public static final String EVT_SCHEMA_ID = "evt_schema_id";
    public static final String ACTION = "action";
    public static final String TRIGGER_TYPE = "trigger_type";
    public static final String TRIGGER = "trigger";
    public static final String DATA_TAG = "data_tag";
    public static final String DATA = "data";
    public static final String CREATE_TIME = "create_time";
    public static final String MODIFIED_TIME = "modified_time";
    public static final String STATE = "state";
    public static final String SRC_DATA_TYPE = "src_data_type";
    public static final String SRC_DATA_ID = "src_data_id";
    public static final String ROOT_ID = "root_id";
    public static final String PRIOR_ID = "prior_id";
    public static final String TTL = "ttl";
    public static final String ERROR = "error";
    public static final String ERROR_TAG = "error_tag";
    public static final String EVENT_EXT_INFO = "$event_ext_info";
    public static final String ID = "id";

    private IscEventLog() {
    }

    public static DynamicObject create(String evt_schema_type, long evt_schema_id, String action, String trigger_type, long triggerId, Map<String, Object> data, EventLogExtendInfo extendInfo) {
        DynamicObject eventLog = BusinessDataServiceHelper.newDynamicObject((String)ISC_RES_EVT_LOG);
        eventLog.set(ID, (Object)IDService.get().genLongId());
        eventLog.set(EVT_SCHEMA_TYPE, (Object)evt_schema_type);
        eventLog.set(EVT_SCHEMA_ID, (Object)evt_schema_id);
        eventLog.set(ACTION, (Object)action);
        eventLog.set(TRIGGER_TYPE, (Object)trigger_type);
        eventLog.set(TRIGGER, (Object)triggerId);
        IscEventLog.setData(data, eventLog);
        IscEventLog.setExtendInfo(extendInfo, eventLog);
        eventLog.set(CREATE_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        eventLog.set(MODIFIED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        eventLog.set(STATE, (Object)"C");
        return eventLog;
    }

    private static void setData(Map<String, Object> data, DynamicObject eventLog) {
        String dataStr = Json.toString(data);
        if (dataStr.length() > 500) {
            eventLog.set(DATA_TAG, (Object)dataStr);
        } else {
            eventLog.set(DATA, (Object)dataStr);
        }
    }

    private static void setExtendInfo(EventLogExtendInfo extendInfo, DynamicObject eventLog) {
        if (extendInfo != null) {
            eventLog.set(SRC_DATA_TYPE, (Object)extendInfo.getSrcDataType());
            eventLog.set(SRC_DATA_ID, (Object)extendInfo.getSrcDataId());
            long rootId = extendInfo.getRootId() > 0L ? extendInfo.getRootId() : eventLog.getLong(ID);
            eventLog.set(ROOT_ID, (Object)rootId);
            eventLog.set(PRIOR_ID, (Object)extendInfo.getPriorId());
            eventLog.set(TTL, (Object)extendInfo.getTtl());
        }
    }

    public static EventLogExtendInfo getExtendInfo(DynamicObject eventLog) {
        String srcDataType = D.s((Object)eventLog.get(SRC_DATA_TYPE));
        long srcDataId = D.l((Object)eventLog.get(SRC_DATA_ID));
        long rootId = D.l((Object)eventLog.get(ROOT_ID));
        long priorId = D.l((Object)eventLog.get(PRIOR_ID));
        long myId = D.l((Object)eventLog.get(ID));
        int ttl = D.i((Object)eventLog.get(TTL));
        if (rootId == 0L && ttl == 0) {
            return null;
        }
        return new EventLogExtendInfo(srcDataType, srcDataId, myId, rootId, priorId, ttl);
    }

    public static void update(DynamicObject iscEventLog, String state, String error, String errorTag) {
        iscEventLog.set(MODIFIED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        iscEventLog.set(STATE, (Object)state);
        iscEventLog.set(ERROR, (Object)error);
        iscEventLog.set(ERROR_TAG, (Object)errorTag);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{iscEventLog});
    }

    public static boolean resetFailedLog(long id) {
        long now = System.currentTimeMillis();
        String sql = "UPDATE t_isc_res_evt_log SET fstate='R',fmodified_time=? WHERE fstate='F' and fid = ?";
        List<Object> params = Arrays.asList(new Timestamp(now), id);
        List<Integer> types = Arrays.asList(93, -5);
        return IscEventLog.executeSql(sql, params, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeSql(String sql, List<Object> params, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int affacted = DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
            boolean bl = affacted >= 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static EventLogExtendInfo createOrUpdateExtendInfo(EventLogExtendInfo extendInfo, DynamicObject srcObject) {
        if (extendInfo == null) {
            return new EventLogExtendInfo(srcObject.getDataEntityType().getName(), D.l((Object)srcObject.getPkValue()));
        }
        return new EventLogExtendInfo(srcObject.getDataEntityType().getName(), D.l((Object)srcObject.getPkValue()), 0L, extendInfo.getRootId(), extendInfo.getMyId(), extendInfo.getTtl() - 1);
    }
}

