/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.job;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;

public class EventLogCleaner
implements DaemonTask {
    private static String sql = "DELETE FROM t_isc_res_evt_log WHERE (fstate in ('C','R','S') AND fmodified_time<=?) OR (fstate='F' AND fmodified_time<=?)";
    private String id;
    private static Log logger = LogFactory.getLog(EventLogCleaner.class);

    public EventLogCleaner(String accountId) {
        this.id = "HUB_C:" + accountId;
    }

    @Override
    public void run() {
        try {
            long now = System.currentTimeMillis();
            Timestamp t1 = new Timestamp(now - 86400000L);
            Timestamp t2 = new Timestamp(now - 604800000L);
            this.execute(sql, t1, t2);
        }
        catch (Throwable e) {
            logger.warn("EventLogCleaner", e);
        }
        ScheduleManager.submit((Task)this, 3600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql, Timestamp t1, Timestamp t2) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(t1, t2), Arrays.asList(93, 93));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

