/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.job;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.EventLogExtendInfo;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.IscEventLog;
import kd.isc.iscb.platform.core.connector.ischub.job.HubEventHandler;
import kd.isc.iscb.platform.core.connector.ischub.job.IscEventJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class IscEventJob
implements Job {
    public static final JobFactory FACTORY = new IscEventJobFactory();
    private long iscEventLogId;
    private String title;

    public IscEventJob(String title, long iscEventLogId) {
        this.title = title;
        this.iscEventLogId = iscEventLogId;
    }

    @Override
    public String getParam() {
        return String.valueOf(this.iscEventLogId);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public long getOwnerId() {
        return this.iscEventLogId;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        DynamicObject iscEventLog = BusinessDataServiceHelper.loadSingle((Object)this.iscEventLogId, (String)"isc_res_evt_log");
        try {
            Map srcdata = this.getSrcdata(iscEventLog);
            EventLogExtendInfo extendInfo = IscEventLog.getExtendInfo(iscEventLog);
            HashMap<String, Object> extendProps = new HashMap<String, Object>();
            if (extendInfo != null) {
                extendProps.put("$event_ext_info", extendInfo.toMap());
            }
            HubEventHandler.handle(iscEventLog.getString("trigger_type"), iscEventLog.getLong("trigger_id"), srcdata, extendProps);
            IscEventLog.update(iscEventLog, "S", null, null);
        }
        catch (Throwable e) {
            IscEventLog.update(iscEventLog, "F", StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)e), (int)50), StringUtil.toString((Throwable)e));
        }
    }

    private Map getSrcdata(DynamicObject iscEventLog) {
        String srcDataStr = D.s((Object)iscEventLog.getString("data"));
        if (srcDataStr == null) {
            srcDataStr = D.s((Object)iscEventLog.getString("data_tag"));
        }
        return (Map)Json.toObject((String)srcDataStr);
    }
}

