/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class IscTopologyConvertRule
extends AbstractIscTopology
implements Const {
    public IscTopologyConvertRule(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        TopologyUtil.addFlowIDList(upList, "isc_value_conver_rule", this.id);
        this.addDataCopyIDList(upList);
        this.queryUpApi(upList);
        return upList;
    }

    private void queryUpApi(List<String> upList) {
        QFilter qFilter = new QFilter("value_conver_rule.id", "=", (Object)this.id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"isc_apic_by_vc", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject api : collection) {
            upList.add(TopologyUtil.combination("isc_apic_by_vc", api.getLong("id"), api.get("enable")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataCopyIDList(List<String> upList) {
        String sql = "SELECT fid FROM t_iscb_data_copy_mapping WHERE fvalue_conver_rule = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.singletonList(this.id), Collections.singletonList(-5));
            HashSet<Long> set = new HashSet<Long>();
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    long fid = D.l((Object)data.get((Object)"fid"));
                    set.add(fid);
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
            for (Long l : set) {
                upList.add(TopologyUtil.combination("isc_data_copy", l, 1));
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public List<String> getDownStreamList() {
        ArrayList<String> downList = new ArrayList<String>();
        this.addMeta(downList);
        this.addTrigger(downList);
        return downList;
    }

    private void addTrigger(List<String> downList) {
        QFilter qFilter = new QFilter("id", "=", (Object)this.id);
        DynamicObject converRule = QueryServiceHelper.queryOne((String)"isc_value_conver_rule", (String)"data_copy_trigger", (QFilter[])new QFilter[]{qFilter});
        if (converRule.getLong("data_copy_trigger") > 0L) {
            QFilter q = new QFilter("id", "=", (Object)converRule.getLong("data_copy_trigger"));
            DynamicObject trigger = QueryServiceHelper.queryOne((String)"ISC_DATA_COPY_TRIGGER", (String)"id,enable", (QFilter[])new QFilter[]{q});
            downList.add(TopologyUtil.combination("isc_data_copy_trigger", trigger.getLong("id"), TopologyUtil.formatEnable(trigger)));
        }
    }

    private void addMeta(List<String> downList) {
        QFilter qFilter = new QFilter("id", "=", (Object)this.id);
        DynamicObject converRule = QueryServiceHelper.queryOne((String)"isc_value_conver_rule", (String)"source_data_schema,target_data_schema", (QFilter[])new QFilter[]{qFilter});
        if (converRule.getLong("source_data_schema") > 0L) {
            downList.add(TopologyUtil.combination("isc_metadata_schema", converRule.getLong("source_data_schema"), 1));
        }
        if (converRule.getLong("target_data_schema") > 0L) {
            downList.add(TopologyUtil.combination("isc_metadata_schema", converRule.getLong("target_data_schema"), 1));
        }
    }
}

