/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class IscTopologyMeta
extends AbstractIscTopology
implements Const {
    public IscTopologyMeta(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        QFilter filter = new QFilter("id", "=", (Object)this.id);
        DynamicObject meta = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)"type,full_name,group", (QFilter[])new QFilter[]{filter});
        if ("EVT_RSC".equals(meta.getString("type"))) {
            return this.getEvtUpList(meta);
        }
        ArrayList<String> upList = new ArrayList<String>();
        this.queryMetaApis(upList);
        this.queryConverRule(upList);
        this.queryDataCopy(upList);
        TopologyUtil.addFlowIDList(upList, "isc_metadata_schema", this.id);
        return upList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryConverRule(List<String> upList) {
        String sql = "SELECT fid FROM t_isc_value_conver_rule WHERE fsource_data_schema = ? or ftarget_data_schema = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Arrays.asList(this.id, this.id), Arrays.asList(-5, -5));
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    long fid = D.l((Object)data.get((Object)"fid"));
                    upList.add(TopologyUtil.combination("isc_value_conver_rule", fid, 1));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDataCopy(List<String> upList) {
        String sql = "SELECT fid FROM t_iscb_data_copy WHERE fsource_schema = ? or ftarget_schema = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Arrays.asList(this.id, this.id), Arrays.asList(-5, -5));
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    long fid = D.l((Object)data.get((Object)"fid"));
                    upList.add(TopologyUtil.combination("isc_data_copy", fid, 1));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private List<String> getEvtUpList(DynamicObject meta) {
        String full_name = meta.getString("full_name");
        String[] keys = full_name.split("/");
        return this.getUpList(keys);
    }

    private void queryMetaApis(List<String> upList) {
        QFilter qFilter = new QFilter("metadata.id", "=", (Object)this.id);
        DynamicObjectCollection metaApis = QueryServiceHelper.query((String)"isc_apic_by_meta_schema", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject metaApi : metaApis) {
            upList.add(TopologyUtil.combination("isc_apic_by_meta_schema", metaApi.getLong("id"), TopologyUtil.formatEnable(metaApi)));
        }
    }

    private List<String> getUpList(String[] keys) {
        QFilter qFilter = new QFilter("number", "=", (Object)keys[1]);
        DynamicObject obj = QueryServiceHelper.queryOne((String)keys[0], (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj != null) {
            if ("isc_data_copy_trigger".equals(keys[0])) {
                obj = QueryServiceHelper.queryOne((String)"isc_data_copy_trigger", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
                return Collections.singletonList(TopologyUtil.combination("isc_data_copy_trigger", obj.getLong("id"), TopologyUtil.formatEnable(obj)));
            }
            if ("isc_service_flow".equals(keys[0])) {
                obj = QueryServiceHelper.queryOne((String)"isc_service_flow", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
                return Collections.singletonList(TopologyUtil.combination("isc_service_flow", obj.getLong("id"), TopologyUtil.formatEnable(obj)));
            }
            if ("isc_data_source".equals(keys[0])) {
                DynamicObject source = QueryServiceHelper.queryOne((String)"isc_data_source", (String)"dblink", (QFilter[])new QFilter[]{qFilter});
                QFilter filter = new QFilter("id", "=", (Object)source.getLong("dblink"));
                DynamicObject dataBaseLink = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"id,state", (QFilter[])new QFilter[]{filter});
                return Collections.singletonList(TopologyUtil.combination("isc_data_source", obj.getLong("id"), "F".equals(dataBaseLink.getString("state")) ? 0 : 1));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getDownStreamList() {
        ArrayList<String> downList = new ArrayList<String>();
        this.queryApiTrigger(downList);
        this.queryTrigger(downList);
        this.queryFlow(downList);
        this.queryMesBillPub(downList);
        return downList;
    }

    private void queryMesBillPub(List<String> downList) {
        QFilter qFilter = new QFilter("meta_data.id", "=", (Object)this.id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"isc_mq_bill_data_pub", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject pub : collection) {
            downList.add(TopologyUtil.combination("isc_mq_bill_data_pub", pub.getLong("id"), TopologyUtil.formatEnable(pub)));
        }
    }

    private void queryFlow(List<String> downList) {
        QFilter qFilter = new QFilter("init_mode", "=", (Object)"EVENT");
        qFilter.and("is_released", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"isc_service_flow", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.flowAddDownList(downList, dynamicObject);
        }
    }

    private void flowAddDownList(List<String> downList, DynamicObject dynamicObject) {
        long flowId = dynamicObject.getLong("id");
        long releasedId = ServiceFlowParser.findReleasedFlowId(flowId);
        if (releasedId == 0L) {
            return;
        }
        Map<String, Object> diagram = ServiceFlowReleaser.getDiagramJson(releasedId);
        Map nodes = (Map)diagram.get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            long metaId;
            Map detail = (Map)node.getValue();
            if (!"EventStarter".equalsIgnoreCase(D.s(detail.get("type"))) || (metaId = D.l(detail.get("data_schema"))) != this.id) continue;
            downList.add(TopologyUtil.combination("isc_service_flow", flowId, TopologyUtil.formatEnable(dynamicObject)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryTrigger(List<String> downList) {
        String sql = "SELECT a.fid,a.fenable FROM T_ISC_DATA_COPY_TRIGGER a LEFT JOIN T_ISCB_DATA_COPY b on a.fdata_copy = b.fid WHERE a.ftrigger_type = 'event'and b.fsource_schema = " + this.id;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    downList.add(TopologyUtil.combination("isc_data_copy_trigger", D.l((Object)data.get((Object)"fid")), data.get((Object)"fenable")));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void queryApiTrigger(List<String> downList) {
        QFilter qFilter = new QFilter("metaschema", "=", (Object)this.id);
        DynamicObjectCollection apiTriggers = QueryServiceHelper.query((String)"isc_call_api_by_evt", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject apiTrigger : apiTriggers) {
            downList.add(TopologyUtil.combination("isc_call_api_by_evt", apiTrigger.getLong("id"), apiTrigger.get("enable")));
        }
    }
}

