/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;

public class IscTopologyScriptApi
extends AbstractIscTopology
implements Const {
    private Set<String> RESOURCESS = new HashSet<String>(Arrays.asList("isc_data_source", "isc_custom_function", "isc_apic_for_external_api", "isc_apic_mservice", "isc_service_flow", "isc_data_copy"));

    public IscTopologyScriptApi(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        TopologyUtil.addFlowIDList(upList, "isc_apic_script", this.id);
        this.addEvtApi(upList);
        return upList;
    }

    private void addEvtApi(List<String> upList) {
        QFilter qFilter = new QFilter("api.id", "=", (Object)this.id);
        DynamicObjectCollection evts = QueryServiceHelper.query((String)"isc_call_api_by_evt", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject evt : evts) {
            upList.add(TopologyUtil.combination("isc_call_api_by_evt", evt.getLong("id"), TopologyUtil.formatEnable(evt)));
        }
    }

    @Override
    public List<String> getDownStreamList() {
        ArrayList<String> downList = new ArrayList<String>();
        DynamicObject scriptApi = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_apic_script");
        DynamicObjectCollection resources = scriptApi.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            long resourceId;
            String resourceType = resource.getString("res_category");
            if ("isc_data_source".equals(resourceType)) {
                resourceId = resource.getDynamicObject("res_ref").getLong("id");
                downList.add(TopologyUtil.combination("isc_data_source", resourceId, TopologyUtil.getLinkState(resourceId)));
                continue;
            }
            if (!this.RESOURCESS.contains(resourceType)) continue;
            resourceId = resource.getDynamicObject("res_ref").getLong("id");
            DynamicObject objEnable = QueryServiceHelper.queryOne((String)resourceType, (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resourceId)});
            downList.add(TopologyUtil.combination(resourceType, resourceId, TopologyUtil.formatEnable(objEnable)));
        }
        return downList;
    }
}

