/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.JDBCConnectionPool;
import kd.isc.iscb.platform.core.connector.jdbc.JdbcContext;
import kd.isc.iscb.platform.core.connector.jdbc.Util;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.server.CallbackHandler;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.connector.server.TargetDataHandler;
import kd.isc.iscb.util.connector.server.e.GetIndexInfo;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.ReflectionUtil;

public abstract class AbstractConnectionFactory
implements JdbcConnectionFactory {
    private static final String FIELD_LABEL = "label";
    private static Map<String, JDBCConnectionPool> connProviders = new HashMap<String, JDBCConnectionPool>(16);
    private static final Collator STRING_COMPARATOR = Collator.getInstance(Locale.CHINA);

    @Override
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        String url = this.getURL(cfg);
        String user = cfg.getString("user");
        String password = cfg.getString("password");
        try {
            JDBCConnectionPool connectionProvider = this.getConnectionPool(url, user, password, cfg);
            return this.contructConnectionWrapper(connectionProvider.getConnection(), cfg);
        }
        catch (SQLException e) {
            String name = cfg.getString("name");
            String number = cfg.getString("number");
            throw ConnectorError.CONNECTION_FAILURE.create((Throwable)e, new String[]{name, number, e.getMessage()});
        }
    }

    protected JdbcConnectionWrapper contructConnectionWrapper(Connection cn, DynamicObject cfg) {
        return new JdbcConnectionWrapper(cn, this, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDBCConnectionPool getConnectionPool(String url, String user, String password, DynamicObject cfg) throws SQLException {
        Map<String, JDBCConnectionPool> map = connProviders;
        synchronized (map) {
            String key = this.getCacheKey(url, user, password, cfg);
            JDBCConnectionPool connectionProvider = connProviders.get(key);
            if (connectionProvider == null) {
                DataSource ds = this.createDataSource(url, user, password, cfg);
                connectionProvider = new JDBCConnectionPool(key, ds, this.getTestSQL(cfg), cfg, this);
                ScheduleManager.submit((Task)connectionProvider, 600);
                connProviders.put(key, connectionProvider);
            }
            return connectionProvider;
        }
    }

    protected abstract String getTestSQL();

    protected String getTestSQL(DynamicObject cfg) {
        return this.getTestSQL();
    }

    @Override
    public Table getTable(JdbcConnectionWrapper cn, String table_name) {
        cn.ensureFluidControl();
        return new Table((Connection)cn, table_name, this.getQuot(cn));
    }

    @Override
    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper cn, String table_name) {
        cn.ensureFluidControl();
        Map indices = GetIndexInfo.get((Connection)cn, (String)table_name);
        HashMap<String, Index> data = new HashMap<String, Index>(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            data.put((String)entry.getKey(), new Index((Map)entry.getValue()));
        }
        return data;
    }

    @Override
    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String table_name) {
        cn.ensureFluidControl();
        Table table = this.getTable(cn, table_name);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("full_name", table_name.toLowerCase());
        meta.put("name", table_name.toUpperCase());
        meta.put("type", "TABLE");
        meta.put("title", table_name.toUpperCase());
        meta.put("table_name", table_name);
        meta.put("remark", table.getRemark());
        meta.put("properties", AbstractConnectionFactory.getProperties((Schema)table));
        return meta;
    }

    public static List<Map<String, Object>> getProperties(Schema table) {
        List<Map<String, Object>> list = AbstractConnectionFactory.columnsToList(table);
        AbstractConnectionFactory.sortProperties(list);
        AbstractConnectionFactory.setIndex(list);
        return list;
    }

    private static List<Map<String, Object>> columnsToList(Schema table) {
        int fieldCount = table.getFieldCount();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            Column c = table.getField(i);
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("name", c.getName());
            item.put(FIELD_LABEL, c.getRealName());
            item.put("data_type", c.getDataType().toString());
            item.put("is_primary_key", c.isPrimaryKey());
            item.put("is_nullable", c.isNullable());
            item.put("remark", c.getRemark());
            list.add(item);
        }
        return list;
    }

    private static void setIndex(List<Map<String, Object>> list) {
        int index = 0;
        for (Map<String, Object> item : list) {
            item.put("index", ++index);
        }
    }

    private static void sortProperties(List<Map<String, Object>> list) {
        Collections.sort(list, (a, b) -> {
            String ta = (String)a.get(FIELD_LABEL);
            String tb = (String)b.get(FIELD_LABEL);
            return STRING_COMPARATOR.compare(ta, tb);
        });
    }

    @Override
    public char getQuot() {
        return '\"';
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        HashMap<String, MetaType> hashMap;
        cn.ensureFluidControl();
        ResultSet rs1 = null;
        try {
            JdbcConnectionWrapper jc = (JdbcConnectionWrapper)cn;
            DatabaseMetaData meta = jc.getMetaData();
            String catalog = meta.getConnection().getCatalog();
            String schema = Table.getSchema((DatabaseMetaData)meta);
            rs1 = meta.getTables(catalog, schema, "%", new String[]{"TABLE", "VIEW"});
            HashMap<String, MetaType> tables = new HashMap<String, MetaType>(rs1.getFetchSize());
            while (rs1.next()) {
                String name = rs1.getString("TABLE_NAME");
                tables.put(name, MetaType.TABLE);
            }
            hashMap = tables;
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.META_QUERY_FAILURE.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs1);
                throw throwable;
            }
        }
        DbUtil.close((ResultSet)rs1);
        return hashMap;
    }

    @Override
    public boolean supportsTransaction() {
        return true;
    }

    @Override
    public void test(ConnectionWrapper cn) {
    }

    @Override
    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        cn.ensureFluidControl();
        Util.classify(cn, table, rows, judgeFields, for_insert, for_update);
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        cn.ensureFluidControl();
        JdbcConnectionWrapper jc = (JdbcConnectionWrapper)cn;
        return TableUtil.doAction((Connection)jc, data, (Table)mainTable, entryTables, judgeFields, actions);
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        cn.ensureFluidControl();
        TargetDataHandler h = (TargetDataHandler)ReflectionUtil.newInstance((String)targetDataHandler);
        return h.exec((ConnectorContext)new JdbcContext((JdbcConnectionWrapper)cn), data, judgeFields, proxy_user);
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected DataSource createDataSource(String url, String user, String password, DynamicObject cfg) throws SQLException {
        return this.createDataSource(url, user, password);
    }

    protected DataSource createDataSource(String url, String user, String password) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected String getURL(DynamicObject cfg) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected String getCacheKey(String url, String user, String password, DynamicObject cfg) {
        return url + ";" + user + ";" + password;
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void invokeCallbackHandler(ConnectionWrapper cn, String callbackHandler, Map<String, Object> response) {
        cn.ensureFluidControl();
        CallbackHandler h = (CallbackHandler)ReflectionUtil.newInstance((String)callbackHandler);
        h.handle((ConnectorContext)new JdbcContext((JdbcConnectionWrapper)cn), response);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        return MetaType.TABLE.name().equalsIgnoreCase(type);
    }

    @Override
    public List<String> getTables(ConnectionWrapper cn) {
        ArrayList<String> arrayList;
        cn.ensureFluidControl();
        ResultSet rs1 = null;
        try {
            JdbcConnectionWrapper jc = (JdbcConnectionWrapper)cn;
            DatabaseMetaData meta = jc.getMetaData();
            String catalog = meta.getConnection().getCatalog();
            String schema = Table.getSchema((DatabaseMetaData)meta);
            rs1 = meta.getTables(catalog, schema, "%", new String[]{"TABLE"});
            ArrayList<String> tables = new ArrayList<String>(128);
            while (rs1.next()) {
                tables.add(rs1.getString("TABLE_NAME"));
            }
            arrayList = tables;
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.META_QUERY_FAILURE.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs1);
                throw throwable;
            }
        }
        DbUtil.close((ResultSet)rs1);
        return arrayList;
    }

    protected static void clearProviders() {
        connProviders.clear();
    }
}

