/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import dm.jdbc.driver.DmdbDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.DmDbType;
import kd.isc.iscb.util.misc.StringUtil;

public final class DmConnectionFactory
extends AbstractConnectionFactory {
    @Override
    protected DataSource createDataSource(String url, String user, String password) throws SQLException {
        DmdbDataSource ods = new DmdbDataSource();
        ods.setURL(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setLoginTimeout(30);
        return ods;
    }

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String schema = cfg.getString("attr1");
        String url = "jdbc:dm://" + server + ":" + port;
        if (!StringUtil.isEmpty((String)schema)) {
            url = url + "?schema=" + schema;
        }
        return url;
    }

    @Override
    public char getQuot() {
        return '\"';
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public Table getTable(JdbcConnectionWrapper cn, String table_name) {
        return super.getTable(cn, table_name);
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case TABLE: {
                return true;
            }
            case VIEW: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DbType getDatabaseType() {
        return new DmDbType();
    }
}

