/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kd.isc.iscb.platform.core.connector.jdbc.JDBCConnectionPool;

public final class JDBCConnectionProxy
implements Connection {
    private Connection impl;
    private JDBCConnectionPool pool;

    JDBCConnectionProxy(Connection impl, JDBCConnectionPool pool) {
        this.impl = impl;
        this.pool = pool;
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.impl.clearWarnings();
    }

    @Override
    public final void commit() throws SQLException {
        this.impl.commit();
    }

    @Override
    public final void rollback() throws SQLException {
        this.impl.rollback();
    }

    @Override
    public final void rollback(Savepoint savepoint) throws SQLException {
        this.impl.rollback(savepoint);
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.impl.setAutoCommit(autoCommit);
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        return this.impl.getAutoCommit();
    }

    @Override
    public final Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.impl.createArrayOf(typeName, elements);
    }

    @Override
    public final Blob createBlob() throws SQLException {
        return this.impl.createBlob();
    }

    @Override
    public final Clob createClob() throws SQLException {
        return this.impl.createClob();
    }

    @Override
    public final NClob createNClob() throws SQLException {
        return this.impl.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.impl.createSQLXML();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.impl.createStatement();
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.impl.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.impl.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.impl.createStruct(typeName, attributes);
    }

    @Override
    public final String getCatalog() throws SQLException {
        return this.impl.getCatalog();
    }

    @Override
    public final Properties getClientInfo() throws SQLException {
        return this.impl.getClientInfo();
    }

    @Override
    public final String getClientInfo(String name) throws SQLException {
        return this.impl.getClientInfo(name);
    }

    @Override
    public final int getHoldability() throws SQLException {
        return this.impl.getHoldability();
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.impl.getMetaData();
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        return this.impl.getTransactionIsolation();
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.impl.getTypeMap();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.impl.getWarnings();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.impl.isClosed();
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        return this.impl.isReadOnly();
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        return this.impl.isValid(timeout);
    }

    @Override
    public final String nativeSQL(String sql) throws SQLException {
        return this.impl.nativeSQL(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.impl.prepareCall(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.impl.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.impl.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.impl.prepareStatement(sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.impl.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.impl.prepareStatement(sql, columnIndexes);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.impl.prepareStatement(sql, columnNames);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("Unsupported - catalog");
    }

    @Override
    public final void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.impl.setClientInfo(properties);
    }

    @Override
    public final void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.impl.setClientInfo(name, value);
    }

    @Override
    public final void setHoldability(int holdability) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Savepoint setSavepoint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Savepoint setSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setTransactionIsolation(int level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.impl.setTypeMap(map);
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.impl.isWrapperFor(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        return this.impl.unwrap(iface);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.impl.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.impl.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.impl.getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.impl.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.impl.setSchema(schema);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.impl != null) {
            this.pool.recycle(this.impl);
            this.impl = null;
        }
    }

    public Connection getImpl() {
        return this.impl;
    }

    public JDBCConnectionPool getPool() {
        return this.pool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JDBCConnectionProxy that = (JDBCConnectionProxy)o;
        return this.impl.equals(that.impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }
}

