/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import com.mysql.cj.jdbc.MysqlDataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.MySqlDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public final class MySqlConnectionFactory
extends AbstractConnectionFactory {
    @Override
    protected DataSource createDataSource(String url, String user, String password) throws SQLException {
        MysqlDataSource ods = new MysqlDataSource();
        ods.setURL(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setUseCursorFetch(true);
        ods.setLoginTimeout(30);
        ods.setUseInformationSchema(true);
        if (!url.contains("rewriteBatchedStatements")) {
            ods.setRewriteBatchedStatements(true);
        }
        ods.setSocketTimeout(1800000);
        return ods;
    }

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String database = cfg.getString("sql_database");
        String url = "jdbc:mysql://" + server + ":" + port + "/" + database;
        url = this.getCharset(cfg, url);
        url = this.getTimezone(cfg, url);
        return url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTimezone(DynamicObject cfg, String url) {
        String serverTimezone = D.s((Object)cfg.getString("attr1"));
        if (serverTimezone == null) return url;
        if (!url.contains("?")) return url + "?serverTimezone=" + this.encode(serverTimezone);
        if (url.contains("serverTimezone=")) throw new IscBizException(ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u8bbe\u7f6e\u503c\u4e2d\u5df2\u7ecf\u5305\u542b\u65f6\u533a\u4fe1\u606f\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\u65f6\u533a\u3002", (String)"MySqlConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return url + "&serverTimezone=" + this.encode(serverTimezone);
    }

    private String getCharset(DynamicObject cfg, String url) {
        String charset = D.s((Object)cfg.getString("charset"));
        if (charset != null) {
            url = url + "?characterEncoding=" + charset;
        }
        return url;
    }

    private String encode(String serverTimezone) {
        try {
            return URLEncoder.encode(serverTimezone, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw D.e((Throwable)e);
        }
    }

    @Override
    public char getQuot() {
        return '`';
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT*FROM (" + sql + ")X LIMIT 0," + topN;
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case TABLE: {
                return true;
            }
            case VIEW: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DbType getDatabaseType() {
        return new MySqlDbType();
    }

    @Override
    public String getUpsertSql(Table table, List<Column> fields) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(table.getQuotedName());
        sql.append('(');
        StringBuilder values = new StringBuilder();
        StringBuilder updateClause = new StringBuilder();
        this.appendEachField(fields, sql, values, updateClause);
        sql.append(")VALUES(").append((CharSequence)values).append(')');
        sql.append(" ON DUPLICATE KEY UPDATE ");
        sql.append((CharSequence)updateClause);
        return sql.toString();
    }

    private void appendEachField(List<Column> fields, StringBuilder sql, StringBuilder values, StringBuilder updateClause) {
        boolean first = true;
        for (Column field : fields) {
            boolean needUpdate;
            boolean bl = needUpdate = !field.isPrimaryKey();
            if (first) {
                first = false;
            } else {
                sql.append(',');
                values.append(',');
                if (needUpdate && updateClause.length() > 0) {
                    updateClause.append(',');
                }
            }
            sql.append(field.getBinding());
            values.append('?');
            if (!needUpdate) continue;
            this.appendUpdateClause(updateClause, field);
        }
    }

    private void appendUpdateClause(StringBuilder updateClause, Column c) {
        updateClause.append(c.getBinding());
        updateClause.append("=VALUES(");
        updateClause.append(c.getBinding());
        updateClause.append(')');
    }
}

