/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;

public class Util {
    private static final int MAX_PARAMS_COUNT = 1000;

    public static void classify(Connection cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        if (rows.isEmpty()) {
            return;
        }
        int totalCount = rows.size();
        int step = 1000 / judgeFields.size();
        for (int i = 0; i < totalCount; i += step) {
            int from = i;
            int to = Math.min(totalCount, i + step);
            List<Map<String, Object>> block = rows.subList(from, to);
            Util.classifyBlock(cn, table, block, judgeFields, for_insert, for_update);
        }
    }

    private static void classifyBlock(Connection cn, Table table, List<Map<String, Object>> block, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        ArrayList<Object> values = new ArrayList<Object>(1000);
        ArrayList<Integer> types = new ArrayList<Integer>(1000);
        HashMap<Integer, Map<String, Object>> indexes = new HashMap<Integer, Map<String, Object>>(1000);
        StringBuilder sql = Util.generateBlockSQL(table, block, judgeFields, values, types, indexes);
        List rs = DbUtil.executeList((Connection)cn, (String)sql.toString(), values, types);
        Util.selectRowsForUpdate(rs, for_update, indexes);
        for_insert.addAll(indexes.values());
    }

    private static void selectRowsForUpdate(List<DataRow> rs, List<Map<String, Object>> for_update, Map<Integer, Map<String, Object>> indexes) {
        for (DataRow item : rs) {
            int index = D.i((Object)item.getValue(0));
            Map<String, Object> row = indexes.remove(index);
            if (row == null) continue;
            for_update.add(row);
        }
    }

    private static StringBuilder generateBlockSQL(Table table, List<Map<String, Object>> block, List<Column> judgeFields, List<Object> values, List<Integer> types, Map<Integer, Map<String, Object>> indexes) {
        StringBuilder sql = new StringBuilder();
        int index = 0;
        boolean first = true;
        String quotedName = table.getQuotedName();
        String realTableName = Util.getRealTableName(quotedName);
        for (Map<String, Object> row : block) {
            indexes.put(++index, row);
            if (!first) {
                sql.append(" UNION ALL \r\n");
            }
            sql.append("SELECT ").append(index).append(" AS IDX");
            sql.append(" FROM ");
            Util.appendTableName(sql, first, quotedName, realTableName);
            sql.append(" WHERE ");
            Util.generateWhere(sql, row, judgeFields, values, types);
            first = false;
        }
        return sql;
    }

    private static void appendTableName(StringBuilder sql, boolean first, String quotedName, String realTableName) {
        if (first) {
            sql.append(quotedName);
        } else {
            sql.append(realTableName);
        }
    }

    private static void generateWhere(StringBuilder sql, Map<String, Object> row, List<Column> judgeFields, List<Object> values, List<Integer> types) {
        for (int i = 0; i < judgeFields.size(); ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            Column field = judgeFields.get(i);
            types.add(field.getSqlType());
            sql.append(field.getBinding()).append(" =? ");
            Object outerValue = row.get(field.getName());
            DataType type = field.getDataType();
            values.add(type.forSave(type.narrow(outerValue)));
        }
    }

    private static String getRealTableName(String quotedName) {
        int j = quotedName.indexOf(64);
        String realTableName = j > 0 ? quotedName.substring(0, j) : quotedName;
        return realTableName;
    }
}

