/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc.udf;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class UserDefineDataSource
implements DataSource {
    private String driverClassName;
    private String jdbcUrl;
    private String user;
    private String pass;
    private Map<String, Object> userDefineConfig;

    public UserDefineDataSource(String url, String user, String password, DynamicObject cfg) {
        this.jdbcUrl = this.getJdbcUrl(url);
        this.driverClassName = this.getDriverClassName(cfg);
        ReflectionUtil.getClass((String)this.driverClassName);
        this.user = user;
        this.pass = password;
        String json = D.s((Object)cfg.get("attr9"));
        this.userDefineConfig = json != null ? (Map)Json.toObject((String)json) : Collections.emptyMap();
    }

    private String getDriverClassName(DynamicObject cfg) {
        String className = D.s((Object)cfg.get("attr8"));
        if (className == null) {
            throw new IllegalArgumentException("driver class name cannot be null");
        }
        return className;
    }

    private String getJdbcUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("jdbc url cannot be null");
        }
        return url;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.innerGetConnection(this.jdbcUrl, this.user, this.pass, this.userDefineConfig);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.innerGetConnection(this.jdbcUrl, username, password, this.userDefineConfig);
    }

    private Connection innerGetConnection(String url, String username, String password, Map<String, Object> userDefineConfig) throws SQLException {
        Properties properties = new Properties();
        properties.putAll(userDefineConfig);
        if (!StringUtil.isEmpty((String)username)) {
            properties.put("user", username);
        }
        if (!StringUtil.isEmpty((String)password)) {
            properties.put("password", password);
        }
        this.setLoginTimeout(30);
        return DriverManager.getConnection(url, properties);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("UserDefineDataSource don't support unwrap method.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("UserDefineDataSource don't support isWrapperFor method.");
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("UserDefineDataSource don't support getParentLogger method.");
    }
}

