/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.k3cloud.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.QueryCloudData;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudDataTypeParser;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class K3CloudBizAction {
    private static final String PARAM_FILTER_STRING = "FilterString";
    private static final String PARAM_FIELD_KEYS = "FieldKeys";
    private static final String PARAM_FORM_ID = "FormId";
    private static final Log log = LogFactory.getLog(K3CloudBizAction.class);
    private static Map<String, String> primaryKeyCacheMap = new ConcurrentHashMap<String, String>(200);
    private static Map<String, Pair<String, String>> primaryKeyTypeCacheMap = new ConcurrentHashMap<String, Pair<String, String>>(200);

    public static Response doBizAction(K3CloudProxyContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        List<String> actionList = K3CloudBizAction.adjustActions(entity, actions);
        String firstAction = actionList.get(0);
        if (firstAction.equals(TableAction._DELETE.name()) || firstAction.equalsIgnoreCase("Delete")) {
            return K3CloudBizAction.deleteCloudAction(ctx, entity, data, judgeFields);
        }
        return K3CloudBizAction.bizCloudAction(ctx, entity, data, judgeFields, actionList, targetActionParams);
    }

    private static List<String> adjustActions(String entity, List<String> actions) {
        if (CollectionUtils.isEmpty(actions)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u672a\u6307\u5b9a\u64cd\u4f5c!", (String)"K3CloudBizAction_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        ArrayList<String> actionList = new ArrayList<String>(actions);
        String firstAction = (String)actionList.get(0);
        if (firstAction.equals(TableAction._SAVE.name())) {
            actionList.set(0, "save");
        }
        return actionList;
    }

    private static Response bizCloudAction(K3CloudProxyContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        String id = K3CloudBizAction.queryPrimaryKey(ctx, entity, judgeFields, data);
        if (null == id) {
            if (actions.contains(TableAction._UPDATE.name())) {
                data.put("$reason", ResManager.loadKDString((String)"\u5f85\u4fee\u6539\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_50", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                return new Response(null, SaveDataType.NOP, null);
            }
            return K3CloudBizAction.insertCloudData(ctx, entity, data, judgeFields, actions, targetActionParams);
        }
        if (actions.contains(TableAction._INSERT.name())) {
            data.put("$reason", ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u5df2\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_51", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return new Response(null, SaveDataType.NOP, null);
        }
        return K3CloudBizAction.updateCloudData(ctx, entity, data, id, judgeFields, actions, targetActionParams);
    }

    public static Object doActions(K3CloudProxyContext ctx, List<String> actions, String entity, List<Object> paras, Object id) {
        for (String action : actions) {
            if (action.equalsIgnoreCase("save")) {
                id = K3CloudBizAction.doSaveData(ctx, paras);
                K3CloudAttachmentUtil.bindAttachment(ctx, entity, id, (Map)paras.get(1));
                continue;
            }
            if (action.equalsIgnoreCase("Submit")) {
                id = K3CloudBizAction.doSubmit(ctx, entity, id);
                continue;
            }
            if (action.equalsIgnoreCase("Audit")) {
                id = K3CloudBizAction.doAudit(ctx, entity, id);
                continue;
            }
            if (action.equalsIgnoreCase("UnAudit")) {
                id = K3CloudBizAction.doUnaudit(ctx, entity, id);
                continue;
            }
            String mes = K3CloudBizAction.getPushScriptExample();
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8c03\u7528\u661f\u7a7a\u5355\u636e\u7684\u64cd\u4f5c\uff1a\u3010%s\u3011,\u53ef\u901a\u8fc7\u670d\u52a1\u6d41\u7a0b\u4f7f\u7528\u811a\u672c\u7684\u65b9\u5f0f\u8c03\u7528\u8be5\u64cd\u4f5c\u3002\n", (String)"K3CloudBizAction_28", (String)"isc-iscb-platform-core", (Object[])new Object[0]), action) + mes);
        }
        return id;
    }

    public static String getPushScriptExample() {
        String mes1 = ResManager.loadKDString((String)"\u5982\u8c03\u7528\u8d39\u7528\u7533\u8bf7\u5355ER_ExpenseRequest\u4e0b\u63a8\u64cd\u4f5c\u7684\u793a\u4f8b\n", (String)"K3CloudBizAction_43", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        String mes2 = ResManager.loadKDString((String)"#data\u6807\u8bc6\u662f\u56fa\u5b9a\u7684,\u5217\u8868\u4e2d\u7684\u53ef\u53d8\u53c2\u6570\u9700\u8981\u53c2\u8003\u661f\u7a7aWebApi\u7684\u4ee3\u7801\u8c03\u7528\u793a\u4f8b", (String)"K3CloudBizAction_44", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        String mes3 = ResManager.loadKDString((String)"cn\u662f\u670d\u52a1\u6d41\u7a0b\u7684\u6d41\u7a0b\u5c5e\u6027\u5f15\u5165\u7684\u661f\u7a7a\u4f01\u4e1a\u7248\u6570\u636e\u6e90\u522b\u540d", (String)"K3CloudBizAction_45", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return mes1 + "var action=\"Push\";\nvar data={\n\t\t\"Ids\":\"\",\n\t\t\"Numbers\":[\n\n\t\t],\n\t\t\"EntryIds\":\"\",\n\t\t\"RuleId\":\"\",\n\t\t\"TargetBillTypeId\":\"\",\n\t\t\"TargetOrgId\":0 ,\n\t\t\"TargetFormId\":\"\",\n\t\t\"IsEnableDefaultRule\":\"false\",\n\t\t\"IsDraftWhenSaveFail\":\"false\",\n\t\t\"CustomParams\":\n\t\t\t{\n\n\t\t\t}\n\t};\nvar params={\"#data\"://" + mes2 + "\n[\n  \"ER_ExpenseRequest\",\n   String.FormatJson(data)\n]};\nvar res= $service(cn,action, params).result;//" + mes3;
    }

    private static Object doUnaudit(K3CloudProxyContext ctx, String entity, Object id) {
        String state = K3CloudBizAction.checkRepeatOperation(ctx, entity, id);
        if (null == state || !state.equalsIgnoreCase("D")) {
            id = K3CloudBizAction.doAction(ctx, entity, id, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UnAudit.common.kdsvc");
        }
        return id;
    }

    private static Object doAudit(K3CloudProxyContext ctx, String entity, Object id) {
        String state = K3CloudBizAction.checkRepeatOperation(ctx, entity, id);
        if (null == state || !state.equalsIgnoreCase("C")) {
            id = K3CloudBizAction.doAction(ctx, entity, id, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Audit.common.kdsvc");
        }
        return id;
    }

    private static Object doSubmit(K3CloudProxyContext ctx, String entity, Object id) {
        String state = K3CloudBizAction.checkRepeatOperation(ctx, entity, id);
        if (null == state || !state.equalsIgnoreCase("B") && !state.equalsIgnoreCase("C")) {
            id = K3CloudBizAction.doAction(ctx, entity, id, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Submit.common.kdsvc");
        }
        return id;
    }

    private static Object doSaveData(K3CloudProxyContext ctx, List<Object> paras) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc";
        Map updateResponse = (Map)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(paras), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        CheckResult checkResult = new CheckResult(ctx, paras, url);
        updateResponse = (Map)checkResult.check((Object)updateResponse);
        return ((Map)updateResponse.get("Result")).get("Id");
    }

    public static Object doAction(K3CloudProxyContext ctx, String entity, Object id, String api) {
        if (null == id) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$sid = %2$s,\u8bf7\u6839\u636e\u5019\u9009\u952e\u786e\u8ba4\u8be5\u5355\u636e\u662f\u5426\u5df2\u540c\u6b65\u5230\u661f\u7a7a\u7cfb\u7edf", (String)"K3CloudBizAction_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, id));
        }
        String url = ctx.getRemoteURL() + api;
        ArrayList<Object> params = new ArrayList<Object>(2);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("Ids", id);
        params.add(entity);
        params.add(param);
        Map result = null;
        try {
            result = (Map)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
            CheckResult checkResult = new CheckResult(ctx, params, url);
            result = (Map)checkResult.check((Object)result);
        }
        catch (Exception e) {
            log.warn("\u8c03\u7528\u5b9e\u4f53" + entity + "\u64cd\u4f5c" + api + "\u51fa\u9519", (Throwable)e);
            throw e;
        }
        return K3CloudBizAction.getResultId(result);
    }

    private static String checkRepeatOperation(K3CloudProxyContext ctx, String entity, Object id) {
        if (id == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5355\u636e\uff1a\u3010%s\u3011\u7684\u5355\u636e\u72b6\u6001\u65f6\uff0c\u5355\u636eid\u4e3a\u7a7a\u3002\u95ee\u9898\u6392\u67e5\uff1a", (String)"K3CloudBizAction_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity) + "\n" + ResManager.loadKDString((String)"1\u3001\u8bf7\u786e\u8ba4\u96c6\u6210\u65b9\u6848->\u76ee\u6807\u6570\u636e\u5904\u7406->\u64cd\u4f5c\u5217\u8868\u4e2d\u662f\u5426\u6309\u7167\u5148\u540e\u987a\u5e8f\u5148\u914d\u7f6e\u4e86\u3010\u4fdd\u5b58\u3011\u64cd\u4f5c\u3002", (String)"K3CloudBizAction_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"2\u3001\u8bf7\u786e\u8ba4\u5355\u636e\uff1a\u3010%s\u3011\u7684\u4fdd\u5b58\u63a5\u53e3\u662f\u5426\u4f1a\u9ed8\u8ba4\u8fd4\u56de\u5355\u636eId\u4fe1\u606f\u3002", (String)"K3CloudBizAction_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        Pair<String, String> fieldKeyInfo = K3CloudBizAction.getFieldKeyInfo(ctx, entity);
        String fieldKey = (String)fieldKeyInfo.getA();
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put(PARAM_FORM_ID, entity);
        param.put(PARAM_FIELD_KEYS, "FDocumentStatus");
        param.put(PARAM_FILTER_STRING, fieldKey + " = " + K3CloudBizAction.buildFilterValue(fieldKeyInfo, id));
        List<Object> params = Collections.singletonList(param);
        Object response = NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        CheckResult checkResult = new CheckResult(ctx, params, url);
        List result = (List)checkResult.check(response);
        if (result.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u53c2\u6570\uff1a%1$s,\u8c03\u7528\u661f\u7a7a\u3010\u5355\u636e\u67e5\u8be2\u63a5\u53e3\u3011,\u7ed3\u679c\u662f\uff1a%2$s", (String)"K3CloudBizAction_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params, response));
        }
        return D.s(((List)result.get(0)).get(0));
    }

    public static Object getResultId(Map<String, Object> result) {
        Map re = (Map)result.get("Result");
        Map responseStatus = (Map)re.get("ResponseStatus");
        List successEntitys = (List)responseStatus.get("SuccessEntitys");
        Map o = (Map)successEntitys.get(0);
        return o.get("Id");
    }

    public static Response updateCloudData(K3CloudProxyContext ctx, String entity, Map<String, Object> data, String id, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        ArrayList<Object> params = new ArrayList<Object>(2);
        Map<String, Object> updateData = K3CloudBizAction.getUpdateData(ctx, data, entity, judgeFields, id, targetActionParams);
        params.add(entity);
        params.add(updateData);
        data.put("$K3CloudBizData", params);
        K3CloudBizAction.doActions(ctx, actions, entity, params, id);
        return new Response(id, SaveDataType.UPDATE, null);
    }

    public static Response insertCloudData(K3CloudProxyContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        ArrayList<Object> params = new ArrayList<Object>(2);
        Map<String, Object> insertData = K3CloudBizAction.getInsertData(ctx, data, entity, judgeFields, targetActionParams);
        params.add(entity);
        params.add(insertData);
        data.put("$K3CloudBizData", params);
        Object id = K3CloudBizAction.doActions(ctx, actions, entity, params, null);
        return new Response(D.s((Object)id), SaveDataType.INSERT, null);
    }

    private static Map<String, Object> getUpdateData(K3CloudProxyContext ctx, Map<String, Object> data, String entity, Map<String, List<String>> judgeFields, String id, Map<String, Object> targetActionParams) {
        Map<String, Object> updateModelData = K3CloudBizAction.getModelData(ctx, data, entity, judgeFields, id, Boolean.FALSE);
        return K3CloudBizAction.getModelData(ctx, updateModelData, targetActionParams);
    }

    private static Map<String, Object> getModelData(K3CloudProxyContext ctx, Map<String, Object> modelData, Map<String, Object> targetActionParams) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(12);
        Object saveParams = targetActionParams.get("Save");
        if (saveParams instanceof Map) {
            data.putAll((Map)saveParams);
        }
        data.put("Creator", K3CloudBizAction.getCreator(ctx));
        data.put("IsDeleteEntry", D.x((Object)modelData.remove("IsDeleteEntry")));
        data.put("Model", modelData);
        return data;
    }

    private static Map<String, Object> getInsertData(K3CloudProxyContext ctx, Map<String, Object> data, String entity, Map<String, List<String>> judgeFields, Map<String, Object> targetActionParams) {
        Map<String, Object> insertModelData = K3CloudBizAction.getModelData(ctx, data, entity, judgeFields, null, Boolean.TRUE);
        return K3CloudBizAction.getModelData(ctx, insertModelData, targetActionParams);
    }

    public static Object getCreator(K3CloudProxyContext ctx) {
        String property = "Creator";
        ConnectionConfig connectionConfig = ConnectionConfig.getConnectionConfig(D.l((Object)ctx.getConfig().getPkValue()));
        Object creator = connectionConfig.getProperty(property);
        if (creator == null) {
            creator = K3CloudBizAction.getCreatorFromXK(ctx);
            connectionConfig.setProperty(property, creator);
        }
        return creator;
    }

    private static Object getCreatorFromXK(K3CloudProxyContext ctx) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        StringBuilder fname = new StringBuilder();
        fname.append("FName = ").append('\'').append(ctx.getConfig().get("user")).append('\'');
        HashMap<String, CharSequence> param = new HashMap<String, CharSequence>(3);
        param.put(PARAM_FORM_ID, "SEC_User");
        param.put(PARAM_FIELD_KEYS, "FUserID");
        param.put(PARAM_FILTER_STRING, fname);
        List params = Collections.singletonList(param);
        List createrResponse = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        int size = createrResponse.size();
        if (size > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u3010\u8fde\u63a5\u914d\u7f6e\u3011\u4e2d\u3010\u91d1\u8776\u4e91\u00b7\u661f\u7a7a\u3011\u7684\u3010\u767b\u5f55\u7528\u6237\u3011:%1$s,\u627e\u5230(%2$s)\u6761\u7528\u6237\u4fe1\u606f\u3002", (String)"K3CloudBizAction_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fname, size));
        }
        if (size < 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u3010\u8fde\u63a5\u914d\u7f6e\u3011\u4e2d\u3010\u91d1\u8776\u4e91\u00b7\u661f\u7a7a\u3011\u7684\u3010\u767b\u5f55\u7528\u6237\u3011:%s,\u662f\u5426\u5b58\u5728\u661f\u7a7a\u7cfb\u7edf\u7684\u7528\u6237\u8868\u4e2d\u3002", (String)"K3CloudBizAction_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fname));
        }
        return ((List)createrResponse.get(0)).get(0);
    }

    private static Map<String, Object> getModelData(K3CloudProxyContext ctx, Map<String, Object> data, String entity, Map<String, List<String>> judgeFields, String id, Boolean isInsert) {
        LinkedHashMap<String, Object> modelDataMap = new LinkedHashMap<String, Object>();
        Map<Object, List<Object>> metaData = K3CloudBizAction.getEntityMetaDate(ctx, entity);
        return K3CloudBizAction.getModelData(ctx, metaData, data, judgeFields, modelDataMap, id, isInsert);
    }

    public static Map<String, Object> getModelData(K3CloudProxyContext ctx, Map<Object, List<Object>> dataTypeMap, Map<String, Object> data, Map<String, List<String>> judgeFields, Map<String, Object> modelDataMap, String id, Boolean isInsert) {
        String fieldKey = K3CloudBizAction.getPrimaryKey(dataTypeMap);
        if (null != id) {
            modelDataMap.put(fieldKey, id);
        }
        String pk = D.s((Object)data.get("$pk"));
        for (Map.Entry<String, Object> cloudDataMap : data.entrySet()) {
            String cloudDataKey = cloudDataMap.getKey();
            if (null != id && cloudDataKey.equals(fieldKey)) continue;
            if (cloudDataKey.startsWith("$") || cloudDataKey.startsWith("#")) {
                modelDataMap.put(cloudDataKey, cloudDataMap.getValue());
                continue;
            }
            K3CloudSetter setter = K3CloudDataTypeParser.getSetter(ctx, data, dataTypeMap, judgeFields, cloudDataKey, isInsert);
            try {
                setter.setObjValue(modelDataMap, cloudDataMap);
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u8d4b\u503c\uff08%2$s\uff09\u51fa\u9519\uff0c\u539f\u56e0\uff1a%3$s", (String)"K3CloudBizAction_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cloudDataKey, cloudDataMap.getValue(), e.getMessage()), (Throwable)e);
            }
            if (!isInsert.booleanValue() || pk != null) continue;
            modelDataMap.remove(fieldKey);
        }
        return modelDataMap;
    }

    private void clean() {
        primaryKeyCacheMap.clear();
        primaryKeyTypeCacheMap.clear();
    }

    private static Object buildFilterValue(Pair<String, String> info, Object fieldValue) {
        if ("string".equals(info.getB())) {
            return "'" + fieldValue + "'";
        }
        return fieldValue;
    }

    public static String getFieldKey(K3CloudProxyContext ctx, String entity) {
        String pk = primaryKeyCacheMap.get(entity);
        if (pk == null) {
            Map<Object, List<Object>> metaDataToMap = K3CloudBizAction.getEntityMetaDate(ctx, entity);
            pk = K3CloudBizAction.getPrimaryKey(metaDataToMap);
            primaryKeyCacheMap.put(entity, pk);
        }
        return pk;
    }

    public static Pair<String, String> getFieldKeyInfo(K3CloudProxyContext ctx, String entity) {
        Pair pair = primaryKeyTypeCacheMap.get(entity);
        if (pair == null) {
            Map<Object, List<Object>> metaDataToMap = K3CloudBizAction.getEntityMetaDate(ctx, entity);
            Map<String, Object> temp = K3CloudBizAction.getPrimaryKeyInfo(metaDataToMap);
            pair = new Pair((Object)D.s((Object)temp.get("pk")), (Object)D.s((Object)temp.get("pk_type")));
            primaryKeyTypeCacheMap.put(entity, (Pair<String, String>)pair);
            return pair;
        }
        return pair;
    }

    public static String getPrimaryKeyBySchema(K3CloudProxyContext ctx, String schema) {
        String pk = primaryKeyCacheMap.get(schema);
        if (pk == null) {
            Map<Object, List<Object>> entityEntryMetaDataToMap = K3CloudBizAction.getEntryMetaDate(ctx, schema);
            pk = K3CloudBizAction.getPrimaryKey(entityEntryMetaDataToMap);
            primaryKeyCacheMap.put(schema, pk);
        }
        return pk;
    }

    public static String getFullNameBySchema(K3CloudProxyContext ctx, String schema) {
        if (StringUtil.isEmpty((String)schema)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7684\u6570\u636e\u6a21\u578b\u662f\uff1a%s", (String)"K3CloudBizAction_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]), schema));
        }
        DynamicObjectCollection entryMeta = QueryCloudData.getEntryMeta(ctx, schema);
        DynamicObject rootEntity = entryMeta.getRootEntity();
        String fullName = rootEntity.getString("full_name");
        String[] split = fullName.split("\\.");
        String entityFullName = null;
        if (split.length > 0) {
            entityFullName = split[0];
        }
        return entityFullName;
    }

    public static Map<Object, List<Object>> getEntityMetaDate(K3CloudProxyContext ctx, String entity) {
        if (StringUtil.isEmpty((String)entity)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5355\u636e\u7684\u5168\u540d\u662f\u7a7a\u3002", (String)"K3CloudBizAction_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObjectCollection metaData = QueryCloudData.getEntityMeta(ctx, entity);
        return K3CloudBizAction.getDataType(metaData);
    }

    public static Map<Object, List<Object>> getEntryMetaDate(K3CloudProxyContext ctx, Object schema) {
        if (ObjectUtils.isEmpty((Object)schema)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7684\u6570\u636e\u6a21\u578b\u662f\uff1a%s", (String)"K3CloudBizAction_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]), schema));
        }
        DynamicObjectCollection metaData = QueryCloudData.getEntryMeta(ctx, schema);
        return K3CloudBizAction.getDataType(metaData);
    }

    private static Map<Object, List<Object>> getDataType(DynamicObjectCollection metaData) {
        HashMap<Object, List<Object>> entryDataTypeMap = new HashMap<Object, List<Object>>(metaData.size());
        for (DynamicObject field : metaData) {
            ArrayList<Object> entryDataTypeList = new ArrayList<Object>(3);
            String prop_name = field.getString("prop_name");
            String data_type = field.getString("data_type");
            String data_schema = field.getString("data_schema");
            Boolean is_primary_key = field.getBoolean("is_primary_key");
            entryDataTypeMap.put(prop_name, entryDataTypeList);
            entryDataTypeList.add(data_type);
            entryDataTypeList.add(data_schema);
            entryDataTypeList.add(is_primary_key);
        }
        return entryDataTypeMap;
    }

    public static String getPrimaryKey(Map<Object, List<Object>> dataTypeMap) {
        for (Map.Entry<Object, List<Object>> m : dataTypeMap.entrySet()) {
            Boolean isPrimaryKey = (Boolean)m.getValue().get(2);
            if (!isPrimaryKey.booleanValue()) continue;
            return m.getKey().toString();
        }
        return null;
    }

    private static Map<String, Object> getPrimaryKeyInfo(Map<Object, List<Object>> dataTypeMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        for (Map.Entry<Object, List<Object>> m : dataTypeMap.entrySet()) {
            Boolean isPrimaryKey = (Boolean)m.getValue().get(2);
            if (!isPrimaryKey.booleanValue()) continue;
            map.put("pk", m.getKey().toString());
            map.put("pk_type", D.s((Object)m.getValue().get(0)));
            return map;
        }
        return map;
    }

    private static Response deleteCloudAction(K3CloudProxyContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields) {
        String id = K3CloudBizAction.queryPrimaryKey(ctx, entity, judgeFields, data);
        if (null == id) {
            data.put("$reason", ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_52", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return new Response(id, SaveDataType.NOP, null);
        }
        K3CloudBizAction.doAction(ctx, entity, id, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        return new Response(id, SaveDataType.DELETE, null);
    }

    private static String queryPrimaryKey(K3CloudProxyContext ctx, String entity, Map<String, List<String>> judgeFields, Map<String, Object> data) {
        List<Map<String, Object>> paramsById;
        List<List<Object>> objects;
        String id;
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        Pair<String, String> fieldKeyInfo = K3CloudBizAction.getFieldKeyInfo(ctx, entity);
        String fieldKey = (String)fieldKeyInfo.getA();
        Object fieldValue = data.get(fieldKey);
        if (!ObjectUtils.isEmpty((Object)fieldValue) && null != (id = K3CloudBizAction.getPrimaryKeyFromResponse(judgeFields, objects = K3CloudBizAction.getObjects(ctx, url, paramsById = K3CloudBizAction.getParamsById(fieldKeyInfo, entity, fieldKey, fieldValue, judgeFields)), entity))) {
            return id;
        }
        Object params = K3CloudBizAction.getParams(ctx, entity, judgeFields, data, fieldKey);
        objects = K3CloudBizAction.getObjects(ctx, url, params);
        return K3CloudBizAction.getPrimaryKeyFromResponse(judgeFields, objects, entity);
    }

    private static List<Map<String, Object>> getParamsById(Pair<String, String> fieldKeyInfo, String entity, String fieldKey, Object fieldValue, Map<String, List<String>> judgeFields) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put(PARAM_FORM_ID, entity);
        param.put(PARAM_FIELD_KEYS, K3CloudBizAction.getFieldKeys(entity, fieldKey, judgeFields));
        param.put(PARAM_FILTER_STRING, fieldKey + " = " + K3CloudBizAction.buildFilterValue(fieldKeyInfo, fieldValue));
        return Collections.singletonList(param);
    }

    private static Object getFieldKeys(String entity, String fieldKey, Map<String, List<String>> judgeFields) {
        List<String> fields = judgeFields.get("$");
        int size = fields.size();
        if (size < 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728!", (String)"K3CloudBizAction_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (fieldKey != null && !fields.contains(fieldKey)) {
            stringBuilder.append(fieldKey).append(',');
        }
        for (int i = 0; i < size; ++i) {
            String field = fields.get(i);
            stringBuilder.append(field);
            if (i >= size - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder;
    }

    private static List<List<Object>> getObjects(K3CloudProxyContext ctx, String url, Object params) {
        return (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
    }

    private static String getPrimaryKeyFromResponse(Map<String, List<String>> judgeFields, List<List<Object>> objects, String entity) {
        int size = objects.size();
        if (size < 1) {
            return null;
        }
        if (size == 1) {
            return K3CloudBizAction.getPrimaryKeyFromList(objects);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53 %1$s\u6839\u636e\u5019\u9009\u952e%2$s\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55!", (String)"K3CloudBizAction_37", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, String.join((CharSequence)",", (Iterable<? extends CharSequence>)judgeFields.get("$"))));
    }

    private static String getPrimaryKeyFromList(List<List<Object>> objects) {
        List<Object> objects1 = objects.get(0);
        Object id = objects1.get(0);
        return D.s((Object)id);
    }

    public static Object getParams(K3CloudProxyContext ctx, String entity, Map<String, List<String>> judgeFields, Map<String, Object> data, String fieldKey) {
        Object filter = K3CloudBizAction.getFilter(ctx, data, entity, judgeFields);
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put(PARAM_FORM_ID, entity);
        param.put(PARAM_FIELD_KEYS, fieldKey);
        param.put(PARAM_FILTER_STRING, filter);
        return Collections.singletonList(param);
    }

    private static Object getFilter(K3CloudProxyContext ctx, Map<String, Object> data, String entity, Map<String, List<String>> judgeFields) {
        List<String> fields = judgeFields.get("$");
        if (fields == null || fields.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728!", (String)"K3CloudBizAction_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        StringBuilder fieldParam = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            Object fieldValue = data.get(field);
            if (i < fields.size() - 1) {
                fieldParam.append(field).append('=').append('\'').append(K3CloudBizAction.getFieldValue(ctx, fieldValue)).append('\'').append(" AND ");
                continue;
            }
            fieldParam.append(field).append('=').append('\'').append(K3CloudBizAction.getFieldValue(ctx, fieldValue)).append('\'');
        }
        return fieldParam;
    }

    public static Object getFieldValue(K3CloudProxyContext ctx, Object fieldValue) {
        if (!ObjectUtils.isEmpty((Object)fieldValue) && fieldValue instanceof Map) {
            Map m = (Map)fieldValue;
            Object icid = ctx.getConfig().get("icid");
            return m.get(icid);
        }
        return fieldValue;
    }
}

