/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.AttachUtil;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ExtensibleConnectionFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.K3ApiCookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudBizAction;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudConnectionWrapper;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.QueryCloudData;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentInputStream;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentOutputStream;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.EntityInfo;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.EnumInfo;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;

public final class K3CloudProxyConnectFactory
implements ExtensibleConnectionFactory {
    private Script loginScript;
    private Script invokeScript;
    private Script refreshScript;

    @Override
    public void bindScript(String loginScript, String refreshScript, String invokeScript, String testScript, String extensions) {
        this.loginScript = Script.compile((String)loginScript);
        this.invokeScript = Script.compile((String)invokeScript);
        this.refreshScript = Script.compile((String)refreshScript);
    }

    @Override
    public ConnectionWrapper create(DynamicObject cfg) {
        return new K3CloudConnectionWrapper(this, cfg);
    }

    @Override
    public void test(ConnectionWrapper cn) {
        DynamicObject cfg = cn.getConfig();
        WebApiConnectionFactory.checkWebApiTestScript(cfg, this.getClass());
        K3CloudProxyContext ctx = new K3CloudProxyContext(cfg);
        CookieCache.connectCloud(ctx);
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return K3CloudUtil.getMetaList(ctx);
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return EntityInfo.getEntityInfo(ctx, name);
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return EnumInfo.getEnumInfo(ctx, name);
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        try {
            K3CloudProxyConnectFactory.parseFilter(filter);
            return QueryCloudData.get(ctx, entity, requires, filter, orderBy);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    private static void parseFilter(List<Map<String, Object>> filter) {
        for (Map<String, Object> map : filter) {
            String tempValue;
            String filterCompare = D.s((Object)map.get("filter_compare"));
            Object filter_value = map.get("filter_value");
            if (!"in".equalsIgnoreCase(filterCompare) && !"not in".equalsIgnoreCase(filterCompare) || !(filter_value instanceof String) || (tempValue = D.s((Object)filter_value)) == null || tempValue.startsWith("[") || tempValue.endsWith("]")) continue;
            String meg = String.format(ResManager.loadKDString((String)"\u6e90\u662f\u661f\u7a7a\u4f01\u4e1a\u7248,\u8fc7\u6ee4\u6761\u4ef6\u662fin\u548cnot in\u7684\u65f6\u5019,\u8fc7\u6ee4\u7684\u503c\u9700\u8981\u662f\u4ee5\u4e0b\u683c\u5f0f[123]\u3001[123,456]\u3001['abc']\u3001['abc','edf'],\u5f53\u524d\u8f93\u5165\u7684\u503c\u4e3a%s\u3002", (String)"K3CloudProxyConnectFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter_value);
            throw new IscBizException(meg);
        }
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        try {
            return this.doBizAction(cn, entity, data, judgeFields, actions, Collections.emptyMap(), proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        try {
            return K3CloudBizAction.doBizAction(ctx, entity, data, judgeFields, actions, targetActionParams, proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    @Override
    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        DynamicObject cfg = cn.getConfig();
        Object session = K3ApiCookieCache.get(cfg, this.loginScript);
        Map<String, Object> ctx = K3ApiCookieCache.createContext(cfg, session);
        ctx.put("$service", service);
        ctx.put("$params", params);
        ctx.put("$proxy_user", proxyUser);
        try {
            return this.invokeScript.eval(ctx);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    Script getLoginScript() {
        return this.loginScript;
    }

    public Script getRefreshScript() {
        return this.refreshScript;
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u83b7\u53d6API\u5143\u6570\u636e\u3002", (String)"K3CloudProxyConnectFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u6570\u636e\u8868\u67e5\u8be2\u3002", (String)"K3CloudProxyConnectFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u8c03\u7528\u6570\u636e\u5904\u7406\u7c7b\u3002", (String)"K3CloudProxyConnectFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u89e3\u9664\u4e8b\u4ef6\u7ed1\u5b9a\u3002", (String)"K3CloudProxyConnectFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u4e0d\u652f\u6301\u4e8b\u4ef6\u89e6\u53d1\uff0c\u8bf7\u4f7f\u7528 \u5b9a\u65f6\u542f\u52a8 \u589e\u91cf\u96c6\u6210\uff0c\u6216\u661f\u7a7a\u5355\u636e\u4e8c\u5f00\u4e3b\u52a8\u8c03\u7528\u96c6\u6210\u4e91\u7684\u542f\u52a8\u65b9\u6848/\u96c6\u6210\u65b9\u6848\u8f6cAPI\u63a8\u9001\u6570\u636e\u3002", (String)"K3CloudProxyConnectFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public boolean supportsRemoteDeploy() {
        return false;
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case ENTITY: {
                return true;
            }
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsAttachment(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public boolean isAttachmentChanged(ConnectionWrapper cn, Map<String, Object> fileInfo, String md5Code) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return K3CloudAttachmentUtil.isAttachmentChanged(ctx, fileInfo, md5Code);
    }

    @Override
    public AbstractInputStream getAttachmentReader(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return new K3CloudAttachmentInputStream(ctx, fileInfo);
    }

    @Override
    public AbstractOutputStream getAttachmentWriter(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        K3CloudProxyContext ctx = new K3CloudProxyContext(cn.getConfig());
        return new K3CloudAttachmentOutputStream(ctx, fileInfo, AttachUtil.getBlockSize());
    }

    static {
        Functions.init();
    }
}

