/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.attachment;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class K3CloudAttachmentOutputStream
extends AbstractOutputStream {
    public static final int MAX_SIZE = 0x100000;
    private K3CloudProxyContext ctx;
    private byte[] buffer;
    private String fileName;
    private int count;
    private int index;
    private String fileId;
    private String fileType;
    private int blockSize;
    private Timestamp attachCreateTime;
    private String attachCreator;

    public K3CloudAttachmentOutputStream() {
    }

    public K3CloudAttachmentOutputStream(K3CloudProxyContext ctx, Map<String, Object> fileInfo, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.ctx = ctx;
        this.blockSize = Math.min(0x100000, size);
        this.buffer = new byte[this.blockSize];
        this.fileType = D.s((Object)fileInfo.get("type"));
        this.fileName = D.s((Object)fileInfo.get("name")) + "." + this.fileType;
        this.count = 0;
        this.attachCreateTime = D.t((Object)fileInfo.get("attachCreateTime"));
        this.attachCreator = D.s((Object)fileInfo.get("attachCreator"));
    }

    public String getAttachmentId() {
        return this.fileId;
    }

    public void markError() {
    }

    public void write(int b) {
        ++this.count;
        if (this.index == this.blockSize) {
            this.flushBuffer(false);
        }
        this.buffer[this.index++] = (byte)b;
    }

    private void flushBuffer(boolean last) {
        this.uploadAttachment(last);
        this.buffer = new byte[this.blockSize];
        this.index = 0;
    }

    private void uploadAttachment(boolean last) {
        String attachmentOutURL = this.ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UploadFile.common.kdsvc";
        Map<String, Object> params = this.getParams(last);
        Map response = (Map)NetUtil.httpInvoke((String)attachmentOutURL, params, (String)"UTF-8", (NetUtil.ConnectionDecorator)CookieCache.get(this.ctx.getConfig()));
        this.parseResult(params, response);
    }

    public void parseResult(Map<String, Object> params, Map<String, Object> response) {
        Map result = (Map)response.get("Result");
        Map responseStatus = (Map)result.get("ResponseStatus");
        boolean isSuccess = D.x(responseStatus.get("IsSuccess"));
        if (!isSuccess) {
            Map data = (Map)params.get("data");
            HashMap map = new HashMap(data.size());
            for (Map.Entry entry : data.entrySet()) {
                if ("SendByte".equals(entry.getKey())) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff0c\u5165\u53c2\uff1a%1$s\uff0c\u539f\u59cb\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%2$s", (String)"K3CloudAttachmentOutputStream_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Json.toString(map), response));
        }
        this.fileId = D.s(result.get("FileId"));
    }

    private Map<String, Object> getParams(boolean last) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        HashMap<String, Object> data = new HashMap<String, Object>(12);
        data.put("FileName", this.fileName);
        data.put("IsLast", last);
        if (this.fileId != null) {
            data.put("FileId", this.fileId);
        }
        data.put("SendByte", Base64.getEncoder().encodeToString(this.getBuffer(last)));
        params.put("data", data);
        return params;
    }

    private byte[] getBuffer(boolean last) {
        if (last) {
            byte[] bs = new byte[this.index];
            System.arraycopy(this.buffer, 0, bs, 0, this.index);
            return bs;
        }
        return this.buffer;
    }

    public void close() throws IOException {
        this.flushBuffer(true);
        if (this.fileId == null) {
            return;
        }
        AttachmentUtil.saveTempAttachmentDetail(K3CloudAttachmentUtil.getAttachTempId(this.fileId), this.fileName, this.fileType, null, this.count, null, null, this.attachCreateTime, this.attachCreator);
    }
}

