/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.metadata;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudMLStringSetter;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class K3CloudUtil {
    public static Map<String, MetaType> getMetaList(K3CloudProxyContext ctx) {
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(16);
        K3CloudUtil.getEntityList(ctx, metas);
        K3CloudUtil.getEnumList(ctx, metas);
        return metas;
    }

    public static void getEnumList(K3CloudProxyContext ctx, Map<String, MetaType> metas) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        int limit = 2000;
        int startRow = 0;
        int i = 0;
        K3CloudUtil.getEnumList(ctx, metas, url, limit, startRow, i);
    }

    private static void getEnumList(K3CloudProxyContext ctx, Map<String, MetaType> metas, String url, int limit, int startRow, int i) {
        startRow += i * limit;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("FormId", "BOS_EnumBill");
        param.put("FieldKeys", "fid");
        param.put("StartRow", startRow);
        List params = Collections.singletonList(param);
        List enumList = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        if (enumList.size() < 1) {
            throw new IscBizException("enumList size is :" + enumList.size());
        }
        for (List enmu : enumList) {
            metas.put(enmu.get(0).toString(), MetaType.ENUM);
        }
        if (enumList.size() < 2000) {
            return;
        }
        K3CloudUtil.getEnumList(ctx, metas, url, limit, startRow, ++i);
    }

    public static void getEntityList(K3CloudProxyContext ctx, Map<String, MetaType> metas) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        int limit = 2000;
        int i = 0;
        K3CloudUtil.getEntityList(ctx, metas, url, limit, i);
    }

    private static void getEntityList(K3CloudProxyContext ctx, Map<String, MetaType> metas, String url, int limit, int i) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("FormId", "BOS_ObjectType");
        param.put("FieldKeys", "fid");
        param.put("FilterString", "FMODELTYPEID in (100,400) and Fdevtype !=2");
        param.put("StartRow", i * limit);
        List params = Collections.singletonList(param);
        List entityList = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        if (entityList.size() < 1) {
            throw new IscBizException("metaList size is :" + entityList.size());
        }
        for (List entity : entityList) {
            metas.put(entity.get(0).toString(), MetaType.ENTITY);
        }
        if (entityList.size() < 2000) {
            return;
        }
        K3CloudUtil.getEntityList(ctx, metas, url, limit, ++i);
    }

    public static String generateURL(DynamicObject cfg) {
        String protocal = K3CloudUtil.getHttpProtocal(cfg);
        return protocal + "://" + cfg.get("server_ip") + ":" + cfg.get("server_port") + cfg.get("web_app");
    }

    public static Object getParas(DynamicObject cfg) {
        ArrayList<Object> paras = new ArrayList<Object>(4);
        Object dc = cfg.get("data_center");
        Object user = cfg.get("user");
        Object pw = cfg.get("password");
        Integer icid = K3CloudMLStringSetter.getMLkay(cfg.get("icid"));
        K3CloudUtil.checkParams(dc, user, pw);
        paras.add(dc);
        paras.add(user);
        paras.add(pw);
        paras.add(icid);
        return paras;
    }

    private static void checkParams(Object dc, Object user, Object pw) {
        if (ObjectUtils.isEmpty((Object)dc)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"K3CloudUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)user)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"K3CloudUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)pw)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"K3CloudUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private static String getHttpProtocal(DynamicObject cfg) {
        String protocal = D.s((Object)cfg.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        return protocal;
    }

    public static Object getRequestParams(Object paras) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        UUID uuid = UUID.randomUUID();
        int hashCode = uuid.toString().hashCode();
        params.put("format", 1);
        params.put("useragent", "ApiClient");
        params.put("rid", hashCode);
        params.put("parameters", K3CloudUtil.chinaToUnicode(Json.toString((Object)paras, (boolean)true)));
        params.put("timestamp", new Date().toString());
        params.put("v", "1.0");
        return params;
    }

    private static String chinaToUnicode(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            if (chr1 >= '\u4e00' && chr1 <= '\u29fa5') {
                result.append("\\u").append(Integer.toHexString(chr1));
                continue;
            }
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    public static List<String> getDataCenterList(String protocal, String ip, String port, String app) {
        if (StringUtil.isEmpty((String)protocal) || StringUtil.isEmpty((String)ip) || StringUtil.isEmpty((String)port) || StringUtil.isEmpty((String)app)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u534f\u8bae\uff0cip\uff0c\u7aef\u53e3\uff0cWeb\u5e94\u7528\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"K3CloudUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return K3CloudUtil.getDataCenters(protocal, ip, port, app);
    }

    private static List<String> getDataCenters(String protocal, String ip, String port, String app) {
        String url = protocal + "://" + ip + ":" + port + app + "Kingdee.BOS.ServiceFacade.ServicesStub.Account.AccountService.GetDataCenterList.common.kdsvc";
        String response = NetUtil.httpRead((String)url, (String)"UTF-8");
        List results = (List)JSON.parseObject((String)response, List.class);
        ArrayList<String> ids = new ArrayList<String>(results.size());
        for (Map result : results) {
            String number = D.s(result.get("Number"));
            String id = D.s(result.get("Id"));
            char space = '\u3000';
            ids.add(number + space + '(' + id + ')');
        }
        return ids;
    }
}

