/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.setter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.isc.iscb.platform.core.connector.k3cloud.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudBizAction;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;

public class K3CloudF7Setter
implements K3CloudSetter {
    private Map<Object, List<Object>> dataTypeMap;
    private K3CloudProxyContext ctx;

    public K3CloudF7Setter(K3CloudProxyContext ctx, Map<Object, List<Object>> dataTypeMap) {
        this.dataTypeMap = dataTypeMap;
        this.ctx = ctx;
    }

    @Override
    public void setObjValue(Map<String, Object> modelDataMap, Map.Entry<String, Object> cloudDataMap) {
        HashMap<String, Object> cloumMap = new HashMap<String, Object>(16);
        String cloudDataMapKey = cloudDataMap.getKey();
        Object cloudDataMapValue = cloudDataMap.getValue();
        String entity = D.s((Object)this.dataTypeMap.get(cloudDataMapKey).get(1));
        String fieldKey = K3CloudBizAction.getPrimaryKeyBySchema(this.ctx, entity);
        if (cloudDataMapValue instanceof Map) {
            this.setRefFromMap(modelDataMap, cloumMap, cloudDataMapKey, (Map)cloudDataMapValue, entity, fieldKey);
        } else {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, cloudDataMapValue);
        }
    }

    private void setRefFromMap(Map<String, Object> modelDataMap, Map<String, Object> cloumMap, String cloudDataMapKey, Map<String, Object> cloudDataMapValue, String entity, String fieldKey) {
        if (this.isEmpty(cloudDataMapValue)) {
            modelDataMap.put(cloudDataMapKey, null);
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(cloudDataMapValue);
        Object fieldValue = data.remove(fieldKey);
        Object defaultValue = data.remove("$default");
        if (!ObjectUtils.isEmpty(fieldValue)) {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, fieldValue);
        } else if (!data.isEmpty()) {
            Object id = this.queryIdByData(entity, data, fieldKey);
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, id);
        } else if (!ObjectUtils.isEmpty(defaultValue)) {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, defaultValue);
        }
    }

    private boolean isEmpty(Map<String, Object> cloudDataMapValue) {
        boolean b = true;
        for (Object value : cloudDataMapValue.values()) {
            if (value == null || "".equals(value)) continue;
            b = false;
            break;
        }
        return b;
    }

    private Object queryIdByData(String entity, Map<String, Object> data, String fieldKey) {
        String url = this.ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("FormId", entity);
        param.put("FieldKeys", fieldKey);
        param.put("FilterString", this.getFilter(data));
        List<Object> params = Collections.singletonList(param);
        List obj = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(this.ctx.getConfig()));
        CheckResult checkResult = new CheckResult(this.ctx, params, url);
        obj = (List)checkResult.check(obj);
        if (ObjectUtils.isEmpty((Object)obj)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff1a (%1$s) \u4e2d\u4e0d\u5b58\u5728\u6761\u4ef6\u4e3a (%2$s) \u7684\u6570\u636e", (String)"K3CloudF7Setter_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, data));
        }
        return ((List)obj.get(0)).get(0);
    }

    private Object getFilter(Map<String, Object> data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> m : data.entrySet()) {
            stringBuilder.append(m.getKey()).append(" = ").append('\'').append(K3CloudBizAction.getFieldValue(this.ctx, m.getValue())).append('\'').append(" and ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 5);
    }
}

