/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.setter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.isc.iscb.platform.core.connector.k3cloud.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudBizAction;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class K3CloudMultiREFSetter
implements K3CloudSetter {
    private Map<Object, List<Object>> dataTypeMap;
    private Map<String, Object> data;
    private K3CloudProxyContext ctx;

    public K3CloudMultiREFSetter(K3CloudProxyContext ctx, Map<String, Object> data, Map<Object, List<Object>> dataTypeMap) {
        this.data = data;
        this.dataTypeMap = dataTypeMap;
        this.ctx = ctx;
    }

    @Override
    public void setObjValue(Map<String, Object> modelDataMap, Map.Entry<String, Object> cloudDataMap) {
        String key = cloudDataMap.getKey();
        Object value = cloudDataMap.getValue();
        List<Object> properList = this.dataTypeMap.get(key);
        String type = D.s((Object)properList.get(0));
        if (StringUtil.isEmpty((String)type)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff1a%1$s\u7684\u6570\u636e\u7c7b\u578b\u683c\u5f0f\u662f%2$s", (String)"K3CloudMultiREFSetter_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, type));
        }
        String[] types = type.split("\\?");
        if (types.length < 2) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff1a%1$s\u7684\u6570\u636e\u7c7b\u578b\u683c\u5f0f\u662f%2$s,\u8bf7\u91cd\u65b0\u540c\u6b65\u96c6\u6210\u5bf9\u8c61", (String)"K3CloudMultiREFSetter_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, type));
        }
        String controlFieldKey = types[1];
        if (controlFieldKey.equalsIgnoreCase("null") || StringUtils.isEmpty((CharSequence)controlFieldKey)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff1a%s\u5173\u8054\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u540c\u6b65\u96c6\u6210\u5bf9\u8c61", (String)"K3CloudMultiREFSetter_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
        }
        String formId = D.s((Object)this.data.get(controlFieldKey));
        if (formId == null && value != null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff1a%s\u7c7b\u578b\u5b57\u6bb5\u672a\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u96c6\u6210\u65b9\u6848\u662f\u5426\u914d\u7f6e\u4e86\u6620\u5c04\u5173\u7cfb.", (String)"K3CloudMultiREFSetter_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), controlFieldKey));
        }
        this.buildRefData(modelDataMap, cloudDataMap, formId);
    }

    public void buildRefData(Map<String, Object> model, Map.Entry<String, Object> refData, String typeFormId) {
        String refProp = refData.getKey();
        Object refValue = refData.getValue();
        String refPKProp = this.getRefPrimaryKeyProp(refProp);
        if (refValue instanceof Map) {
            this.buildRefDataFromMap(model, refProp, (Map)refValue, typeFormId, refPKProp);
        } else {
            HashMap<String, Object> refPKData = new HashMap<String, Object>(2);
            refPKData.put(refPKProp, refValue);
            model.put(refProp, refPKData);
        }
    }

    private String getRefPrimaryKeyProp(String refProp) {
        String entity = D.s((Object)this.dataTypeMap.get(refProp).get(1));
        return K3CloudBizAction.getPrimaryKeyBySchema(this.ctx, entity);
    }

    private void buildRefDataFromMap(Map<String, Object> model, String refProp, Map<String, Object> refValue, String typeFormId, String refPKProp) {
        if (this.isEmpty(refValue)) {
            model.put(refProp, null);
            return;
        }
        String typeFormPkProp = K3CloudBizAction.getPrimaryKeyBySchema(this.ctx, typeFormId);
        HashMap<String, Object> refData = new HashMap<String, Object>(refValue);
        Object pkValue = refData.remove(typeFormPkProp);
        Object defaultValue = refData.remove("$default");
        HashMap<String, Object> refPKData = new HashMap<String, Object>(2);
        if (!ObjectUtils.isEmpty(pkValue)) {
            Object id = this.queryIdByData(typeFormId, typeFormPkProp, pkValue);
            refPKData.put(refPKProp, id);
        } else if (!refData.isEmpty()) {
            Object id = this.queryIdByData(typeFormId, typeFormPkProp, refData);
            refPKData.put(refPKProp, id);
        } else if (!ObjectUtils.isEmpty(defaultValue)) {
            Object id = this.queryIdByData(typeFormId, typeFormPkProp, defaultValue);
            refPKData.put(refPKProp, id);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u8d4b\u503c\u5931\u8d25\uff0c\u5b57\u6bb5\uff1a\u3010%1$s\u3011,\u6e90\u5355\u8d4b\u503c\u4e3a\uff1a%2$s", (String)"K3CloudMultiREFSetter_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), refProp, refValue));
        }
        model.put(refProp, refPKData);
    }

    private boolean isEmpty(Map<String, Object> refValue) {
        for (Object value : refValue.values()) {
            String s = D.s((Object)value);
            if (s == null) continue;
            return false;
        }
        return true;
    }

    private Object queryIdByData(String typeFormId, String typeFormPkProp, Object refData) {
        String url = this.ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        Object filter = this.getFilter(refData, typeFormPkProp);
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("FormId", typeFormId);
        param.put("FieldKeys", typeFormPkProp);
        param.put("FilterString", filter);
        List<Object> params = Collections.singletonList(param);
        List response = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(this.ctx.getConfig()));
        CheckResult checkResult = new CheckResult(this.ctx, params, url);
        response = (List)checkResult.check(response);
        if (ObjectUtils.isEmpty((Object)response)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff1a (%1$s) \u4e2d\u4e0d\u5b58\u5728\u6761\u4ef6\u4e3a (%2$s) \u7684\u6570\u636e", (String)"K3CloudMultiREFSetter_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), typeFormId, filter));
        }
        return ((List)response.get(0)).get(0);
    }

    private Object getFilter(Object refData, String fieldKey) {
        StringBuilder filter = new StringBuilder();
        if (refData instanceof Map) {
            return this.getFilterFromMap((Map)refData, filter);
        }
        filter.append(fieldKey).append(" = ").append('\'').append(refData).append('\'');
        return filter;
    }

    private String getFilterFromMap(Map<String, Object> refData, StringBuilder filter) {
        int i = 0;
        for (Map.Entry<String, Object> data : refData.entrySet()) {
            if (i > 0) {
                filter.append(" and ");
            }
            String key = data.getKey();
            Object value = K3CloudBizAction.getFieldValue(this.ctx, data.getValue());
            filter.append(key).append(" = ").append('\'').append(value).append('\'');
            ++i;
        }
        return filter.toString();
    }
}

