/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ldap.functions;

import kd.isc.iscb.platform.core.util.ContextUtil;

public class LdapUtil {
    public static String encodeFilter(String filter) {
        if (LdapUtil.dontNeedEncode()) {
            return filter;
        }
        return LdapUtil.escapeLDAPSearchFilter(filter);
    }

    private static String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    public static boolean dontNeedEncode() {
        String disableLdapEncode = ContextUtil.getTenantProperty("ISC_DISABLE_LDAP_ENCODE");
        return "true".equalsIgnoreCase(disableLdapEncode);
    }
}

