/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.meta.doc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.meta.doc.Const;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.FileUtil;
import kd.isc.iscb.util.script.core.Reference;

public class ExportMetaXML
extends AbstractFormPlugin
implements Const {
    private final DynamicObject meta;
    private final Map<String, Object> info;

    public ExportMetaXML(DynamicObject meta, Map<String, Object> info) {
        this.meta = meta;
        this.info = info;
    }

    public void export(IFormView view) {
        String fileName = this.getFileName();
        this.export(view, fileName);
    }

    private String getFileName() {
        return "xml/metaEntity.xml";
    }

    private void export(IFormView view, String filename) {
        this.exportApiWord(view, filename);
    }

    private void exportApiWord(IFormView view, String fileName) {
        File file = this.getWordFile(fileName);
        ExportAndImportFormUtil.download(view, file.getAbsolutePath(), ExportAndImportFormUtil.getDownloadFileName(this.meta) + ".doc");
    }

    private File getWordFile(String fileName) {
        String xml = this.readXml(fileName);
        HashMap<String, Reference> ctx = new HashMap<String, Reference>(1);
        ctx.put("info", Reference.create((String)"info"));
        Format format = Format.parse((String)xml, ctx);
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(1);
        data.put("info", this.info);
        String result = format.translate(data);
        return this.outputXml(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readXml(String fileName) {
        String xml;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d44\u6e90\u6587\u4ef6\uff01", (String)"ExportMetaXML_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            xml = FileUtil.read((InputStream)in);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
        return xml;
    }

    private File outputXml(String string) {
        File file;
        File file2 = DocFileUtil.newTempXmlFile();
        OutputStream out = null;
        try {
            out = Files.newOutputStream(file2.toPath(), new OpenOption[0]);
            out.write(string.getBytes(StandardCharsets.UTF_8));
            file = file2;
        }
        catch (IOException e) {
            try {
                throw CommonError.OUTPUT_WRITER_FAILURE.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(out);
                throw throwable;
            }
        }
        DbUtil.close((OutputStream)out);
        return file;
    }
}

