/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.meta.doc.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.meta.doc.builder.EntryInfoBuilder;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class PropertyBuilder
implements EntryInfoBuilder {
    @Override
    public Map<String, Object> build(DynamicObject meta) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList propEntry = new ArrayList(6);
        HashMap<String, Map<String, Long>> pkValues = new HashMap<String, Map<String, Long>>();
        pkValues.put("ENTRIES", new HashMap());
        pkValues.put("ENUM", new HashMap());
        int index = 0;
        for (DynamicObject object : meta.getDynamicObjectCollection("prop_entryentity")) {
            HashMap<String, Object> item = new HashMap<String, Object>(6);
            item.put("index", ++index);
            item.put("number", D.s((Object)object.get("prop_name")));
            item.put("title", D.s((Object)object.get("prop_label")));
            item.put("datatype", D.s((Object)object.get("data_type")));
            String temp = D.s((Object)object.get("data_schema"));
            item.put("modaltype", temp);
            item.put("pk", D.s((Object)object.get("is_primary_key")));
            propEntry.add(item);
            if ("bd_attachment".equalsIgnoreCase(temp) || "bos_attachment".equalsIgnoreCase(temp)) continue;
            this.findNextEntry(pkValues, object, meta);
        }
        this.buildItemsInfo(pkValues, info);
        info.put("proptable", propEntry);
        return info;
    }

    private void findNextEntry(Map<String, Map<String, Long>> pkValues, DynamicObject obj, DynamicObject meta) {
        String type = D.s((Object)obj.get("data_type"));
        if (!"ENTRIES".equals(type) && !"ENUM".equals(type)) {
            return;
        }
        DynamicObject dynamicObject = this.getDynamicObject(obj, meta);
        Long pkID = D.l((Object)dynamicObject.getPkValue());
        String number = D.s((Object)obj.get("data_schema"));
        if (!pkValues.get(type).containsKey(number)) {
            pkValues.get(type).put(number, pkID);
            if ("ENTRIES".equals(type)) {
                DynamicObjectCollection prop_entry = dynamicObject.getDynamicObjectCollection("prop_entryentity");
                for (DynamicObject object : prop_entry) {
                    this.findNextEntry(pkValues, object, meta);
                }
            }
        }
    }

    private DynamicObject getDynamicObject(DynamicObject obj, DynamicObject meta) {
        try {
            DynamicObject source = (DynamicObject)meta.get("group");
            QFilter qFilter = new QFilter("group", "=", (Object)D.l((Object)source.getPkValue())).and("number", "=", obj.get("data_schema"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_metadata_schema", (String)"", (QFilter[])new QFilter[]{qFilter});
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"isc_metadata_schema");
            return dynamicObject;
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u96c6\u6210\u5bf9\u8c61\u4e2d\u672a\u627e\u5230%2$s(%3$s),\u8bf7\u5148\u540c\u6b65\u8be5\u96c6\u6210\u5bf9\u8c61\u3002", (String)"PropertyBuilder_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s((Object)meta.get("number")), D.s((Object)obj.get("data_type")), D.s((Object)obj.get("data_schema"))) + "\n ", (Throwable)e);
        }
    }

    private void buildItemsInfo(Map<String, Map<String, Long>> itemPkValues, Map<String, Object> info) {
        this.buildItemsInfo(itemPkValues, "enumtable", "ENUM", info);
        this.buildItemsInfo(itemPkValues, "entrytable", "ENTRIES", info);
    }

    private void buildItemsInfo(Map<String, Map<String, Long>> itemPkValues, String itemType, String type, Map<String, Object> info) {
        ArrayList complexModel = (ArrayList)info.get(itemType);
        if (null == complexModel) {
            complexModel = new ArrayList(10);
        }
        for (Long pkId : itemPkValues.get(type).values()) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"isc_metadata_schema");
            HashMap<String, Object> item = new HashMap<String, Object>(2);
            item.put("title", type + "(" + D.s((Object)object.get("number")) + ")");
            List<Map<String, Object>> complexModelTable = this.getComplexModelTable(object, type);
            item.put("table", complexModelTable);
            complexModel.add(item);
        }
        info.put(itemType, complexModel);
    }

    private List<Map<String, Object>> getComplexModelTable(DynamicObject object, String type) {
        if (type.equals("ENUM")) {
            return this.buildEnumItemInfo(object);
        }
        if (type.equals("ENTRIES")) {
            return this.buildEntriesItemInfo(object);
        }
        return null;
    }

    private List<Map<String, Object>> buildEnumItemInfo(DynamicObject object) {
        int index = 0;
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject it : object.getDynamicObjectCollection("consts_entryentity")) {
            HashMap<String, Object> item = new HashMap<String, Object>(4);
            item.put("index", ++index);
            item.put("name", it.getString("const_value"));
            item.put("desc", it.getString("const_label"));
            item.put("other", it.getString("const_remark"));
            table.add(item);
        }
        return table;
    }

    private List<Map<String, Object>> buildEntriesItemInfo(DynamicObject object) {
        int index = 0;
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject it : object.getDynamicObjectCollection("prop_entryentity")) {
            HashMap<String, Object> item = new HashMap<String, Object>(6);
            item.put("index", ++index);
            item.put("number", D.s((Object)it.get("prop_name")));
            item.put("title", D.s((Object)it.get("prop_label")));
            item.put("datatype", D.s((Object)it.get("data_type")));
            item.put("modaltype", D.s((Object)it.get("data_schema")));
            item.put("pk", D.s((Object)it.get("is_primary_key")));
            table.add(item);
        }
        return table;
    }
}

