/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.olap;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.olap.OlapConnectionPool;
import kd.isc.iscb.platform.core.connector.olap.OlapConnectionProxy;
import kd.isc.iscb.platform.core.connector.olap.OlapConstant;
import kd.isc.iscb.platform.core.connector.olap.OlapContext;
import kd.isc.iscb.platform.core.connector.olap.OlapCube;
import kd.isc.iscb.platform.core.connector.olap.OlapMember;
import kd.isc.iscb.platform.core.connector.olap.OlapReader;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;

public class OlapConnectionWrapper
extends ConnectionWrapper
implements OlapConstant {
    private static final Map<String, String> DIMENSION_TITLE = new HashMap<String, String>(24);
    private static Map<String, OlapConnectionPool> CONNECTION_PROVIDERS;

    public OlapConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
    }

    @Override
    public void close() {
    }

    public void test(DynamicObject cfg) {
        try (OlapConnection cn = this.openConnection(cfg, null);){
            this.executeGetMetaDataFunction(cn, "", "false");
        }
    }

    /*
     * Loose catch block
     */
    public Map<String, MetaType> getMetaList(DynamicObject cfg) {
        try (OlapConnectionProxy connectionProxy = this.getConnectionProxy(cfg, null);){
            try (OlapConnection cn = connectionProxy.getOlapConnection();){
                PropertyBag metaData = this.executeGetMetaDataFunction(cn, "", "true");
                Map<String, MetaType> map = this.parseMetaList(metaData);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private Map<String, MetaType> parseMetaList(PropertyBag metaData) {
        String[] cubeNames;
        String children = D.s((Object)metaData.get("children"));
        HashMap<String, MetaType> response = new HashMap<String, MetaType>(24);
        if (children == null) {
            return response;
        }
        for (String cubeName : cubeNames = children.split("\n")) {
            response.put(cubeName, MetaType.ENTITY);
        }
        return response;
    }

    private PropertyBag executeGetMetaDataFunction(OlapConnection cn, String s, String children) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", s);
        propertyBag.set("children", children);
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(cn, (CommandInfo)functionCommandInfo);
        return cmd.executeFunction();
    }

    public List<Map<String, Object>> getEntityInfo(DynamicObject cfg, String cubeName) {
        String[] split = cubeName.split("\\.");
        String dimensionName = null;
        if (split.length == 2) {
            cubeName = split[0];
            dimensionName = split[1];
        }
        String[] dimensionNames = this.getDimensionNames(cfg, cubeName);
        String caption = this.getCaption(cfg, cubeName);
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>(dimensionNames.length + 1);
        if (dimensionName == null) {
            this.buildEntity(entities, dimensionNames, cubeName, caption);
            this.buildEntry(entities, dimensionNames, cubeName, caption);
        } else {
            this.buildEntry(entities, new String[]{dimensionName}, cubeName, caption);
        }
        return entities;
    }

    private void buildEntry(List<Map<String, Object>> entities, String[] dimensionNames, String cubeName, String caption) {
        for (String dimensionName : dimensionNames) {
            if (dimensionName.equals("FMONEY")) continue;
            HashMap<String, Object> entityInfo = new HashMap<String, Object>(12);
            String fullName = cubeName + "." + dimensionName;
            String title = caption + "." + dimensionName;
            String dataSchema = Hash.mur32((Object[])new Object[]{fullName});
            this.setBaseInfo(entityInfo, fullName, title, dataSchema);
            this.setProp(entityInfo, new String[]{dimensionName}, null);
            entities.add(entityInfo);
        }
    }

    private void buildEntity(List<Map<String, Object>> entities, String[] dimensionNames, String cubeName, String caption) {
        HashMap<String, Object> entityInfo = new HashMap<String, Object>(12);
        this.setBaseInfo(entityInfo, cubeName, caption, null);
        this.setProp(entityInfo, dimensionNames, cubeName);
        entities.add(entityInfo);
    }

    private String getCaption(DynamicObject cfg, String cubeName) {
        try (OlapConnection cn = this.openConnection(cfg, cubeName);){
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeName);
            FunctionCommandInfo functionCommand = new FunctionCommandInfo("getProperties", propertyBag);
            OlapCommand olapCommand = new OlapCommand(cn, (CommandInfo)functionCommand);
            PropertyBag result = olapCommand.executeFunction();
            String caption = D.s((Object)result.get("caption"));
            String string = caption = caption == null ? cubeName : caption;
            return string;
        }
    }

    private void setProp(Map<String, Object> entityInfo, String[] dimensionNames, String cubeName) {
        int length = dimensionNames.length;
        ArrayList<Map<String, Object>> props = new ArrayList<Map<String, Object>>(length);
        for (int i = 0; i < length; ++i) {
            Map<String, Object> fieldInfo = this.getFieldInfo(dimensionNames[i], i, cubeName);
            props.add(fieldInfo);
        }
        entityInfo.put("properties", props);
    }

    private Map<String, Object> getFieldInfo(String dimensionName, int i, String cubeName) {
        HashMap<String, Object> fieldInfo = new HashMap<String, Object>(12);
        fieldInfo.put("name", dimensionName);
        fieldInfo.put("label", this.parseLabel(dimensionName));
        fieldInfo.put("data_type", this.parseDataType(dimensionName));
        fieldInfo.put("data_schema", this.getDataSchema(cubeName, dimensionName));
        fieldInfo.put("is_primary_key", Boolean.FALSE);
        fieldInfo.put("is_nullable", Boolean.TRUE);
        fieldInfo.put("index", i);
        fieldInfo.put("remark", null);
        return fieldInfo;
    }

    private String getDataSchema(String cubeName, String dimensionName) {
        if (cubeName == null) {
            return null;
        }
        if ("FMONEY".equals(dimensionName)) {
            return null;
        }
        return Hash.mur32((Object[])new Object[]{cubeName + "." + dimensionName});
    }

    private String parseDataType(String dimensionName) {
        String dataType = "string";
        if ("FMONEY".equals(dimensionName)) {
            dataType = "double";
        }
        return dataType;
    }

    private String parseLabel(String dimensionName) {
        String label = DIMENSION_TITLE.get(dimensionName);
        label = label == null ? dimensionName : label;
        return label;
    }

    private void setBaseInfo(Map<String, Object> entityInfo, String cubeName, String caption, String dataSchema) {
        entityInfo.put("full_name", cubeName);
        entityInfo.put("title", caption);
        entityInfo.put("table_name", cubeName);
        entityInfo.put("name", dataSchema == null ? cubeName : dataSchema);
        entityInfo.put("type", MetaType.ENTITY.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDimensionNames(DynamicObject cfg, String cubeName) {
        try (OlapConnectionProxy connectionProxy = this.getConnectionProxy(cfg, null);){
            OlapConnection cn = connectionProxy.getOlapConnection();
            PropertyBag metaData = this.executeGetMetaDataFunction(cn, cubeName, "true");
            String[] stringArray = metaData.get("children").split("\n");
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectReader<Map<String, Object>> query(DynamicObject cfg, Map<String, Object> requires, List<Map<String, Object>> filter, String cubeName) {
        try (OlapConnectionProxy connectionProxy = this.getConnectionProxy(cfg, cubeName);){
            OlapConnection cn = connectionProxy.getOlapConnection();
            OlapReader olapReader = this.createOlapReader(requires, filter, cn);
            return olapReader;
        }
    }

    private OlapReader createOlapReader(Map<String, Object> requires, List<Map<String, Object>> filter, OlapConnection cn) {
        SelectCommandInfo selectInfo = new SelectCommandInfo();
        List<String> dimensions = this.getDimensions(requires);
        selectInfo.addDims(dimensions.toArray(new String[0])).addMeasures(new String[]{"FMONEY"});
        selectInfo.setExcludeDynamicCalcResult(true);
        this.addFilters(selectInfo, filter);
        OlapCommand queryCmd = new OlapCommand(cn, (CommandInfo)selectInfo);
        return new OlapReader(queryCmd, dimensions);
    }

    private List<String> getDimensions(Map<String, Object> requires) {
        ArrayList<String> dimensions = new ArrayList<String>(requires.size());
        for (String propName : requires.keySet()) {
            if ("FMONEY".equals(propName)) continue;
            dimensions.add(propName);
        }
        return dimensions;
    }

    private void addFilters(SelectCommandInfo selectInfo, List<Map<String, Object>> filter) {
        for (Map<String, Object> f : filter) {
            String link = D.s((Object)f.get("filter_link"));
            if ("OR".equalsIgnoreCase(link)) {
                throw new IscBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u67e5\u8be2\u53ea\u652f\u6301AND\u8fde\u63a5\u3002", (String)"OlapConnectionWrapper_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            this.addFilter(selectInfo, f);
        }
    }

    private void addFilter(SelectCommandInfo selectInfo, Map<String, Object> f) {
        String column = D.s((Object)f.get("filter_column"));
        String compare = D.s((Object)f.get("filter_compare"));
        Object value = f.get("filter_value");
        if ("=".equals(compare)) {
            selectInfo.addFilter(column, new String[]{D.s((Object)value)});
        } else if ("in".equalsIgnoreCase(compare)) {
            this.multiValue(selectInfo, column, value);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u67e5\u8be2\u4e0d\u652f\u6301\u7684\u6bd4\u8f83\u7b26\uff1a%s", (String)"OlapConnectionWrapper_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), compare));
        }
    }

    private void multiValue(SelectCommandInfo selectInfo, String column, Object value) {
        if (value instanceof List) {
            List values = (List)value;
            selectInfo.addFilter(column, values.toArray(new String[0]));
        } else if (value instanceof Object[]) {
            selectInfo.addFilter(column, Collections.singletonList(value).toArray(new String[0]));
        } else if (value instanceof String) {
            this.handleString(selectInfo, column, value);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u67e5\u8be2\u4e0d\u652f\u6301\u7684\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c\uff1a%s", (String)"OlapConnectionWrapper_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value));
        }
    }

    private void handleString(SelectCommandInfo selectInfo, String column, Object value) {
        String s = D.s((Object)value);
        if (s.startsWith("[") && s.endsWith("]")) {
            this.castArray(selectInfo, column, s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            String replace = s.replace('(', '[').replace(')', ']');
            this.castArray(selectInfo, column, replace);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u67e5\u8be2\u4e0d\u652f\u6301\u7684\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c\uff1a%s", (String)"OlapConnectionWrapper_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value));
        }
    }

    private void castArray(SelectCommandInfo selectInfo, String column, String s) {
        List list = (List)JSON.parseObject((String)s, List.class);
        selectInfo.addFilter(column, list.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doBizAction(DynamicObject cfg, List<String> actions, Map<String, Object> data, String cubeName) {
        try (OlapConnectionProxy connectionProxy = this.getConnectionProxy(cfg, cubeName);){
            OlapConnection cn = connectionProxy.getOlapConnection();
            Response response = this.saveData(cn, cfg, actions, data, cubeName);
            return response;
        }
    }

    private Response saveData(OlapConnection cn, DynamicObject cfg, List<String> actions, Map<String, Object> data, String cubeName) {
        int size = actions.size();
        if (size == 1) {
            String action = actions.get(0);
            if (action.equals(TableAction._SAVE.name())) {
                return this.saveOperation(cn, cfg, data, cubeName);
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u4e3a\u76ee\u6807\u6570\u636e\u6e90\u65f6\u4e0d\u652f\u6301\u64cd\u4f5c:%s", (String)"OlapConnectionWrapper_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), actions));
        }
        if (size > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u4e3a\u76ee\u6807\u6570\u636e\u6e90\u65f6\u4e0d\u652f\u6301\u914d\u7f6e\u64cd\u4f5c\u5217\u8868\uff1a%s", (String)"OlapConnectionWrapper_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]), actions));
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u4e3a\u76ee\u6807\u6570\u636e\u6e90\u65f6\u672a\u6307\u5b9a\u64cd\u4f5c\u3002", (String)"OlapConnectionWrapper_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private Response saveOperation(OlapConnection cn, DynamicObject cfg, Map<String, Object> data, String cubeName) {
        String[] split = cubeName.split("\\.");
        int length = split.length;
        if (length == 2) {
            OlapMember.saveMember(cn, cubeName, data, split[1]);
        } else {
            this.checkFmoney(data);
            Map<String, DataType> metaData = this.getMetaDataFromIsc(cfg, cubeName);
            OlapCube.saveRow(cn, data, metaData);
        }
        return new Response(null, SaveDataType.SAVE, null);
    }

    private void checkFmoney(Map<String, Object> data) {
        if (!data.containsKey("FMONEY")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u591a\u7ef4\u6570\u636e\u8868\u7684%s\u5b57\u6bb5\u505a\u6620\u5c04\u8d4b\u503c\u3002", (String)"OlapConnectionWrapper_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "FMONEY"));
        }
    }

    private Map<String, DataType> getMetaDataFromIsc(DynamicObject cfg, String cubeName) {
        DataSource dataSource = DataSource.getByDbLink(cfg.getLong("id"));
        long dataSourceId = dataSource.getConfig().getLong("id");
        DynamicObject dynamicObject = MetaDataSchema.get(dataSourceId, cubeName, "ENTITY");
        DynamicObjectCollection entities = dynamicObject.getDynamicObjectCollection("prop_entryentity");
        HashMap<String, DataType> metaData = new HashMap<String, DataType>();
        for (DynamicObject entity : entities) {
            String propName = entity.getString("prop_name");
            String dataType = entity.getString("data_type");
            metaData.put(propName, DataTypes.get((String)dataType));
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Response> doBatchBizAction(DynamicObject cfg, List<Map<String, Object>> batch, String action, String cubeName) {
        try (OlapConnectionProxy connectionProxy = this.getConnectionProxy(cfg, cubeName);){
            OlapConnection cn = connectionProxy.getOlapConnection();
            List<Response> list = this.batchSave(cn, cfg, batch, action, cubeName);
            return list;
        }
    }

    private List<Response> batchSave(OlapConnection cn, DynamicObject cfg, List<Map<String, Object>> batch, String action, String cubeName) {
        ArrayList<Response> responses = new ArrayList<Response>(batch.size());
        if (!TableAction._SAVE.name().equals(action)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5e93\u4e3a\u76ee\u6807\u6570\u636e\u6e90\u65f6\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a%s", (String)"OlapConnectionWrapper_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]), action));
        }
        this.batchSaveOperation(cn, cfg, batch, cubeName, responses);
        return responses;
    }

    private void batchSaveOperation(OlapConnection cn, DynamicObject cfg, List<Map<String, Object>> batch, String cubeName, List<Response> responses) {
        String[] split = cubeName.split("\\.");
        int length = split.length;
        if (length == 2) {
            OlapMember.batchSaveMembers(cn, cubeName, batch, split[1]);
        } else {
            this.checkFmoney(batch.get(0));
            Map<String, DataType> metaData = this.getMetaDataFromIsc(cfg, cubeName);
            OlapCube.batchSaveRows(cn, batch, metaData);
        }
        for (int i = 0; i < batch.size(); ++i) {
            responses.add(new Response("", SaveDataType.SAVE, null));
        }
    }

    private OlapConnection openConnection(DynamicObject cfg, String cubeName) {
        OlapContext olapContext = new OlapContext(cfg);
        String remoteURL = olapContext.getRemoteURL();
        OlapConnectionStringBuilder cnStr = new OlapConnectionStringBuilder();
        cnStr.setProvider(olapContext.getProvider());
        cnStr.setDataSource(remoteURL);
        if (cubeName != null) {
            cnStr.setInitialCatalog(cubeName);
        }
        OlapConnection cn = new OlapConnection(cnStr.toString());
        cn.setUserName(olapContext.getUser());
        cn.setPassword(olapContext.getPwd());
        cn.Open();
        return cn;
    }

    private void clearConnectionProviders() {
        CONNECTION_PROVIDERS.clear();
    }

    private OlapConnectionProxy getConnectionProxy(DynamicObject cfg, String cubeName) {
        String[] split;
        int length;
        if (cubeName != null && (length = (split = cubeName.split("\\.")).length) == 2) {
            cubeName = split[0];
        }
        OlapConnectionPool connectionPool = this.getConnectionPool(cfg, cubeName);
        return connectionPool.getConnection();
    }

    private synchronized OlapConnectionPool getConnectionPool(DynamicObject cfg, String cubeName) {
        OlapContext olapContext = new OlapContext(cfg);
        String remoteURL = olapContext.getRemoteURL();
        String key = this.getCacheKey(remoteURL, olapContext.getUser(), olapContext.getPwd(), cubeName);
        OlapConnectionPool pool = CONNECTION_PROVIDERS.get(key);
        if (pool == null) {
            pool = new OlapConnectionPool(cfg, cubeName);
            ScheduleManager.submit(pool.getCloseCnTask(), 600);
            CONNECTION_PROVIDERS.put(key, pool);
        }
        return pool;
    }

    private String getCacheKey(String url, String user, String password, String cubeName) {
        return url + ";" + user + ";" + password + ";" + cubeName;
    }

    static {
        DIMENSION_TITLE.put("Entity", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OlapConnectionWrapper_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Account", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OlapConnectionWrapper_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Year", ResManager.loadKDString((String)"\u5e74\u4efd", (String)"OlapConnectionWrapper_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"OlapConnectionWrapper_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Scenario", ResManager.loadKDString((String)"\u60c5\u666f", (String)"OlapConnectionWrapper_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Process", ResManager.loadKDString((String)"\u8fc7\u7a0b", (String)"OlapConnectionWrapper_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("Currency", ResManager.loadKDString((String)"\u5e01\u522b", (String)"OlapConnectionWrapper_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("AuditTrail", ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"OlapConnectionWrapper_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("ChangeType", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"OlapConnectionWrapper_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("InternalCompany", ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"OlapConnectionWrapper_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DIMENSION_TITLE.put("FMONEY", ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"OlapConnectionWrapper_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        CONNECTION_PROVIDERS = new HashMap<String, OlapConnectionPool>(16);
    }
}

