/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.olap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.isc.iscb.platform.core.connector.olap.OlapConstant;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;

public class OlapCube
implements OlapConstant {
    public static void saveRow(OlapConnection cn, Map<String, Object> data, Map<String, DataType> metaData) {
        int size = metaData.size();
        ArrayList<String> dimensions = new ArrayList<String>(size - 1);
        ArrayList<Object> values = new ArrayList<Object>(size);
        OlapCube.addFmoney(data, values, metaData);
        OlapCube.addDimensionAndValue(data, metaData, dimensions, values);
        OlapCommand cmd = OlapCube.getOlapCommand(cn, dimensions);
        try (OlapDataWriter writer = cmd.CreateWriter();){
            writer.setValues(values.toArray());
            writer.flush();
        }
    }

    private static void addFmoney(Map<String, Object> data, List<Object> members, Map<String, DataType> metaData) {
        String value = D.s((Object)data.get("FMONEY"));
        if (value == null || value.equals("0") || value.equalsIgnoreCase("null")) {
            members.add(null);
        } else {
            members.add(OlapCube.parseValueByType(metaData.get("FMONEY"), value));
        }
    }

    private static void addDimensionAndValue(Map<String, Object> data, Map<String, DataType> metaData, List<String> dimensions, List<Object> values) {
        for (Map.Entry<String, DataType> prop : metaData.entrySet()) {
            String dimension = prop.getKey();
            if ("FMONEY".equals(dimension)) continue;
            dimensions.add(dimension);
            values.add(OlapCube.parseValueByType(prop.getValue(), data.get(dimension)));
        }
    }

    private static Object parseValueByType(DataType type, Object value) {
        return type.narrow(value);
    }

    private static OlapCommand getOlapCommand(OlapConnection cn, List<String> dimensions) {
        SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
        saveCommandInfo.setDimensions(dimensions);
        saveCommandInfo.setMeasures(new String[]{"FMONEY"});
        return new OlapCommand(cn, (CommandInfo)saveCommandInfo);
    }

    public static void batchSaveRows(OlapConnection cn, List<Map<String, Object>> batch, Map<String, DataType> metaData) {
        List<String> dimensions = OlapCube.getDimensions(metaData);
        OlapCommand cmd = OlapCube.getOlapCommand(cn, dimensions);
        try (OlapDataWriter writer = cmd.CreateWriter();){
            OlapCube.addWriter(writer, batch, metaData);
            writer.flush();
        }
    }

    private static List<String> getDimensions(Map<String, DataType> metaData) {
        ArrayList<String> dimensions = new ArrayList<String>(metaData.size());
        for (Map.Entry<String, DataType> prop : metaData.entrySet()) {
            String dimension = prop.getKey();
            if ("FMONEY".equals(dimension)) continue;
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private static void addWriter(OlapDataWriter writer, List<Map<String, Object>> batch, Map<String, DataType> metaData) {
        for (Map<String, Object> data : batch) {
            OlapCube.addRow(writer, metaData, data);
        }
    }

    private static void addRow(OlapDataWriter writer, Map<String, DataType> metaData, Map<String, Object> data) {
        List<Object> values = OlapCube.getValues(metaData, data);
        writer.setValues(values.toArray());
    }

    private static List<Object> getValues(Map<String, DataType> metaData, Map<String, Object> data) {
        ArrayList<Object> values = new ArrayList<Object>();
        OlapCube.addFmoney(data, values, metaData);
        for (Map.Entry<String, DataType> prop : metaData.entrySet()) {
            String dimension = prop.getKey();
            if (dimension.equals("FMONEY") || dimension.startsWith("$")) continue;
            OlapCube.addValue(data, values, prop, dimension);
        }
        return values;
    }

    private static void addValue(Map<String, Object> data, List<Object> values, Map.Entry<String, DataType> prop, String dimension) {
        Object value = data.get(dimension);
        if (value == null) {
            values.add(null);
        } else {
            values.add(OlapCube.parseValueByType(prop.getValue(), value));
        }
    }
}

