/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.olap;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.MetadataItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.isc.iscb.platform.core.connector.olap.OlapConstant;
import kd.isc.iscb.util.dt.D;

public class OlapMember
implements OlapConstant {
    public static void saveMember(OlapConnection cn, String cubeName, Map<String, Object> data, String dimension) {
        String member = D.s((Object)data.get(dimension));
        if (member == null) {
            return;
        }
        Set<String> existMembers = OlapMember.getExistMembersFromOlap(cn, dimension);
        if (!existMembers.contains(member.toLowerCase(Locale.ENGLISH))) {
            OlapMember.addMember(cn, cubeName, member);
        }
    }

    private static void addMember(OlapConnection cn, String cubeName, String member) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Member);
        commandInfo.setAction(CommandTypes.create);
        commandInfo.setName(member);
        commandInfo.setOwnerUniqueName(cubeName);
        OlapCommand command = new OlapCommand(cn, (CommandInfo)commandInfo);
        command.executeNonQuery();
    }

    public static void batchSaveMembers(OlapConnection cn, String cubeName, List<Map<String, Object>> batch, String dimensionName) {
        Set<String> members = OlapMember.parseMembers(batch, dimensionName);
        OlapMember.saveMembers(cn, cubeName, dimensionName, members);
    }

    private static Set<String> parseMembers(List<Map<String, Object>> batch, String dimensionName) {
        HashSet<String> members = new HashSet<String>(batch.size());
        for (Map<String, Object> data : batch) {
            String value = D.s((Object)data.get(dimensionName));
            if (value == null) continue;
            members.add(value);
        }
        return members;
    }

    private static void saveMembers(OlapConnection cn, String cubeName, String dimensionName, Set<String> members) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Member);
        commandInfo.setAction(CommandTypes.create);
        commandInfo.setOwnerUniqueName(cubeName);
        List memberItems = commandInfo.getItems();
        OlapMember.addItem(cn, dimensionName, members, memberItems);
        if (!memberItems.isEmpty()) {
            OlapCommand cmd = new OlapCommand(cn, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
    }

    private static void addItem(OlapConnection cn, String dimension, Set<String> members, List<MetadataItem> memberItems) {
        Set<String> notExistMembers = OlapMember.getNotExistMembers(cn, members, dimension);
        for (String member : notExistMembers) {
            MemberMetadataItem item = new MemberMetadataItem();
            item.setName(member);
            memberItems.add((MetadataItem)item);
        }
    }

    private static Set<String> getNotExistMembers(OlapConnection cn, Set<String> members, String dimension) {
        Set<String> membersFromOlap = OlapMember.getExistMembersFromOlap(cn, dimension);
        HashSet<String> notExistMembers = new HashSet<String>(members.size());
        for (String member : members) {
            if (membersFromOlap.contains(D.s((Object)member).toLowerCase(Locale.ENGLISH))) continue;
            notExistMembers.add(member);
        }
        return notExistMembers;
    }

    private static Set<String> getExistMembersFromOlap(OlapConnection cn, String dimension) {
        PropertyBag memberLists = OlapMember.getMembersFromOlap(cn, dimension);
        String[] children = memberLists.get("children").split("\n");
        HashSet<String> set = new HashSet<String>(children.length);
        for (String child : children) {
            set.add(child.toLowerCase(Locale.ENGLISH));
        }
        return set;
    }

    private static PropertyBag getMembersFromOlap(OlapConnection con, String path) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", path);
        propertyBag.set("children", "true");
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(con, (CommandInfo)functionCommandInfo);
        return cmd.executeFunction();
    }
}

