/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.olap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.isc.iscb.platform.core.connector.olap.OlapConstant;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class OlapReader
implements ObjectReader<Map<String, Object>>,
OlapConstant {
    private static final Log log = LogFactory.getLog(OlapReader.class);
    private OlapDataReader olapDataReader;
    private int fieldCount;
    private List<String> dimensions;
    private int count;

    public OlapReader(OlapCommand queryCmd, List<String> dimensions) {
        StringMetadataBuilder stringMetadataBuilder = StringMetadataBuilder.INSTANCE;
        this.olapDataReader = queryCmd.executeReader((IMetadataBuilder)stringMetadataBuilder);
        this.count = queryCmd.executeCellSet((IMetadataBuilder)stringMetadataBuilder).getCount();
        this.fieldCount = this.olapDataReader.getFieldCount();
        this.dimensions = dimensions;
    }

    public int getTotalCount() {
        return this.count;
    }

    public Map<String, Object> read() {
        try {
            Object[] values = new Object[this.fieldCount];
            if (this.olapDataReader.next()) {
                this.olapDataReader.getValues(values);
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.fieldCount);
                result.put("FMONEY", values[0]);
                for (int i = 0; i < this.fieldCount - 1; ++i) {
                    result.put(this.dimensions.get(i), values[i + 1]);
                }
                return result;
            }
            return null;
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u591a\u7ef4\u6570\u636e\u5e93\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"OlapReader_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public void close() {
        if (this.olapDataReader != null) {
            try {
                this.olapDataReader.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edolapDataReader\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            }
        }
    }
}

