/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sap_proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.sap_proxy.SAPProxyContext;
import kd.isc.iscb.platform.core.connector.sap_proxy.SAPProxyMetaReader;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteSystem;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.io.ObjectReader;

public final class SAPProxyConnectionFactory
implements ConnectionFactory {
    @Override
    public ConnectionWrapper create(DynamicObject cfg) {
        SAPProxyConnectionFactory sapProxyConnectionFactory = new SAPProxyConnectionFactory();
        return new ConnectionWrapper(sapProxyConnectionFactory, cfg);
    }

    @Override
    public void test(ConnectionWrapper cn) {
        SAPProxyContext ctx = new SAPProxyContext(cn.getConfig());
        RemoteSystem.test((RemoteContext)ctx);
    }

    @Override
    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> args, String proxyUser) {
        SAPProxyContext ctx = new SAPProxyContext(cn.getConfig());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("command", "$call_sap_function");
        params.put("service", service);
        params.put("args", args);
        params.put("proxy_user", proxyUser);
        return ctx.invoke(params);
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        SAPProxyContext ctx = new SAPProxyContext(cn.getConfig());
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("command", "$get_entity_info");
        params.put("name", name);
        Object value = ctx.invoke(params);
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        return (List)value;
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        SAPProxyContext ctx = new SAPProxyContext(cn.getConfig());
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("command", "$get_metas");
        Map result = (Map)ctx.invoke(params);
        if (result == null) {
            return Collections.emptyMap();
        }
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(result.size());
        for (Map.Entry e : result.entrySet()) {
            metas.put((String)e.getKey(), MetaType.valueOf((String)((String)e.getValue())));
        }
        return metas;
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        SAPProxyContext ctx = new SAPProxyContext(cn.getConfig());
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("command", "$retrieve_data");
        params.put("entity", entity);
        params.put("requires", requires);
        params.put("filter", filter);
        params.put("orderBy", orderBy == null ? Collections.emptyList() : orderBy);
        return new SAPProxyMetaReader((RemoteContext)ctx, params);
    }
}

