/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sap_proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class SAPProxyMetaReader
implements ObjectReader<Map<String, Object>> {
    private RemoteContext ctx;
    private String command;
    private String entity;
    private List<Map<String, Object>> requires;
    private List<Map<String, Object>> filter;
    private List<Map<String, String>> orderBy;
    private int rowCount = 500;
    private int rowSkips = 0;
    private int count;
    private List<Map<String, Object>> data;
    private boolean last;
    private static final String SEPARATOR = "\u2195";

    SAPProxyMetaReader(RemoteContext ctx, Map<String, Object> result) {
        this.ctx = ctx;
        this.command = D.s((Object)result.get("command"));
        this.entity = D.s((Object)result.get("entity"));
        this.requires = this.parseRequestField((Map)result.get("requires"));
        this.filter = (List)result.get("filter");
        this.orderBy = (List)result.get("orderBy");
        this.executeQuery();
    }

    private void executeQuery() {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("command", this.command);
        params.put("entity", this.entity);
        params.put("requires", this.requires);
        params.put("filter", this.filter);
        params.put("rowSkips", this.rowSkips);
        params.put("rowCount", this.rowCount);
        params.put("orderBy", this.orderBy);
        Map result = (Map)this.ctx.invoke(params);
        this.last = D.x(result.get("last"));
        this.data = (List)result.get("data");
        this.count += this.data.size();
    }

    public Map<String, Object> read() {
        if (this.data.size() > 0) {
            return this.parseResult(this.data.remove(0));
        }
        if (this.last) {
            return null;
        }
        this.rowSkips += this.rowCount;
        this.executeQuery();
        return this.read();
    }

    public void close() {
    }

    private Map<String, Object> parseResult(Map<String, Object> item) {
        String wa = String.valueOf(item.get("WA"));
        String[] split = wa.split(SEPARATOR);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(split.length);
        for (int i = 0; i < split.length; ++i) {
            Map<String, Object> field = this.requires.get(i);
            String fieldName = D.s((Object)field.get("FIELDNAME"));
            result.put(fieldName, split[i]);
        }
        return result;
    }

    private List<Map<String, Object>> parseRequestField(Map<String, Object> requires) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(requires.size());
        for (String key : requires.keySet()) {
            HashMap<String, String> fieldMap = new HashMap<String, String>(2);
            fieldMap.put("FIELDNAME", key);
            fields.add(fieldMap);
        }
        return fields;
    }

    public int getTotalCount() {
        return this.count;
    }
}

