/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.isc.iscb.platform.core.connector.self.AttachmentPanel;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public class AttachmentUtil {
    private static final String ENTITY_ISC_ATTACHMENT_TEMP = "isc_attachment_temp";
    private static final String ENTITY_BOS_ATTACHMENT = "bos_attachment";
    private static final String MD5 = "MD5";
    private static final Log logger = LogFactory.getLog(AttachmentUtil.class);
    private static final ReadLockFreeMap<String, ReadLockFreeMap<String, List<String>>> attachmentPanelKeys = new ReadLockFreeMap();
    private static final ReadLockFreeMap<String, ReadLockFreeMap<String, List<String>>> attachmentFields = new ReadLockFreeMap();
    private static final String BASE_DIR = System.getProperty("user.home") + File.separator + "attachments";

    private AttachmentUtil() {
    }

    public static List<String> getAttachmentPanelKeys(String entity) {
        List keys;
        String accountId = RequestContext.get().getAccountId();
        ReadLockFreeMap panelKeyMap = (ReadLockFreeMap)attachmentPanelKeys.get((Object)accountId);
        if (panelKeyMap == null) {
            attachmentPanelKeys.putIfAbsent((Object)accountId, (Object)new ReadLockFreeMap());
            panelKeyMap = (ReadLockFreeMap)attachmentPanelKeys.get((Object)accountId);
        }
        if ((keys = (List)panelKeyMap.get((Object)entity)) == null) {
            panelKeyMap.putIfAbsent((Object)entity, AttachmentUtil.getPanelKeysByEntity(entity));
            keys = (List)panelKeyMap.get((Object)entity);
        }
        return keys;
    }

    public static void resetCache() {
        String accountId = RequestContext.get().getAccountId();
        attachmentPanelKeys.remove((Object)accountId);
        attachmentFields.remove((Object)accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)AttachmentUtil.class.getName(), (String)"resetCacheFromMq", (Object[])new Object[]{accountId});
    }

    public static void resetCacheFromMq(String accountId) {
        attachmentPanelKeys.remove((Object)accountId);
        attachmentFields.remove((Object)accountId);
    }

    private static List<String> getAttachmentFieldKeys(String entity) {
        List keys;
        String accountId = RequestContext.get().getAccountId();
        ReadLockFreeMap fieldKeyMap = (ReadLockFreeMap)attachmentFields.get((Object)accountId);
        if (fieldKeyMap == null) {
            attachmentFields.putIfAbsent((Object)accountId, (Object)new ReadLockFreeMap());
            fieldKeyMap = (ReadLockFreeMap)attachmentFields.get((Object)accountId);
        }
        if ((keys = (List)fieldKeyMap.get((Object)entity)) == null) {
            fieldKeyMap.putIfAbsent((Object)entity, AttachmentUtil.getFieldKeysByEntity(entity));
            keys = (List)fieldKeyMap.get((Object)entity);
        }
        return keys;
    }

    public static List<Map<String, Object>> getAttachmentList(String entity, Object id) {
        if (entity == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u9644\u4ef6\u5143\u6570\u636e\u4fe1\u606f!", (String)"AttachmentUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        for (String key : AttachmentUtil.getAttachmentPanelKeys(entity)) {
            attachments.addAll(AttachmentUtil.getAttachmentPanelList(entity, id, key));
        }
        for (String field : AttachmentUtil.getAttachmentFieldKeys(entity)) {
            attachments.addAll(AttachmentUtil.getAttachmentFieldList(entity, id, field));
        }
        return attachments;
    }

    public static List<Map<String, Object>> getAttachmentPanelList(String entity, Object id, String key) {
        ArrayList<Map<String, Object>> fileInfos = new ArrayList<Map<String, Object>>();
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("FBillType", "=", (Object)entity), new QFilter("FInterID", "=", (Object)D.s((Object)id)), new QFilter("fattachmentpanel", "=", (Object)key)};
        DynamicObjectCollection dynColl = orm.query(ENTITY_BOS_ATTACHMENT, filters);
        if (CollectionUtils.isEmpty(dynColl)) {
            return Collections.emptyList();
        }
        for (DynamicObject attachment : dynColl) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("srcAttachId", attachment.get("id"));
            temp.put("name", attachment.getString("fattachmentname").replace("." + attachment.get("fextname"), ""));
            temp.put("type", attachment.get("fextname"));
            temp.put("bytes", attachment.get("fattachmentsize"));
            temp.put("desc", attachment.get("fdescription"));
            temp.put("srcUrl", attachment.get("ffileid"));
            temp.put("number", attachment.get("fnumber"));
            temp.put("srcBillId", attachment.get("finterid"));
            temp.put("srcAttachType", "PANEL");
            temp.put("srcEntity", entity);
            temp.put("srcAttachKey", key);
            DynamicObject creator = attachment.getDynamicObject("fcreatemen");
            if (creator != null) {
                temp.put("srcAttachCreator", creator.get("id"));
                temp.put("srcAttachCreatorNum", creator.get("number"));
            }
            temp.put("srcAttachCreateTime", attachment.get("fcreatetime"));
            fileInfos.add(temp);
        }
        return fileInfos;
    }

    private static List<String> getPanelKeysByEntity(String entity) {
        ArrayList<String> keys = new ArrayList<String>();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entity, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        for (ControlAp item : items) {
            if (!(item instanceof AttachmentPanelAp)) continue;
            keys.add(item.getKey());
        }
        return keys;
    }

    public static List<Map<String, Object>> getAttachmentFieldList(String entity, Object id, String field) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (String)entity);
        DynamicObjectCollection attCollection = bill.getDynamicObjectCollection(field);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(attCollection.size());
        for (DynamicObject relation : attCollection) {
            DynamicObject attDetail = (DynamicObject)relation.get("fbasedataid");
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("srcAttachId", attDetail.get("id"));
            temp.put("srcUId", attDetail.get("uid"));
            temp.put("name", attDetail.getString("name").replace("." + attDetail.getString("type"), ""));
            temp.put("type", attDetail.getString("type"));
            temp.put("bytes", D.i((Object)attDetail.get("size")));
            temp.put("desc", attDetail.getString("description"));
            temp.put("srcUrl", attDetail.getString("url"));
            temp.put("srcAttachType", "FIELD");
            temp.put("srcAttachKey", field);
            temp.put("srcEntity", entity);
            temp.put("srcBindingTable", attCollection.getDynamicObjectType().getAlias());
            DynamicObject creator = attDetail.getDynamicObject("creator");
            if (creator != null) {
                temp.put("srcAttachCreator", creator.get("id"));
                temp.put("srcAttachCreatorNum", creator.get("number"));
            }
            temp.put("srcAttachCreateTime", attDetail.get("createtime"));
            result.add(temp);
        }
        return result;
    }

    private static List<String> getFieldKeysByEntity(String entity) {
        ArrayList<String> fields = new ArrayList<String>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof AttachmentProp)) continue;
            fields.add(property.getName());
        }
        return fields;
    }

    public static boolean isAttachmentChanged(Map<String, Object> attachment, String md5Code) {
        String checkFileId = D.s((Object)attachment.get("checkFileId"));
        if (checkFileId == null || md5Code == null) {
            return true;
        }
        DynamicObject bd = BusinessDataServiceHelper.loadSingle((String)"bd_attachment", (String)"id, url", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)D.l((Object)checkFileId))});
        if (bd != null) {
            return AttachmentUtil.isAttachmentChanged(bd.getString("url"), md5Code);
        }
        DynamicObject bos = BusinessDataServiceHelper.loadSingle((String)ENTITY_BOS_ATTACHMENT, (String)"id, ffileid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)D.l((Object)checkFileId))});
        if (bos != null) {
            return AttachmentUtil.isAttachmentChanged(bos.getString("ffileid"), md5Code);
        }
        return true;
    }

    private static boolean isAttachmentChanged(String url, String md5Code) {
        boolean exists = true;
        try {
            exists = FileServiceFactory.getAttachmentFileService().exists(url);
        }
        catch (Exception e) {
            logger.warn("\u9644\u4ef6\u670d\u52a1\u5668exists\u65b9\u6cd5\u8bbf\u95ee\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u9644\u4ef6\u670d\u52a1\u5668\u662f\u5426\u6b63\u786e\u66f4\u65b0.", (Throwable)e);
        }
        if (exists) {
            Charset utf8;
            String fileCode = AttachmentUtil.getAttachmentMd5Code(url);
            return !MessageDigest.isEqual(fileCode.getBytes(utf8 = StandardCharsets.UTF_8), md5Code.getBytes(utf8)) || MessageDigest.isEqual(fileCode.getBytes(utf8), "1d193b9064bb17abe3052b353aee13a0".getBytes(utf8));
        }
        return true;
    }

    public static String getAttachmentMd5Code(String url) {
        MessageDigest md5 = AttachmentUtil.getMd5Instance();
        byte[] buffer = new byte[8192];
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                md5.update(buffer, 0, length);
            }
            String string = Hex.encode((byte[])md5.digest());
            return string;
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create((Throwable)e, new String[]{MD5});
        }
    }

    public static File createTempFile(String type) {
        FileUtil.checkFilePath(BASE_DIR);
        File file = new File(BASE_DIR, AttachmentUtil.getChild(type));
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\uff1a%s", (String)"AttachmentUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dir));
        }
        return file;
    }

    private static String getChild(String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(UUID.randomUUID().toString().replaceAll("-", "")).append('.').append(type);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTempToFileServer(InputStream input, long attachId, Map<String, Object> attachment, String tempName, long length) {
        String name = D.s((Object)attachment.get("name"));
        String type = D.s((Object)attachment.get("type"));
        String fileName = type != null && name.endsWith("." + type) ? name : name + "." + type;
        String entity = D.s((Object)attachment.get("tarEntity"));
        String desc = D.s((Object)attachment.get("desc"));
        Timestamp attachCreateTime = D.t((Object)attachment.get("attachCreateTime"));
        String attachCreatorId = D.s((Object)attachment.get("attachCreator"));
        long randId = IDService.get().genLongId();
        String appId = BizAppServiceHelp.getAppNumByAppId((String)BizAppServiceHelp.getAppIdByFormNum((String)entity));
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)appId, (String)entity, (Object)randId, (String)FileUtil.replaceSpeChar(fileName));
        FileItem fileItem = new FileItem(fileName, path, input);
        fileItem.setCreateNewFileWhenExists(true);
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = AttachmentUtil.wrapAttachContext(attachCreatorId, current);
            String url = FileServiceFactory.getAttachmentFileService().upload(fileItem);
            String creatorId = new_rc != null ? new_rc.getUserId() : current.getUserId();
            AttachmentUtil.saveTempAttachmentDetail(attachId, fileName, type, tempName, length, url, desc, attachCreateTime, creatorId);
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    public static RequestContext wrapAttachContext(String attachCreatorId, RequestContext current) {
        try {
            return ContextUtil.restoreAndGetContext(current, attachCreatorId);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u9644\u4ef6\u521b\u5efa\u4eba\u201c%1$s\u201c\u6784\u9020\u4e0a\u4e0b\u6587\uff0c\u539f\u56e0\uff1a", (String)"AttachmentUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), attachCreatorId), (Throwable)e);
        }
    }

    public static void saveTempAttachmentDetail(long attachId, String fileName, String type, String tempName, long length, String url, String desc) {
        AttachmentUtil.saveTempAttachmentDetail(attachId, fileName, type, tempName, length, url, desc, null, null);
    }

    public static void saveTempAttachmentDetail(long attachId, String fileName, String type, String tempName, long length, String url, String desc, Timestamp userDefinedCreateTime, String userDefinedCreatorId) {
        DynamicObject object = !QueryServiceHelper.exists((String)ENTITY_ISC_ATTACHMENT_TEMP, (Object)attachId) ? BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_ATTACHMENT_TEMP) : BusinessDataServiceHelper.loadSingle((Object)attachId, (String)ENTITY_ISC_ATTACHMENT_TEMP);
        object.set("id", (Object)attachId);
        object.set("name", (Object)fileName);
        object.set("type", (Object)type);
        object.set("url", (Object)url);
        object.set("bytes", (Object)length);
        object.set("desc", (Object)desc);
        object.set("state", (Object)"S");
        object.set("createtime", (Object)D.t((Object)new Date()));
        object.set("temp_name", (Object)tempName);
        object.set("usr_def_create_time", (Object)userDefinedCreateTime);
        object.set("usr_def_creator", (Object)userDefinedCreatorId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static void bindingAttachment(String entity, Map<String, Object> data, Object id) {
        List<String> keys = AttachmentUtil.getAttachmentPanelKeys(entity);
        for (String key : keys) {
            List<Map> attachments;
            Object o = data.get(key);
            if (o == null) continue;
            if (o instanceof List) {
                attachments = (List<Map>)o;
            } else if (o instanceof Map) {
                Object pk = ((Map)o).get("id");
                if (pk == null) continue;
                attachments = Collections.singletonList((Map)o);
            } else {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u8be6\u7ec6\u4fe1\u606f\u5e94\u4e3a\u5217\u8868\u7c7b\u578b\uff0c\u5f53\u524d\u7c7b\u578b\u4e3a%s", (String)"AttachmentUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), o.getClass().getSimpleName()));
            }
            List<Object> pks = attachments.stream().map(k -> k.get("id")).collect(Collectors.toList());
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (String)entity);
            AttachmentPanel attach = new AttachmentPanel(entity, key);
            attach.bind(bill, pks);
        }
    }

    private static Map<Pair<String, String>, List<Map<String, Object>>> classifyAttachments(List<Map<String, Object>> attachList) {
        HashMap<Pair<String, String>, List<Map<String, Object>>> classifiedMap = new HashMap<Pair<String, String>, List<Map<String, Object>>>();
        for (Map<String, Object> attach : attachList) {
            String type = D.s((Object)attach.get("srcAttachType"));
            String key = D.s((Object)attach.get("srcAttachKey"));
            if (key != null) {
                List list = classifiedMap.computeIfAbsent((Pair<String, String>)new Pair((Object)type, (Object)key), k -> new ArrayList());
                list.add(attach);
                continue;
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6839\u636etype={%s}\u65e0\u6cd5\u786e\u5b9a\u662f\u9762\u677f\u9644\u4ef6\u8fd8\u662f\u5b57\u6bb5\u9644\u4ef6.", (String)"AttachmentUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
        return classifiedMap;
    }

    public static void deleteAttachments(String entity, Object pk, List<Map<String, Object>> attachmentList) {
        if (attachmentList == null) {
            attachmentList = AttachmentUtil.getAttachmentList(entity, pk);
        }
        Map<Pair<String, String>, List<Map<String, Object>>> pairListMap = AttachmentUtil.classifyAttachments(attachmentList);
        for (Map.Entry<Pair<String, String>, List<Map<String, Object>>> entry : pairListMap.entrySet()) {
            Pair<String, String> pair = entry.getKey();
            String type = (String)pair.getA();
            List<Map<String, Object>> attachments = entry.getValue();
            if ("PANEL".equals(type)) {
                int i = AttachmentUtil.deletePanelAttachments(attachments);
                logger.info(String.format("\u5220\u9664\u5355\u636e%s[%s]\u9644\u4ef6\u9762\u677f\u9644\u4ef6\u5171%d\u4e2a.", entity, pk.toString(), i));
                continue;
            }
            if (!"FIELD".equals(type)) continue;
            for (Map<String, Object> attachment : attachments) {
                String table = D.s((Object)attachment.get("srcBindingTable"));
                AttachmentFieldServiceHelper.removeAttachments((String)entity, (String)table, attachment);
            }
            logger.info(String.format("\u5220\u9664\u5355\u636e%s[%s]\u9644\u4ef6\u5b57\u6bb5\u9644\u4ef6\u5171%d\u4e2a.", entity, pk.toString(), attachments.size()));
        }
    }

    public static int deletePanelAttachments(List<Map<String, Object>> attachments) {
        int count = 0;
        for (Map<String, Object> attachment : attachments) {
            long attachId = D.l((Object)attachment.get("srcAttachId"));
            count += DeleteServiceHelper.delete((String)ENTITY_BOS_ATTACHMENT, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)D.l((Object)attachId))});
        }
        return count;
    }

    public static void deletePanelAttachments(String entity, String pk, Map<String, Object> attachments) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_BOS_ATTACHMENT), (Object[])attachments.keySet().toArray());
        logger.info(String.format("\u5220\u9664\u5355\u636e%s[%s]\u9644\u4ef6\u9762\u677f\u4e0a\u9644\u4ef6\u5171%d\u4e2a.", entity, pk, attachments.size()));
    }
}

