/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;

public class DynamicObjectReader {
    public static Map<String, Object> read(String entity, Object id, Map<String, Object> requires) {
        List<Map<String, Object>> requiresSharding = DynamicObjectReader.splitRequires(entity, requires);
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(requires.size());
        ORM orm = ORM.create();
        for (Map<String, Object> shard : requiresSharding) {
            DynamicObjectReader.mergeSharding(data, entity, id, orm, shard);
        }
        return data;
    }

    public static Collection<Map<String, Object>> read(String entity, List<Object> idList, Map<String, Object> requires) {
        LinkedHashMap<String, Map<String, Object>> idToData = new LinkedHashMap<String, Map<String, Object>>(idList.size());
        List<Map<String, Object>> requiresSharding = DynamicObjectReader.splitRequires(entity, requires);
        ORM orm = ORM.create();
        for (Map<String, Object> shard : requiresSharding) {
            String selectProperties = SQLUtil.toPlainRequires(entity, null, shard);
            DynamicObjectCollection list = orm.query(entity, selectProperties, new QFilter[]{new QFilter("id", "in", idList)});
            for (DynamicObject object : list) {
                DynamicObjectReader.addData(idToData, shard, object);
            }
        }
        return idToData.values();
    }

    private static void addData(Map<String, Map<String, Object>> idToData, Map<String, Object> shard, DynamicObject object) {
        String id = D.s((Object)object.get("id"));
        Map<String, Object> data = idToData.get(id);
        if (data == null) {
            data = new HashMap<String, Object>();
            idToData.put(id, data);
        }
        Map<String, Object> map = DynamicObjectUtil.object2Map(object, shard);
        data.putAll(map);
    }

    private static void mergeSharding(Map<String, Object> data, String entity, Object id, ORM orm, Map<String, Object> shard) {
        String selectProperties = SQLUtil.toPlainRequires(entity, null, shard);
        DynamicObject object = orm.queryOne(entity, selectProperties, new QFilter[]{new QFilter("id", "=", id)});
        if (object != null) {
            Map<String, Object> map = DynamicObjectUtil.object2Map(object, shard);
            data.putAll(map);
        }
    }

    private static List<Map<String, Object>> splitRequires(String entity, Map<String, Object> requires) {
        ArrayList<Map<String, Object>> requiresSharding = new ArrayList<Map<String, Object>>(4);
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>(requires.size());
        header.put("id", 1);
        requiresSharding.add(header);
        MainEntityType meta = EntityMetadataCache.getDataEntityType((String)entity);
        for (Map.Entry<String, Object> e : requires.entrySet()) {
            String key = e.getKey();
            DynamicProperty property = meta.getProperty(key);
            if (property == null) continue;
            if (property instanceof EntryProp) {
                LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>(2);
                items.put("id", 1);
                items.put(key, e.getValue());
                requiresSharding.add(items);
                continue;
            }
            header.put(key, e.getValue());
        }
        return requiresSharding;
    }
}

