/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.isc.iscb.platform.core.connector.self.RegisterOpActionQueue;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class EventExceptionConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(EventExceptionConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        try {
            Map map = (Map)message;
            String entity = D.s(map.get("entity"));
            String operation = D.s(map.get("operation"));
            DynamicObject[] objects = (DynamicObject[])map.get("data");
            this.deliverMessage(entity, operation, objects);
            messageAcker.ack(messageId);
        }
        catch (Exception e) {
            this.handleException(message, messageId, messageAcker, e);
        }
    }

    private void deliverMessage(String entity, String operation, DynamicObject[] objects) {
        try {
            RegisterOpActionQueue.execute(entity, operation, objects);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    private void handleException(Object message, String messageId, MessageAcker messageAcker, Exception e) {
        if (e instanceof IscBizException) {
            LOGGER.warn("\u5355\u636e\u4e8b\u4ef6\u6d88\u8d39\u5f02\u5e38\uff0c\u5c06\u88ab\u91cd\u53d1\uff0c\u6d88\u606fid\uff1a" + messageId, (Throwable)e);
            messageAcker.deny(messageId);
        } else {
            LOGGER.warn(String.format("\u5355\u636e\u4e8b\u4ef6\u6d88\u8d39\u5f02\u5e38\uff0c\u5c06\u88ab\u4e22\u5f03\uff0c\u6d88\u606fid\uff1a%s\uff0c\u6d88\u606f\u5185\u5bb9\uff1a%s.", messageId, SerializationUtils.toJsonString((Object)message)), (Throwable)e);
            messageAcker.discard(messageId);
        }
    }
}

