/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.OpBizRuleSetReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public class EventRegister {
    private static final String OP_BIZ_RULE_ID = "ISCEventInterceptor";

    public static void register(String entity, String[] events) {
        Set<String> addSet = EventRegister.toEventSet(events);
        EventRegister.register(entity, addSet);
    }

    private static Set<String> toEventSet(String[] events) {
        HashSet<String> addSet = new HashSet<String>();
        for (String e : events) {
            String evt = D.s((Object)e);
            if (evt == null) continue;
            addSet.add(evt);
        }
        return addSet;
    }

    private static void register(String entity, Set<String> set) {
        Set<String> opSet = EventRegister.getOriginalEventSet(entity);
        opSet.addAll(set);
        OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entity, (String)OP_BIZ_RULE_ID, new ArrayList<String>(opSet));
    }

    private static Set<String> getOriginalEventSet(String entity) {
        QFilter qFilter1 = new QFilter("objecttype", "=", (Object)entity);
        QFilter qFilter2 = new QFilter("opbizrule", "=", (Object)OP_BIZ_RULE_ID);
        List objs = OpBizRuleSetReader.load((QFilter[])new QFilter[]{qFilter1, qFilter2});
        HashSet<String> opSet = new HashSet<String>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject d : cols) {
                opSet.add(d.getString("operationkey"));
            }
        }
        return opSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegister(Connection cn, String entity) {
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)"SELECT fentity, fevents FROM T_ISCB_CON_EVT_BND WHERE fentity = ? ", Collections.singletonList(entity), Collections.singletonList(12));
        HashSet<String> eventSet = new HashSet<String>();
        try {
            DataRow data = (DataRow)reader.read();
            while (data != null) {
                String[] events = StringUtil.split((String)D.s((Object)data.get((Object)"fevents")), (char)',');
                eventSet.addAll(EventRegister.toEventSet(events));
                data = (DataRow)reader.read();
            }
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
        if (eventSet.isEmpty()) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entity, (String)OP_BIZ_RULE_ID);
        } else {
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entity, (String)OP_BIZ_RULE_ID, new ArrayList(eventSet));
        }
    }
}

