/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.connector.self.Util;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class ExecutionData {
    private static final String PARAM_CONNECTOR = "connector";
    private static final Log LOGGER = LogFactory.getLog(ExecutionData.class);

    public static List<Response> batchDelete(String entity, List<Object> ids) {
        return ExecutionData.batchDelete(entity, ids, Collections.emptyMap());
    }

    public static List<Response> batchDelete(String entity, List<Object> ids, Map<String, Object> targetActionParams) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Response>();
        }
        try {
            long begin = System.currentTimeMillis();
            OperateOption option = ExecutionData.initOperation(targetActionParams, "delete");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids.toArray(), (OperateOption)option);
            ArrayList<Pair<String, Object>> bills = new ArrayList<Pair<String, Object>>(ids.size());
            for (Object id : ids) {
                bills.add((Pair<String, Object>)new Pair((Object)"", id));
            }
            if (ExecutionData.recordLogs()) {
                LOGGER.info(String.format("\u5b9e\u4f53%s\u6267\u884c\u6279\u91cf\u5220\u9664\u64cd\u4f5c\u6210\u529f\uff0c\u6570\u636e\u884c\u6570\uff1a%d\uff0c\u5f85\u5220\u9664\u7684ID\u5217\u8868\u4e3a%s", entity, ids.size(), Json.toString(ids)) + ".\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin) + "ms.");
            }
            return ExecutionData.getResponses(bills, SaveDataType.DELETE, result);
        }
        catch (Exception e) {
            if (ExecutionData.recordLogs()) {
                LOGGER.warn(String.format("\u5b9e\u4f53%s\u6267\u884c\u6279\u91cf\u5220\u9664\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u884c\u6570\uff1a%d\uff0c\u5f85\u5220\u9664\u7684ID\u5217\u8868\u4e3a%s", entity, ids.size(), Json.toString(ids)));
            }
            throw e;
        }
    }

    public static void delete(String entity, Object id) {
        ExecutionData.delete(entity, id, Collections.emptyMap());
    }

    public static void delete(String entity, Object id, Map<String, Object> targetActionParams) {
        long begin = System.currentTimeMillis();
        try {
            OperateOption option = ExecutionData.initOperation(targetActionParams, "delete");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])new Object[]{id}, (OperateOption)option);
            CommonUtil.check(result);
            if (ExecutionData.recordLogs()) {
                LOGGER.info("\u8c03\u7528\u5b9e\u4f53" + entity + "\u5220\u9664\u64cd\u4f5c\u540e\uff0cID\uff1a" + id + "\uff0csuccess:" + result.isSuccess() + ".\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin) + "ms.");
            }
        }
        catch (Exception e) {
            if (ExecutionData.recordLogs()) {
                LOGGER.warn("\u8c03\u7528\u5b9e\u4f53" + entity + "\u5220\u9664\u64cd\u4f5c\u5931\u8d25\uff0cID\uff1a" + id);
            }
            throw e;
        }
    }

    public static List<Response> batchExecute(String entity, List<DynamicObject> objects, SaveDataType type, String operation) {
        return ExecutionData.batchExecute(entity, objects, type, operation, Collections.emptyMap());
    }

    public static List<Response> batchExecute(String entity, List<DynamicObject> objects, SaveDataType type, String operation, Map<String, Object> targetActionParams) {
        if (CollectionUtils.isEmpty(objects)) {
            return new ArrayList<Response>();
        }
        try {
            long begin = System.currentTimeMillis();
            if ("_ENTITY_SAVE".equals(operation)) {
                return ExecutionData.batchSaveDynamicObjects(objects);
            }
            OperateOption option = ExecutionData.initOperation(targetActionParams, operation);
            return ExecutionData.doBatchOperations(entity, objects, type, operation, begin, option);
        }
        catch (Exception e) {
            if (ExecutionData.recordLogs()) {
                LOGGER.warn("\u8c03\u7528\u5b9e\u4f53" + entity + "\u6279\u91cf\u64cd\u4f5c" + operation + "\u540e\u51fa\u9519");
            }
            throw e;
        }
    }

    private static List<Response> batchSaveDynamicObjects(List<DynamicObject> objects) {
        Object[] result = SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        ArrayList<Response> responses = new ArrayList<Response>(result.length);
        for (Object o : result) {
            responses.add(new Response(D.s((Object)((DynamicObject)o).getPkValue()), SaveDataType.SAVE, null));
        }
        return responses;
    }

    private static List<Response> doBatchOperations(String entity, List<DynamicObject> objects, SaveDataType type, String operation, long begin, OperateOption option) {
        DynamicObject[] dynamicObjects = new DynamicObject[objects.size()];
        OperationResult result = OperationServiceHelper.executeOperate((String)ExecutionData.parseOperation(operation), (String)entity, (DynamicObject[])objects.toArray(dynamicObjects), (OperateOption)option);
        if (ExecutionData.recordLogs()) {
            LOGGER.info("\u8c03\u7528\u5b9e\u4f53" + entity + "\u6279\u91cf\u64cd\u4f5c" + operation + "\u540e\uff0csuccess\uff1a" + result.isSuccess() + ".\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin) + "ms.");
        }
        return ExecutionData.getResponseByObjects(objects, type, result);
    }

    private static List<Response> getResponseByObjects(List<DynamicObject> objects, SaveDataType type, OperationResult result) {
        ArrayList<Pair<String, Object>> bills = new ArrayList<Pair<String, Object>>(objects.size());
        String numberProperty = ExecutionData.getNumberPropertyName(objects);
        for (DynamicObject o : objects) {
            String number = o.getString(numberProperty);
            Object id = o.getPkValue();
            bills.add((Pair<String, Object>)new Pair((Object)number, id));
        }
        return ExecutionData.getResponses(bills, type, result);
    }

    private static String getNumberPropertyName(List<DynamicObject> objects) {
        DataEntityPropertyCollection properties = objects.get(0).getDataEntityType().getProperties();
        String numberProperty = properties.containsKey((Object)"number") ? "number" : (properties.containsKey((Object)"billno") ? "billno" : objects.get(0).getDataEntityType().getPrimaryKey().getName());
        return numberProperty;
    }

    private static List<Response> getResponses(List<Pair<String, Object>> bills, SaveDataType type, OperationResult result) {
        Map<String, Object> resultMap = ExecutionData.organizeResult(result);
        ArrayList<Response> responses = new ArrayList<Response>(bills.size());
        for (Pair<String, Object> item : bills) {
            String id = D.s((Object)item.getValue());
            Object state = resultMap.get(id);
            if (Boolean.TRUE.equals(state)) {
                responses.add(new Response(id, type, null));
                continue;
            }
            ExecutionData.handleError(resultMap, responses, item, id, state);
        }
        return responses;
    }

    private static void handleError(Map<String, Object> resultMap, List<Response> responses, Pair<String, Object> item, String id, Object state) {
        String error = ExecutionData.compositeErrorMessage(resultMap, item, state);
        if (error != null) {
            responses.add(new Response(id, error));
        } else {
            String unknownError = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0\u672a\u77e5\uff0c\u6279\u91cf\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u65e0\u6cd5\u4e0e\u5355\u636e\u5efa\u7acb\u5173\u8054\uff0c\u8bf7\u5355\u72ec\u6267\u884c\u672c\u884c\u6570\u636e\u83b7\u53d6\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u3002", (String)"ExecutionData_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            responses.add(new Response(id, unknownError));
        }
    }

    private static String compositeErrorMessage(Map<String, Object> resultMap, Pair<String, Object> item, Object state) {
        String id = D.s((Object)item.getValue());
        String billno = (String)item.getKey();
        String error = ExecutionData.toString(state);
        String billno_error = ExecutionData.toString(resultMap.get(billno));
        if (billno_error != null) {
            error = error == null ? billno_error : (!error.contains(billno_error) ? String.format(ResManager.loadKDString((String)"\u5355\u636eID[%1$s]\uff0c\u7f16\u7801[%2$s]\u6267\u884c\u4e1a\u52a1\u51fa\u9519\uff0c\u539f\u56e0\u5982\u4e0b\uff1a%3$s\uff1b%4$s", (String)"ExecutionData_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id, billno, error, billno_error) : String.format(ResManager.loadKDString((String)"\u5355\u636eID[%1$s]\u6267\u884c\u4e1a\u52a1\u51fa\u9519\uff0c\u539f\u56e0\u5982\u4e0b\uff1a%2$s", (String)"ExecutionData_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id, error));
        }
        return error;
    }

    private static String toString(Object s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    private static Map<String, Object> organizeResult(OperationResult result) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>(16);
        List errorOrValidateInfo = result.getAllErrorOrValidateInfo();
        for (IOperateInfo info : errorOrValidateInfo) {
            int i;
            String message = info.getMessage();
            String pk = D.s((Object)info.getPkValue());
            if (pk != null && !"0".equals(pk)) {
                ExecutionData.addErrorMessage(errorMap, pk, message);
            }
            if ((i = message.indexOf(58)) <= 0) continue;
            String number = message.substring(0, i);
            ExecutionData.addErrorMessage(errorMap, number, message);
        }
        for (Object id : result.getSuccessPkIds()) {
            String s = D.s(id);
            errorMap.put(s, Boolean.TRUE);
        }
        return errorMap;
    }

    private static boolean isEndExpr(String str) {
        String s = str.trim();
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(s.length() - 1);
        switch (c) {
            case '!': 
            case '.': 
            case ';': 
            case '\u3002': 
            case '\uff01': 
            case '\uff1b': {
                return true;
            }
        }
        return false;
    }

    private static void addErrorMessage(Map<String, Object> errorMap, String key, String message) {
        StringBuilder description = (StringBuilder)errorMap.get(key);
        if (description != null) {
            if (!ExecutionData.isEndExpr(description.toString())) {
                description.append(';');
            }
            description.append("\r\n").append(message);
        } else {
            description = new StringBuilder();
            description.append("\r\n").append(message);
            errorMap.put(key, description);
        }
    }

    public static Object execute(String entity, DynamicObject object, String operation, Map<String, Object> targetActionParams) {
        if ("_ENTITY_SAVE".equals(operation)) {
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            Object id = ((DynamicObject)result[0]).getPkValue();
            if (ExecutionData.recordLogs()) {
                LOGGER.info("\u8c03\u7528\u5b9e\u4f53\u7684\u6570\u636e\u5e93\u4fdd\u5b58\u64cd\u4f5c\u540e\uff0cID\u662f\uff1a" + id);
            }
            return id;
        }
        OperateOption option = ExecutionData.initOperation(targetActionParams, operation);
        return ExecutionData.doOperations(entity, object, operation, option);
    }

    private static OperateOption initOperation(Map<String, Object> targetActionParams, String operation) {
        Map map = targetActionParams == null || targetActionParams.get(operation) == null ? Collections.emptyMap() : (Map)targetActionParams.get(operation);
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue(PARAM_CONNECTOR, String.valueOf(Util.isConnectorThread()));
            for (Map.Entry entry : map.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
            return option;
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u4f20\u9001\u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a{\"\u64cd\u4f5c\"\uff1a[\"key\":\"value\"]}\u5f62\u5f0f", (String)"ExecutionData_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static Object execute(String entity, DynamicObject object, String operation) {
        OperateOption option = OperateOption.create();
        option.setVariableValue(PARAM_CONNECTOR, String.valueOf(Util.isConnectorThread()));
        return ExecutionData.doOperations(entity, object, operation, option);
    }

    private static Object doOperations(String entity, DynamicObject object, String operation, OperateOption option) {
        try {
            Object id;
            long begin = System.currentTimeMillis();
            OperationResult result = OperationServiceHelper.executeOperate((String)ExecutionData.parseOperation(operation), (String)entity, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)option);
            CommonUtil.check(result);
            List successPkIds = result.getSuccessPkIds();
            Object v0 = id = result.isSuccess() && !CollectionUtils.isEmpty(successPkIds) ? successPkIds.get(0) : null;
            if (ExecutionData.recordLogs()) {
                LOGGER.info("\u8c03\u7528\u5b9e\u4f53" + entity + "\u64cd\u4f5c" + operation + "\u540e\uff0cID\uff1a" + object.get("id") + "\uff0csuccess:" + result.isSuccess() + "\uff0cresult_succ_pk\uff1a" + id + ".\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin) + "ms.");
            }
            return id;
        }
        catch (Exception e) {
            if (ExecutionData.recordLogs()) {
                LOGGER.warn("\u8c03\u7528\u5b9e\u4f53" + entity + "\u64cd\u4f5c" + operation + "\u51fa\u9519", (Throwable)e);
            }
            throw e;
        }
    }

    public static Object execute(DynamicObject object, String operation) {
        return ExecutionData.execute(object.getDataEntityType().getName(), object, operation);
    }

    public static Object execute(DynamicObject object, String operation, OperateOption option) {
        return ExecutionData.doOperations(object.getDataEntityType().getName(), object, operation, option);
    }

    private static String parseOperation(String operation) {
        if (operation.equals(TableAction._INSERT.name())) {
            return "save";
        }
        if (operation.equals(TableAction._UPDATE.name())) {
            return "save";
        }
        return operation;
    }

    private static boolean recordLogs() {
        try {
            return D.x((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)AppParameterServiceHelper.getAppParam(), (String)"entity_op_monitor_log"));
        }
        catch (Throwable t) {
            LOGGER.error("\u83b7\u53d6\u96c6\u6210\u4e91\u53c2\u6570entity_op_monitor_log\u5931\u8d25", t);
            return false;
        }
    }
}

