/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.AccountEventUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;

public class MetaList {
    private static Log log = LogFactory.getLog(ConnectionManager.class);

    public static Map<String, MetaType> get() {
        DynamicObject[] entities = MetaList.loadEntities();
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>();
        for (DynamicObject o : entities) {
            String name = D.s((Object)o.get("id"));
            SignalManager.checkCancelSignal();
            try {
                MainEntityType entity = EntityMetadataCache.getDataEntityType((String)name);
                metas.put(entity.getName(), MetaType.ENTITY);
                for (EntityType e : entity.getAllEntities().values()) {
                    MetaList.addRelatedMeta(metas, e, entity);
                }
            }
            catch (Exception e) {
                log.warn("kd.isc.iscb.platform.core.connector.self.GetMetaList.get(" + name + ")", (Throwable)e);
            }
        }
        try {
            metas.putAll(AccountEventUtil.getAllEvent());
        }
        catch (Exception e) {
            log.warn("kd.isc.iscb.platform.core.connector.self.GetMetaList.get .Exception occurred while synchronizing accounting events", (Throwable)e);
        }
        return metas;
    }

    public static DynamicObject[] loadEntities() {
        QFilter q1 = new QFilter("tablename", "!=", (Object)" ");
        QFilter q2 = new QFilter("pkfieldname", "!=", (Object)" ");
        QFilter q3 = new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"});
        DynamicObject[] entities = BusinessDataServiceHelper.load((String)"bos_entityinfo", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
        return entities;
    }

    private static void addRelatedMeta(Map<String, MetaType> metas, EntityType entity, MainEntityType main) {
        MetaList.addTables(metas, entity, main);
    }

    private static void addEnums(Map<String, MetaType> metas, EntityType entity, MainEntityType main) {
        for (IDataEntityProperty p : entity.getProperties()) {
            String name;
            if (!(p instanceof ComboProp)) continue;
            if (entity == main) {
                name = main.getName() + "." + p.getName();
                metas.put(name, MetaType.ENUM);
                continue;
            }
            name = main.getName() + "." + entity.getName() + "." + p.getName();
            metas.put(name, MetaType.ENUM);
        }
    }

    private static void addTables(Map<String, MetaType> metas, EntityType entity, MainEntityType main) {
        String alias = D.s((Object)entity.getAlias());
        if (alias == null) {
            return;
        }
        String db = main.getDBRouteKey().toUpperCase();
        String table = alias.toUpperCase();
        String key = table + "@" + db;
        metas.put(key, MetaType.TABLE);
        for (IDataEntityProperty p : entity.getProperties()) {
            String group = D.s((Object)p.getTableGroup());
            if (group != null) {
                String suffix = group.toUpperCase();
                metas.put(table + "_" + suffix + "@" + db, MetaType.TABLE);
                continue;
            }
            if (!(p instanceof MuliLangTextProp)) continue;
            metas.put(table + "_L@" + db, MetaType.TABLE);
        }
    }

    private static void addEntity(Map<String, MetaType> metas, EntityType entity, MainEntityType main) {
        String name = entity == main ? entity.getName() : main.getName() + "." + entity.getName();
        metas.put(name, MetaType.ENTITY);
    }
}

