/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.connector.self.IerpDataPusher;
import kd.isc.iscb.platform.core.connector.self.PushDataTask;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.DataPusher;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class PushDataJobHandler
implements LightTask {
    private static Log logger = LogFactory.getLog(PushDataJobHandler.class);
    private static final Map<String, AtomicInteger> intervals = new ReadLockFreeMap();
    private String accountKey;
    private int interval;

    static boolean isMQType() {
        try {
            String pushType = D.s((Object)AppParameterServiceHelper.getParameterFromCache("event_push_type"));
            return "mq".equalsIgnoreCase(pushType);
        }
        catch (Exception e) {
            logger.warn("AppParameterServiceHelper.getParameterFromCache failed.", (Throwable)e);
            return false;
        }
    }

    public static void dataArrived(Connection cn, List<Object> eventsId) {
        if (PushDataJobHandler.isMQType()) {
            PushDataJobHandler.pushData(cn, eventsId);
        } else {
            PushDataJobHandler.dataArrived();
        }
    }

    private static void pushData(Connection cn, List<Object> eventsId) {
        ArrayList<Integer> types = new ArrayList<Integer>(eventsId.size());
        ArrayList<Object> values = new ArrayList<Object>(eventsId.size());
        String sql = "SELECT fid, fisc_hub, ftrigger_type,ftrigger_id, fboid, fdata FROM T_ISCB_CON_EVT_QUE" + PushDataJobHandler.generateWhereSql(eventsId, types, values) + " and fstate in('C','R')";
        ObjectReader reader = null;
        try {
            reader = DbUtil.executeQuery((Connection)cn, (String)sql, values, types);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                String id = D.s((Object)row.get((Object)"fid"));
                String iscHub = D.s((Object)row.get((Object)"fisc_hub"));
                String triggerId = D.s((Object)row.get((Object)"ftrigger_id"));
                String triggerType = D.s((Object)row.get((Object)"ftrigger_type"));
                String data = D.s((Object)row.get((Object)"fdata"));
                TaskManager.submit(new PushDataTask(id, iscHub, triggerId, triggerType, data));
                row = (DataRow)reader.read();
            }
        }
        catch (Exception e) {
            try {
                throw D.e((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(reader);
                throw throwable;
            }
        }
        DbUtil.close((ObjectReader)reader);
    }

    private static String generateWhereSql(List<Object> eventsId, List<Integer> types, List<Object> values) {
        StringBuilder sb = new StringBuilder(" WHERE fid in(");
        for (Object id : eventsId) {
            if (!types.isEmpty()) {
                sb.append(',');
            }
            sb.append('?');
            types.add(12);
            values.add(id);
        }
        sb.append(')');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushMQ(String id, EventBindingCache.EventArgs args, String data) {
        if (id == null) {
            logger.warn("failed to save event to table T_ISCB_CON_EVT_QUE. id==null");
        } else {
            try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("isc", "isc_event_queue");){
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", id);
                map.put("isc_hub", args.getIscHub());
                map.put("trigger_id", args.getTriggerId());
                map.put("trigger_type", args.getTriggerType());
                map.put("data", data);
                publisher.publish(map);
            }
        }
    }

    public static void dataArrived() {
        String accountKey = RequestContext.get().getAccountId();
        AtomicInteger i = intervals.get(accountKey);
        if (i == null) {
            PushDataJobHandler.init();
            i = intervals.get(accountKey);
        }
        i.set(1);
    }

    public static synchronized void init() {
        RequestContext ctx = RequestContext.get();
        String accountKey = ctx.getAccountId();
        if (!intervals.containsKey(accountKey)) {
            RequestContext ctx2 = ContextUtil.createRequestContext(accountKey, ctx.getTenantId());
            ScheduleManager.submit((Task)new PushDataJobHandler(accountKey), ctx2, 1);
            intervals.put(accountKey, new AtomicInteger(32));
        }
    }

    public PushDataJobHandler(String accountKey) {
        this.accountKey = accountKey;
        this.interval = 1;
    }

    @Override
    public String getId() {
        return "PUSH-" + this.accountKey;
    }

    @Override
    public void run() {
        try {
            if (this.timeout()) {
                this.pushWithLock();
            }
        }
        catch (Throwable e) {
            logger.warn("PushDataJobHandler @" + RequestContext.get().getAccountId() + " failed.", e);
            intervals.get(this.accountKey).set(1800);
        }
        ScheduleManager.submit((Task)this, 1);
    }

    private void pushWithLock() {
        String key = "/ISC/ISCB/PUSHDATAJOB/" + RequestContext.get().getAccountId();
        try (DLock lock = DLock.create((String)key).fastMode();){
            if (lock.tryLock()) {
                this.innerPushJob();
            }
        }
    }

    private void innerPushJob() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            EventBindingUtil.pushAll((Connection)cn, (String)(this.accountKey + "," + RequestContext.get().getTenantId()), (DataPusher)new IerpDataPusher());
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private boolean timeout() {
        int TOP;
        AtomicInteger top = intervals.get(this.accountKey);
        if (++this.interval < top.get()) {
            return false;
        }
        this.interval = 0;
        int current = top.get();
        int n = TOP = PushDataJobHandler.isMQType() ? 1024 : 512;
        if (current >= TOP) {
            return true;
        }
        while (!top.compareAndSet(current, current + current)) {
            current = top.get();
        }
        return true;
    }

    static void clearCollection() {
        intervals.clear();
    }
}

