/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.self.IerpDataPusher;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.connector.DataPusher;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.misc.Json;

public class PushDataTask
implements Task {
    private static Log logger = LogFactory.getLog(PushDataTask.class);
    private String id;
    private String iscHub;
    private String triggerId;
    private String triggerType;
    private String data;

    public PushDataTask(String id, String iscHub, String triggerId, String triggerType, String data) {
        this.id = id;
        this.iscHub = iscHub;
        this.triggerId = triggerId;
        this.triggerType = triggerType;
        this.data = data;
    }

    @Override
    public String getId() {
        return "PUSH_TASK:" + UUID.randomUUID().toString().replace('-', ' ');
    }

    @Override
    public void run() {
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);){
            PushDataTask.push(cn, this.data, this.iscHub, this.triggerType, this.triggerId, this.id);
        }
        catch (Exception e) {
            logger.warn("\u4e8b\u4ef6\u63a8\u9001\u5931\u8d25\uff1aid[" + this.id + "]", (Throwable)e);
        }
    }

    static void push(Connection cn, String data, String iscHub, String triggerType, String triggerId, String eventId) {
        Object json = Json.toObject((String)data);
        if (json instanceof List) {
            List list = (List)json;
            EventBindingUtil.pushData((Connection)cn, (String)iscHub, (String)triggerType, (String)triggerId, (DataPusher)new IerpDataPusher(), (List)list, Collections.singletonList(eventId));
        } else {
            Map formatData = (Map)json;
            EventBindingUtil.pushData((Connection)cn, (String)iscHub, (String)triggerType, (String)triggerId, (DataPusher)new IerpDataPusher(), (Map)formatData, Collections.singletonList(eventId));
        }
    }
}

