/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.DynamicObjectReader;
import kd.isc.iscb.platform.core.connector.self.RegisterOpActionQueue;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.data.ArrayUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class RegisterOpActionQueueX {
    private static final Log LOGGER = LogFactory.getLog(RegisterOpActionQueueX.class);

    static void saveBillData(String entityKey, String operationKey, DynamicObject[] objects, List<EventBindingCache.EventArgs> triggers) throws SQLException {
        int batchPusherSize = D.i((Object)SystemPropertyUtils.getProptyByTenant((String)"ISC_BATCH_PUSHER_SIZE", (String)RequestContext.get().getTenantId()));
        if (batchPusherSize <= 0) {
            RegisterOpActionQueueX.innerSaveBillData(entityKey, operationKey, objects, triggers);
        } else {
            List split = ArrayUtils.split((Object[])objects, (int)batchPusherSize);
            for (List dynamicObjects : split) {
                RegisterOpActionQueueX.innerSaveBillData(entityKey, operationKey, dynamicObjects.toArray(new DynamicObject[0]), triggers);
            }
        }
    }

    private static void innerSaveBillData(String entityKey, String operationKey, DynamicObject[] objects, List<EventBindingCache.EventArgs> triggers) throws SQLException {
        for (EventBindingCache.EventArgs args : triggers) {
            try {
                Map<String, Object> requires = RegisterOpActionQueueX.getRequiredFields(args);
                ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>(objects.length);
                RegisterOpActionQueueX.dynamicObjectsToJson(batch, objects, requires, entityKey, operationKey);
                RegisterOpActionQueueX.appendAttachmentInfo(entityKey, operationKey, requires, batch);
                RegisterOpActionQueueX.appendEventInfo(batch, operationKey);
                RegisterOpActionQueueX.saveEventData(entityKey, operationKey, args, batch);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("\u6279\u91cf\u6570\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5b9e\u4f53\uff1a%s\uff0c\u64cd\u4f5c\uff1a%s\uff0c\u89e6\u53d1\u65b9\u6848id\uff1a%s\uff0c\u7c7b\u578b\uff1a%s\uff0c\u6570\u636e\u6761\u6570\uff1a%d\uff0cID\u5217\u8868: [%s]", entityKey, operationKey, args.getTriggerId(), args.getTriggerType(), objects.length, RegisterOpActionQueueX.getPkIds(objects)), (Throwable)e);
                RegisterOpActionQueueX.saveBatchError(entityKey, operationKey, args, Collections.emptyList(), objects.length, StringUtil.toString((Throwable)e));
            }
        }
    }

    private static String getPkIds(DynamicObject[] objects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            DynamicObject o = objects[i];
            sb.append(o.getPkValue());
            if (i < 100) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    private static void dynamicObjectsToJson(List<Map<String, Object>> batch, DynamicObject[] objects, Map<String, Object> requires, String entityKey, String operationKey) {
        if (operationKey.toUpperCase(Locale.ENGLISH).startsWith("DELETE")) {
            RegisterOpActionQueueX.objectsToListForDeleteAction(objects, requires, batch);
        } else if (CollectionUtils.isEmpty(requires)) {
            RegisterOpActionQueueX.objectsToListWithAllFields(entityKey, objects, batch);
        } else {
            RegisterOpActionQueueX.objectsToListWithRequiredFields(entityKey, objects, requires, batch);
        }
    }

    private static void appendEventInfo(List<Map<String, Object>> batch, String operationKey) {
        RequestContext ctx = RequestContext.get();
        for (Map<String, Object> src : batch) {
            src.put("#EVENT", operationKey);
            src.put("#UESR_ID", ctx.getCurrUserId());
            src.put("#USER_ID", ctx.getCurrUserId());
            src.put("#USER_NAME", ctx.getUserName());
        }
    }

    private static Map<String, Object> getRequiredFields(EventBindingCache.EventArgs args) {
        HashMap<String, Integer> requires = args.getRequiredFields();
        if (CollectionUtils.isEmpty(requires)) {
            return requires;
        }
        if (!requires.containsKey("id")) {
            HashMap<String, Integer> dup = new HashMap<String, Integer>(requires.size() + 1);
            dup.put("id", 1);
            dup.putAll(requires);
            requires = dup;
        }
        return requires;
    }

    private static void objectsToListWithRequiredFields(String entityKey, DynamicObject[] objects, Map<String, Object> requires, List<Map<String, Object>> batch) {
        ArrayList<Object> idList = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object id = objects[i].getPkValue();
            idList.add(id);
        }
        batch.addAll(DynamicObjectReader.read(entityKey, idList, requires));
    }

    private static void objectsToListWithAllFields(String entityKey, DynamicObject[] objects, List<Map<String, Object>> batch) {
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityKey);
        Object[] pkArray = new Object[objects.length];
        HashMap<Object, DynamicObject> idSet = new HashMap<Object, DynamicObject>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object id;
            pkArray[i] = id = objects[i].getPkValue();
            idSet.put(id, objects[i]);
        }
        for (DynamicObject bo : BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)entity)) {
            idSet.remove(bo.getPkValue());
            batch.add(DynamicObjectUtil.object2Map(bo));
        }
        for (DynamicObject bo : idSet.values()) {
            batch.add(DynamicObjectUtil.object2Map(bo));
        }
    }

    private static void objectsToListForDeleteAction(DynamicObject[] objects, Map<String, Object> requires, List<Map<String, Object>> batch) {
        for (DynamicObject bo : objects) {
            batch.add(DynamicObjectUtil.object2Map(bo, requires));
        }
    }

    private static void saveEventData(String entityKey, String operationKey, EventBindingCache.EventArgs args, List<Map<String, Object>> batch) throws SQLException {
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);){
            if (batch.size() <= 1 || RegisterOpActionQueueX.isApiTrigger(args)) {
                RegisterOpActionQueueX.saveRowByRow(cn, entityKey, operationKey, args, batch);
            } else {
                RegisterOpActionQueueX.saveBatch(cn, entityKey, operationKey, args, batch);
            }
            cn.commit();
        }
    }

    private static void saveRowByRow(Connection cn, String entityKey, String operationKey, EventBindingCache.EventArgs args, List<Map<String, Object>> batch) {
        for (Map<String, Object> row : batch) {
            String data = Json.toString(row);
            String boid = D.s((Object)row.get("id"));
            String eventId = EventBindingUtil.saveEventArgs((Connection)cn, (String)entityKey, (String)operationKey, (String)boid, (String)args.getIscHub(), (String)args.getTriggerType(), (String)args.getTriggerId(), (String)data, null);
            RegisterOpActionQueue.pushData(args, data, eventId);
        }
    }

    private static void saveBatchError(String entityKey, String operationKey, EventBindingCache.EventArgs args, List<Map<String, Object>> batch, int batchSize, String error) throws SQLException {
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);){
            String data = Json.toString(batch);
            String fakeId = "BATCH_" + batchSize + "_" + Hash.mur24((Object[])new Object[]{UUID.randomUUID()});
            EventBindingUtil.saveEventArgs((Connection)cn, (String)entityKey, (String)operationKey, (String)fakeId, (String)args.getIscHub(), (String)args.getTriggerType(), (String)args.getTriggerId(), (String)data, (String)error);
        }
    }

    private static void saveBatch(Connection cn, String entityKey, String operationKey, EventBindingCache.EventArgs args, List<Map<String, Object>> batch) {
        String data = Json.toString(batch);
        String fakeId = "BATCH_" + batch.size() + "_" + Hash.mur24((Object[])new Object[]{UUID.randomUUID()});
        String eventId = EventBindingUtil.saveEventArgs((Connection)cn, (String)entityKey, (String)operationKey, (String)fakeId, (String)args.getIscHub(), (String)args.getTriggerType(), (String)args.getTriggerId(), (String)data, null);
        RegisterOpActionQueue.pushData(args, data, eventId);
    }

    private static boolean isApiTrigger(EventBindingCache.EventArgs args) {
        String apiTrigger = EventBindingUtil.TriggerType.APITrigger.toString();
        return apiTrigger.equals(args.getTriggerType());
    }

    private static void appendAttachmentInfo(String entityKey, String operationKey, Map<String, Object> requires, List<Map<String, Object>> batch) {
        if (requires.containsKey("$supports_file_copy")) {
            for (Map<String, Object> src : batch) {
                Object pkValue = src.get("id");
                List<Map<String, Object>> attachmentList = AttachmentUtil.getAttachmentList(entityKey, pkValue);
                src.put("$file_list", attachmentList);
            }
        }
    }
}

