/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.connector.self.SelfObjectReader;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class RetrieveData {
    public static ObjectReader<Map<String, Object>> get(String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        QFilter[] qFilters = RetrieveData.parseFilter(entity, filter);
        boolean hasEntryFilter = RetrieveData.checkIfContainsEntryFilter(entity, filter);
        String orderBys = RetrieveData.parseOrderBys(orderBy);
        return new SelfObjectReader(entity, requires, qFilters, orderBys, hasEntryFilter);
    }

    private static boolean checkIfContainsEntryFilter(String entity, List<Map<String, Object>> conditionList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        for (Map<String, Object> condition : conditionList) {
            String entryName;
            DynamicProperty property;
            String filter_column = D.s((Object)condition.get("filter_column"));
            int index = filter_column.indexOf(46);
            if (index < 0 || !((property = entityType.getProperty(entryName = filter_column.substring(0, index))) instanceof EntryProp)) continue;
            return true;
        }
        return false;
    }

    private static QFilter[] parseFilter(String entity, List<Map<String, Object>> conditionList) {
        if (CollectionUtils.isEmpty(conditionList)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < conditionList.size(); ++i) {
            Map<String, Object> map = conditionList.get(i);
            sql.append(RetrieveData.trim(map.get("filter_left_bracket")));
            String field = D.s((Object)map.get("filter_column"));
            String filterCompare = D.s((Object)map.get("filter_compare"));
            String compare = CommonUtil.parseCompareType(filterCompare);
            Object filterValue = RetrieveData.cast((EntityType)entityType, field, map.get("filter_value"));
            Object value = CommonUtil.parseCompareValue(filterCompare, filterValue);
            sql.append(field).append(' ').append(compare).append(' ');
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                sql.append('(').append(CommonUtil.join(c.size(), "?", ", ")).append(')');
                params.addAll(c);
            } else if (value != null) {
                sql.append(" ? ");
                params.add(value);
            } else if (!compare.equals("is null") && !compare.equals("is not null")) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5%s\u503c\u4e3anull\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u89c4\u8303!", (String)"RetrieveData_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field));
            }
            sql.append(RetrieveData.trim(map.get("filter_right_bracket")));
            if (i == conditionList.size() - 1) continue;
            sql.append("OR".equals(map.get("filter_link")) ? " OR " : " AND ");
        }
        return new QFilter[]{QFilter.of((String)sql.toString(), (Object[])params.toArray())};
    }

    private static String parseOrderBys(List<Map<String, String>> orderByList) {
        if (CollectionUtils.isEmpty(orderByList)) {
            return null;
        }
        StringBuilder sBuilder = new StringBuilder();
        for (Map<String, String> order : orderByList) {
            if (sBuilder.length() > 0) {
                sBuilder.append(',');
            }
            sBuilder.append(order.get("sort_field")).append(' ').append(order.get("sort_mode"));
        }
        return sBuilder.toString();
    }

    public static Object trim(Object value) {
        return value != null ? value : "";
    }

    public static Object cast(EntityType entityType, String field, Object oldValue) {
        if (oldValue == null) {
            return null;
        }
        if (oldValue instanceof List) {
            return RetrieveData.castList(entityType, field, (List)oldValue);
        }
        if (oldValue instanceof Object[]) {
            return RetrieveData.castArray(entityType, field, (Object[])oldValue);
        }
        String s = oldValue.toString();
        if (s.startsWith("[") && s.endsWith("]")) {
            List list = (List)JSON.parseObject((String)s, List.class);
            return RetrieveData.castList(entityType, field, list);
        }
        return RetrieveData.castSingleValue(entityType, field, oldValue);
    }

    public static Object castSingleValue(EntityType entityType, String field, Object oldValue) {
        DynamicProperty property = RetrieveData.getProperty(entityType, field);
        if (property instanceof BasedataProp) {
            property = ((BasedataProp)property).getRefIdProp();
        }
        String s = null;
        try {
            if (oldValue == null) {
                return null;
            }
            if (property instanceof MuliLangTextProp && oldValue instanceof Map) {
                return ((Map)oldValue).get(Lang.get().name());
            }
            if (property instanceof DateTimeProp) {
                return D.t((Object)oldValue);
            }
            if (property instanceof LongProp || property instanceof BigIntProp) {
                return D.l((Object)oldValue);
            }
            if (property instanceof IntegerProp) {
                return D.i((Object)oldValue);
            }
            if (property instanceof BooleanProp) {
                return D.x((Object)oldValue);
            }
            if (property instanceof VarcharProp && (s = D.s((Object)oldValue)) != null) {
                return s;
            }
            if (property instanceof TextProp) {
                return oldValue.toString();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u5c5e\u6027%1$s\u7684\u503c%2$s\u8f6c\u6362\u4e3a%3$s\u7c7b\u578b!", (String)"RetrieveData_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field, s, property.getClass()), e);
        }
    }

    public static DynamicProperty getProperty(EntityType entityType, String field) {
        int index = field.indexOf(46);
        if (index < 0) {
            return entityType.getProperty(field);
        }
        DynamicProperty property = entityType.getProperty(field.substring(0, index));
        if (property instanceof BasedataProp) {
            String name = ((BasedataProp)property).getComplexType().getName();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)name);
            return RetrieveData.getProperty((EntityType)type, field.substring(index + 1));
        }
        if (property instanceof EntryProp) {
            DynamicObjectType type = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            return RetrieveData.getProperty((EntityType)type, field.substring(index + 1));
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5f15\u7528\u6216\u5206\u5f55\u7c7b\u578b\u5c5e\u6027\u8fc7\u6ee4, \u4e0d\u652f\u6301%1$s\u7684\u5c5e\u6027%2$s\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6!", (String)"RetrieveData_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityType.getName(), property.getName()));
    }

    private static Object castList(EntityType entityType, String field, List<?> array) {
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        for (Object item : array) {
            list.add(RetrieveData.cast(entityType, field, item));
        }
        return list;
    }

    private static Object castArray(EntityType entityType, String field, Object[] array) {
        Object[] ret = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            ret[i] = RetrieveData.cast(entityType, field, item);
        }
        return ret;
    }
}

