/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.WorkflowInfo;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.DoBizAction;
import kd.isc.iscb.platform.core.connector.self.DoDataAction;
import kd.isc.iscb.platform.core.connector.self.EntityInfo;
import kd.isc.iscb.platform.core.connector.self.EnumInfo;
import kd.isc.iscb.platform.core.connector.self.EventUtil;
import kd.isc.iscb.platform.core.connector.self.ExecuteWfUtil;
import kd.isc.iscb.platform.core.connector.self.MetaList;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.connector.self.PushDataJobHandler;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.platform.core.connector.self.SelfAttachmentInputStream;
import kd.isc.iscb.platform.core.connector.self.SelfAttachmentOutputStream;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.self.SelfContext;
import kd.isc.iscb.platform.core.connector.self.ServiceInfo;
import kd.isc.iscb.platform.core.connector.self.TableInfo;
import kd.isc.iscb.platform.core.connector.self.Util;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.AccountEventUtil;
import kd.isc.iscb.platform.core.params.MicroService;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ConnectionUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.bean.BatchTriggerInfo;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.InitStatus;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.connector.server.TargetDataHandler;
import kd.isc.iscb.util.connector.server.e.GetIndexInfo;
import kd.isc.iscb.util.connector.server.e.GetTable;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;

public final class SelfConnectionFactory
implements JdbcConnectionFactory {
    @Override
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        Util.setDynamicCfg(cfg);
        return new JdbcConnectionWrapper(new SelfConnection(), this, cfg){

            @Override
            public Object get(String property) {
                if ("ROOT_ORG_ID".equals(property)) {
                    return OrgUnitServiceHelper.getRootOrgId();
                }
                return super.get(property);
            }
        };
    }

    @Override
    public void test(ConnectionWrapper cn) {
    }

    @Override
    public boolean supportsTransaction() {
        return false;
    }

    @Override
    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        ConnectionWrapper.ensureFluidControl(cn);
        SelfConnection lcn = new SelfConnection();
        try {
            kd.isc.iscb.platform.core.connector.jdbc.Util.classify(lcn, table, rows, judgeFields, for_insert, for_update);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        ConnectionWrapper.ensureFluidControl(cn);
        return MetaList.get();
    }

    @Override
    public Table getTable(JdbcConnectionWrapper vcn, String fullname) {
        ConnectionWrapper.ensureFluidControl(vcn);
        return SelfConnectionFactory.getTable(fullname);
    }

    public static Table getTable(String fullname) {
        Connection cn = ConnectionUtil.getTableConnection(fullname);
        try {
            DatabaseMetaData meta = cn.getMetaData();
            String catalog = cn.getCatalog();
            String schema = Table.getSchema((DatabaseMetaData)meta);
            int i = fullname.indexOf(64);
            String table_name = i < 0 ? fullname : fullname.substring(0, i);
            List fields = GetTable.getTableFields((DatabaseMetaData)meta, (String)table_name, (String)catalog, (String)schema);
            List pks = GetTable.getPrimaryKeyFields((DatabaseMetaData)meta, (String)table_name, (String)catalog, (String)schema);
            Table table = new Table(fullname, ' ', fields, pks);
            return table;
        }
        catch (SQLException e) {
            throw DatabaseError.META_QUERY_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper vcn, String fullname) {
        ConnectionWrapper.ensureFluidControl(vcn);
        Connection cn = ConnectionUtil.getTableConnection(fullname);
        try {
            int i = fullname.indexOf(64);
            String table_name = i < 0 ? fullname : fullname.substring(0, i);
            Map indices = GetIndexInfo.get((Connection)cn, (String)table_name);
            HashMap data = new HashMap(indices.size());
            for (Map.Entry entry : indices.entrySet()) {
                data.put(entry.getKey(), new Index((Map)entry.getValue()));
            }
            HashMap hashMap = data;
            return hashMap;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        ConnectionWrapper.ensureFluidControl(cn);
        return EntityInfo.getEntityInfoList(name);
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        ConnectionWrapper.ensureFluidControl(cn);
        return EnumInfo.get(name);
    }

    @Override
    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String name) {
        ConnectionWrapper.ensureFluidControl(cn);
        return TableInfo.get(name);
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        ConnectionWrapper.ensureFluidControl(cn);
        try {
            return RetrieveData.get(entity, requires, filter, orderBy);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    static Connection getConnection(String sql) {
        try {
            String table_name = kd.isc.iscb.util.connector.server.Util.getTableName((String)sql);
            return ConnectionUtil.getTableConnection(table_name);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        ConnectionWrapper.ensureFluidControl(cn);
        SelfConnection lcn = new SelfConnection();
        try {
            Response response = DoDataAction.execute(lcn, data, mainTable, entryTables, judgeFields, actions);
            return response;
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        ConnectionWrapper.ensureFluidControl(cn);
        try {
            return SelfConnectionFactory.callDataHandler(targetDataHandler, data, judgeFields, proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response callDataHandler(String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        try {
            Response response;
            block12: {
                RequestContext new_rc;
                RequestContext current;
                block10: {
                    Response response2;
                    block11: {
                        Util.setConnectorThread(true);
                        current = RequestContext.get();
                        new_rc = null;
                        try {
                            if (!StringUtil.isEmpty((String)proxy_user)) {
                                new_rc = ProxyUserUtil.createRequestContext(current, proxy_user);
                                RequestContextCreator.restoreForMQ((RequestContext)new_rc);
                            }
                            if (!targetDataHandler.startsWith("msvc")) break block10;
                            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
                            params.put("data", data);
                            params.put("judgeFields", judgeFields);
                            Object result = SelfConnectionFactory.invokeService(targetDataHandler, new Object[]{params});
                            response2 = SelfConnectionFactory.getResponse(result);
                            if (new_rc == null) break block11;
                        }
                        catch (Throwable throwable) {
                            if (new_rc != null) {
                                RequestContextCreator.restoreForMQ((RequestContext)current);
                            }
                            throw throwable;
                        }
                        RequestContextCreator.restoreForMQ((RequestContext)current);
                    }
                    return response2;
                }
                TargetDataHandler h = (TargetDataHandler)ReflectionUtil.newInstance((String)targetDataHandler);
                response = h.exec((ConnectorContext)new SelfContext(), data, judgeFields, proxy_user);
                if (new_rc == null) break block12;
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
            return response;
        }
        finally {
            Util.setConnectorThread(false);
        }
    }

    private static Response getResponse(Object result) {
        if (result == null) {
            return new Response("null", "null");
        }
        Map response = result instanceof Map ? (Map)result : (Map)JSON.parseObject((String)result.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        String error = D.s(response.get("errorMessage"));
        if (error == null) {
            return new Response(D.s(response.get("id")), SelfConnectionFactory.getSaveDataType(D.s(response.get("type"))), null);
        }
        return new Response(D.s(response.get("id")), error);
    }

    private static SaveDataType getSaveDataType(String type) {
        try {
            return SaveDataType.valueOf((String)type);
        }
        catch (Exception e) {
            return SaveDataType.UNKNOWN;
        }
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        return this.doBizAction(cn, entity, data, judgeFields, actions, Collections.emptyMap(), proxy_user);
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        ConnectionWrapper.ensureFluidControl(cn);
        try {
            return SelfConnectionFactory.doBizAction(entity, data, judgeFields, actions, targetActionParams, proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response doBizAction(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        try {
            Util.setConnectorThread(true);
            Response response = DoBizAction.execute(entity, data, judgeFields, actions, targetActionParams, proxy_user);
            return response;
        }
        finally {
            Util.setConnectorThread(false);
        }
    }

    @Override
    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, String proxy_user) {
        return this.doBatchBizAction(cn, entity, batch, pk, judgeFields, action, Collections.emptyMap(), proxy_user);
    }

    @Override
    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, String proxy_user) {
        ConnectionWrapper.ensureFluidControl(cn);
        try {
            return SelfConnectionFactory.doBatchBizAction(entity, batch, pk, judgeFields, action, targetActionParams, proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Response> doBatchBizAction(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, String proxy_user) {
        try {
            Util.setConnectorThread(true);
            List<Response> list = DoBizAction.batchExecute(entity, batch, pk, judgeFields, Collections.singletonList(action), targetActionParams, proxy_user);
            return list;
        }
        finally {
            Util.setConnectorThread(false);
        }
    }

    @Override
    public boolean supportsBizBatchAction(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        ConnectionWrapper.ensureFluidControl(cn);
        SelfConnection lcn = new SelfConnection();
        try {
            EventUtil.detachEvents(lcn, "{self}", type, triggerId, entity);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        ConnectionWrapper.ensureFluidControl(cn);
        SelfConnection lcn = new SelfConnection();
        try {
            EventUtil.attachEvents(lcn, "{self}", type, triggerId, entity, events, requires);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public char getQuot() {
        return ' ';
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        ConnectionWrapper.ensureFluidControl(cn);
        return ServiceInfo.get(service_name);
    }

    @Override
    public List<Map<String, Object>> getServiceInfoX(ConnectionWrapper cn, String service_name) {
        ConnectionWrapper.ensureFluidControl(cn);
        return ServiceInfo.getX(service_name);
    }

    @Override
    public boolean supportsEvent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rePushEventData(ConnectionWrapper cn, List<Object> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ConnectionWrapper.ensureFluidControl(cn);
        SelfConnection lcn = new SelfConnection();
        try {
            EventBindingUtil.repush((Connection)lcn, ids);
            PushDataJobHandler.dataArrived();
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    @Override
    public Map<String, InitResult> checkInitState(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        HashMap<String, InitResult> checkResult = new HashMap<String, InitResult>(3);
        checkResult.put("Autoritys", new InitResult(InitStatus.NEED_NOT_INIT, null));
        checkResult.put("EventLog", new InitResult(InitStatus.NEED_NOT_INIT, null));
        checkResult.put("Bindings", this.checkBindings(data));
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitResult checkBindings(Map<String, Object> data) {
        InitResult result = new InitResult(InitStatus.NEED_NOT_INIT, null);
        String sql = "select ftrigger_id,fisc_hub,fevents,frequired_fields from T_ISCB_CON_EVT_BND WHERE fisc_hub = ? order by ftrigger_id";
        List<String> values = Collections.singletonList("{self}");
        List<Integer> types = Collections.singletonList(12);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            ArrayList<Map<String, Object>> bindTriggers = new ArrayList<Map<String, Object>>(10);
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, values, types)) {
                Map item = row.toMap();
                bindTriggers.add(item);
            }
            BatchTriggerInfo batchTrigger = (BatchTriggerInfo)data.get("Bindings");
            List triggers = batchTrigger.getTriggers();
            if (triggers.size() != bindTriggers.size()) {
                EventUtil.markTriggerCountNotEqual(result);
            } else {
                EventUtil.checkTriggerContent(result, batchTrigger, triggers, bindTriggers);
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return result;
    }

    @Override
    public Map<String, InitResult> initEnv(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        HashMap<String, InitResult> initResult = new HashMap<String, InitResult>(3);
        initResult.put("Autoritys", new InitResult(InitStatus.NEED_NOT_INIT, null));
        initResult.put("EventLog", new InitResult(InitStatus.NEED_NOT_INIT, null));
        initResult.put("Bindings", this.initBindings(data));
        return initResult;
    }

    private InitResult initBindings(Map<String, Object> data) {
        InitResult result = new InitResult(InitStatus.NEED_NOT_INIT, null);
        try {
            InitResult checkResult = this.checkBindings(data);
            if (checkResult.getStatus() == InitStatus.NEED_INIT) {
                this.initEventListeners(data);
                result.setStatus(InitStatus.INIT_COMPLETE);
            }
        }
        catch (Throwable e) {
            result.setStatus(InitStatus.INIT_ERROR);
            result.setErrorStack(StringUtil.toString((Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEventListeners(Map<String, Object> data) throws Exception {
        BatchTriggerInfo batchTrigger = (BatchTriggerInfo)data.get("Bindings");
        List<String> values = Collections.singletonList("{self}");
        List<Integer> types = Collections.singletonList(12);
        String sql = "delete from T_ISCB_CON_EVT_BND where fisc_hub = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            EventUtil.saveTriggerInfo(batchTrigger, cn);
            RequestContext rc = RequestContext.get();
            EventBindingCache.init((String)rc.getAccountId(), (Connection)cn);
            EventUtil.eventRegister(batchTrigger, rc);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case ENTITY: 
            case ENUM: 
            case TABLE: 
            case VIEW: 
            case SERVICE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseEvent(ConnectionWrapper cn, String handler, Map<String, Object> data) {
        block8: {
            if (D.s((Object)handler) == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u4e8b\u4ef6\u5904\u7406\u5668!", (String)"SelfConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            ConnectionWrapper.ensureFluidControl(cn);
            try {
                if (handler.startsWith("msvc://")) {
                    SelfConnectionFactory.invokeService(handler, new Object[]{data});
                    break block8;
                }
                String[] mqHandler = handler.split("\\.");
                if (mqHandler.length != 2) {
                    throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53d1\u5e03\u5230\u82cd\u7a79\u7684\u6d88\u606f\u961f\u5217\u540d\u79f0\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3aregion.queue_name\u5f62\u5f0f\u3002", (String)"SelfConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                }
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher(mqHandler[0], mqHandler[1]);){
                    pub.publish(data);
                }
            }
            catch (Exception e) {
                IscBizException e2 = new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u82cd\u7a79\u7aef[\u4efb\u52a1\u7f16\u6392->\u4e8b\u4ef6\u5904\u7406]\u5931\u8d25\uff0c\u4e8b\u4ef6\u5904\u7406\u5668\uff1a%1$s\uff0c\u539f\u56e0\uff1a%2$s", (String)"SelfConnectionFactory_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), handler, e.getMessage()), (Throwable)e);
                ConnectionWrapper.rewrite((Throwable)e2, cn);
                throw e2;
            }
        }
    }

    @Override
    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        ConnectionWrapper.ensureFluidControl(cn);
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext(current, proxyUser);
            if (service.startsWith("account_event://")) {
                Object object = AccountEventUtil.invokeEvent(params);
                return object;
            }
            Assert.isTrue((service.startsWith("mservice://") || service.startsWith("xapi://") || service.startsWith("openapi_query://") || service.startsWith("openapi_invoke://") || service.startsWith("openapi_invoke2://") ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u670d\u52a1URL\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u5e94\u4ee5 mservice:// \u5f00\u5934\uff08\u901a\u8fc7\u96c6\u6210\u5bf9\u8c61\u5b9a\u4e49\uff09\u6216 xapi://\u5f00\u5934\uff08\u901a\u8fc7\u5916\u90e8API\u5b9a\u4e49\uff09\u6216 \u4ee5openapi_query:// \u5f00\u5934\uff08OpenAPI\uff09 \u6216 openapi_invoke://\u5f00\u5934\uff08OpenAPI\uff09", (String)"SelfConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            if (service.startsWith("openapi_query://") || service.startsWith("openapi_invoke://") || service.startsWith("openapi_invoke2://")) {
                Object object = SelfConnectionFactory.handleOpenAPI(service, params);
                return object;
            }
            Object[] values = this.castParams(cn, service, params);
            Object object = SelfConnectionFactory.invokeService(service, values);
            return object;
        }
        catch (Exception e) {
            IscBizException e2 = new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1%1$s\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"SelfConnectionFactory_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), service, e.getMessage()), (Throwable)e);
            ConnectionWrapper.rewrite((Throwable)e2, cn);
            throw e2;
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private static Object handleOpenAPI(String service, Map<String, Object> params) {
        if (service.startsWith("openapi_invoke://")) {
            String openApi = service.substring(service.indexOf("//") + 1);
            return JSON.toJSON((Object)OpenApiSdkUtil.invoke((String)openApi, params));
        }
        if (service.startsWith("openapi_invoke2://")) {
            String openApi = service.substring(service.indexOf("//") + 1);
            return JSON.toJSON((Object)OpenApiSdkUtil.invokeOpenApi((String)openApi, (Map)((Map)params.get("requestData")), (Map)((Map)params.get("header"))));
        }
        String openApi = service.substring(service.indexOf("//") + 1);
        int pageSize = params.get("pageSize") == null ? 10 : D.i((Object)params.get("pageSize"));
        int pageNo = params.get("pageNo") == null ? 1 : D.i((Object)params.get("pageNo"));
        return JSON.toJSON((Object)OpenApiSdkUtil.query((String)openApi, (Map)((Map)params.get("data")), (int)pageSize, (int)pageNo));
    }

    public static Object invokeService(String service, Object[] params) {
        MicroService s = ServiceInfo.parseService(service);
        if ("bos".equals(s.getCloudId())) {
            return DispatchServiceHelper.invokeBOSService((String)s.getAppId(), (String)s.getServiceName(), (String)s.getMethodName(), (Object[])params);
        }
        if (s.isIsv()) {
            return DispatchServiceHelper.invokeService((String)s.getCloudId(), (String)s.getAppId(), (String)s.getServiceName(), (String)s.getMethodName(), (Object[])params);
        }
        return DispatchServiceHelper.invokeBizService((String)s.getCloudId(), (String)s.getAppId(), (String)s.getServiceName(), (String)s.getMethodName(), (Object[])params);
    }

    private Object[] castParams(ConnectionWrapper cn, String service, Map<String, Object> params) {
        if (cn == null || cn.getConfig() == null || service.startsWith("xapi")) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(params);
            map.remove("$action");
            return map.values().toArray();
        }
        QFilter filter = new QFilter("group.dblink_id", "=", cn.getConfig().getPkValue()).and("full_name", "=", (Object)service).and(new QFilter("type", "in", Arrays.asList("SERVICE", "QUERY")));
        DynamicObject meta = MetaDataSchema.getOneByFilter(filter);
        if (meta == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u670d\u52a1\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61.", (String)"SelfConnectionFactory_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), service));
        }
        DynamicObjectCollection paramEntries = meta.getDynamicObjectCollection("param_entryentity");
        Object[] objects = new Object[paramEntries.size()];
        for (int i = 0; i < paramEntries.size(); ++i) {
            DynamicObject item = (DynamicObject)paramEntries.get(i);
            String field = item.getString("param_number");
            String type = item.getString("param_type").toLowerCase();
            Object value = params.get(field);
            objects[i] = this.castValue(type, value);
        }
        return objects;
    }

    private Object castValue(String type, Object value) {
        if (value == null) {
            return null;
        }
        if ("string".equals(type)) {
            value = D.s((Object)value);
        } else if ("int".equals(type)) {
            value = D.i((Object)value);
        } else if ("long".equals(type)) {
            value = D.l((Object)value);
        } else if ("boolean".equals(type)) {
            value = D.x((Object)value);
        } else if ("date".equals(type) || "datetime".equals(type)) {
            value = D.t((Object)value);
        } else if ("object[]".equals(type)) {
            value = new JSONObject[]{value};
        } else if (!"object".equals(type)) {
            if ("map".equals(type)) {
                if (value instanceof String) {
                    value = JSON.parseObject((String)D.s((Object)value));
                } else if (!(value instanceof Map)) {
                    throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0e\u503c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u503c\u5e94\u4e3aMap\u7c7b\u578b!", (String)"SelfConnectionFactory_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                }
            } else if ("list".equals(type)) {
                value = value instanceof String && ((String)value).startsWith("[") && ((String)value).endsWith("]") ? JSON.parseArray((String)D.s((Object)value)) : CollectionUtils.toList(value);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"SelfConnectionFactory_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
            }
        }
        return value;
    }

    @Override
    public boolean supportsAttachment(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public boolean isAttachmentChanged(ConnectionWrapper cn, Map<String, Object> attachment, String md5Code) {
        ConnectionWrapper.ensureFluidControl(cn);
        return AttachmentUtil.isAttachmentChanged(attachment, md5Code);
    }

    @Override
    public AbstractInputStream getAttachmentReader(ConnectionWrapper cn, Map<String, Object> attachment) {
        ConnectionWrapper.ensureFluidControl(cn);
        String url = D.s((Object)attachment.get("srcUrl"));
        return new SelfAttachmentInputStream(FileServiceFactory.getAttachmentFileService().getInputStream(url));
    }

    @Override
    public AbstractOutputStream getAttachmentWriter(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        ConnectionWrapper.ensureFluidControl(cn);
        File tempFile = AttachmentUtil.createTempFile(D.s((Object)fileInfo.get("type")));
        try {
            return new SelfAttachmentOutputStream(tempFile, fileInfo);
        }
        catch (FileNotFoundException e) {
            throw CommonError.OUTPUT_WRITER_FAILURE.wrap((Throwable)e);
        }
    }

    @Override
    public List<WorkflowInfo> initiateWorkflow(ConnectionWrapper cn, String entity, String operation, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        ConnectionWrapper.ensureFluidControl(cn);
        return ExecuteWfUtil.initiateWorkflow(entity, operation, idList, proxyUser, extendInfo);
    }

    @Override
    public List<WorkflowInfo> queryWorkflowState(ConnectionWrapper cn, String entity, String operation, List<String> idList) {
        ConnectionWrapper.ensureFluidControl(cn);
        return ExecuteWfUtil.getStatusByIds(idList);
    }

    @Override
    public List<WorkflowInfo> getWorkflowState(ConnectionWrapper cn, List<String> workflowInstanceIdList) {
        ConnectionWrapper.ensureFluidControl(cn);
        return ExecuteWfUtil.getWorkflowState(workflowInstanceIdList);
    }
}

