/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.DistinctChecker;
import kd.isc.iscb.platform.core.connector.self.DynamicObjectReader;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class SelfObjectReader
implements ObjectReader<Map<String, Object>> {
    private String entity;
    private DataSet rows;
    private int count;
    private Map<String, Object> requires;

    SelfObjectReader(String entity, Map<String, Object> requires, QFilter[] qFilters, String orderBys, boolean hasEntryFilter) {
        this.entity = entity;
        requires.put("id", 1);
        this.requires = requires;
        ORM orm = ORM.create();
        if (hasEntryFilter) {
            this.count = orm.count("isc_retrievedata", entity, "id", qFilters, (Distinctable)DistinctChecker.INSTANCE);
            this.rows = orm.queryDataSet("isc_retrievedata", entity, "id", qFilters, orderBys, -1, (Distinctable)DistinctChecker.INSTANCE);
        } else {
            this.count = orm.count("isc_retrievedata", entity, qFilters);
            this.rows = orm.queryDataSet("isc_retrievedata", entity, "id", qFilters, orderBys);
        }
    }

    SelfObjectReader(String entity, Map<String, Object> requires, QFilter[] qFilters, String orderBys) {
        this(entity, requires, qFilters, orderBys, false);
    }

    public int getTotalCount() {
        return this.count;
    }

    public Map<String, Object> read() {
        if (this.rows.hasNext()) {
            Object id = SelfObjectReader.formatPkValue(this.rows.next().get("id"));
            return this.innerRead(id);
        }
        return null;
    }

    public Map<String, Object> innerRead(Object id) {
        if ("true".equals(System.getProperty("ISC_READ_NEW_TX"))) {
            try (TXHandle tx = TX.requiresNew();){
                Map<String, Object> map = this.executeQuery(id);
                return map;
            }
        }
        return this.executeQuery(id);
    }

    private Map<String, Object> executeQuery(Object id) {
        Map<String, Object> src = DynamicObjectReader.read(this.entity, id, this.requires);
        if (this.requires.containsKey("$supports_file_copy")) {
            List<Map<String, Object>> attachmentList = AttachmentUtil.getAttachmentList(this.entity, id);
            src.put("$file_list", attachmentList);
        }
        return src;
    }

    public void close() {
        this.rows.close();
    }

    private static Object formatPkValue(Object id) {
        if (id == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u4e3b\u952e\u4e3anull\uff01", (String)"SelfObjectReader_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (id instanceof Number) {
            return D.l((Object)id);
        }
        return D.s((Object)id);
    }
}

