/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.Assert;
import kd.bos.service.lookup.ServiceLookup;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.ServiceEventFactory;
import kd.isc.iscb.platform.core.params.MicroService;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;

public class ServiceInfo {
    public static List<Map<String, Object>> getX(String full_name) {
        if (full_name.startsWith("account_event://")) {
            return ServiceEventFactory.create(full_name).getServiceInfo();
        }
        return Collections.singletonList(ServiceInfo.get(full_name));
    }

    public static Map<String, Object> get(String full_name) {
        MicroService service = ServiceInfo.parseService(full_name);
        Field serviceMap = null;
        Class<?> factory = null;
        try {
            factory = ServiceInfo.loadServiceFactory(service);
            serviceMap = ServiceInfo.getServiceMapField(factory);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6682\u65f6\u65e0\u6cd5\u83b7\u53d6\u8be5\u670d\u52a1,\u8bf7\u624b\u52a8\u586b\u5199!", (String)"ServiceInfo_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        try {
            Map serviceImpls = (Map)serviceMap.get(factory);
            Map<String, Object> meta = ServiceInfo.initServiceMap(full_name);
            for (Map.Entry<String, String> entry : serviceImpls.entrySet()) {
                if (!ServiceInfo.foundServiceMataInfo(service, meta, entry)) continue;
                return meta;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            throw D.e((Throwable)e);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u670d\u52a1%1$s\uff0c\u8bf7\u68c0\u67e5\u5fae\u670d\u52a1\u540d\u662f\u5426\u6b63\u786e.", (String)"ServiceInfo_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), full_name));
    }

    private static boolean foundServiceMataInfo(MicroService service, Map<String, Object> meta, Map.Entry<String, String> entry) throws ClassNotFoundException {
        Method[] methods;
        if (!entry.getKey().equals(service.getServiceName())) {
            return false;
        }
        Class<?> clazz = Class.forName(entry.getValue());
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!m.getName().equals(service.getMethodName())) continue;
            meta.put("params", ServiceInfo.getParameters(m));
            meta.put("returns", ServiceInfo.getReturns(m));
            return true;
        }
        return false;
    }

    private static Field getServiceMapField(Class<?> factory) throws NoSuchFieldException {
        Field serviceMap = factory.getDeclaredField("serviceMap");
        serviceMap.setAccessible(true);
        return serviceMap;
    }

    private static Class<?> loadServiceFactory(MicroService service) {
        String factoryServiceName;
        String cloudId = service.getCloudId();
        if ("bos".equals(cloudId)) {
            factoryServiceName = "kd.bos.service.ServiceFactory";
        } else {
            String appId = ServiceLookup.getServiceAppId((String)service.getAppId());
            factoryServiceName = String.format("kd.%s.%s.servicehelper.ServiceFactory", cloudId, appId);
        }
        Class factory = TypesContainer.getOrRegister((String)factoryServiceName);
        return factory;
    }

    private static List<Map<String, Object>> getParameters(Method method) {
        int count = method.getParameterCount();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(count);
        Parameter[] parameters = method.getParameters();
        int parametersLength = parameters.length;
        for (int i = 0; i < parametersLength; ++i) {
            Parameter p = parameters[i];
            TreeMap<String, Object> item = new TreeMap<String, Object>();
            item.put("index", i + 1);
            item.put("name", p.getName());
            item.put("label", ResManager.loadKDString((String)"\u53c2\u6570", (String)"ServiceInfo_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            item.put("data_type", p.getType().getSimpleName());
            list.add(item);
        }
        return list;
    }

    private static List<Map<String, Object>> getReturns(Method method) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
        if (method.getReturnType() != Void.class) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("index", 1);
            item.put("name", "result");
            item.put("label", ResManager.loadKDString((String)"\u7ed3\u679c", (String)"ServiceInfo_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            item.put("data_type", method.getReturnType().getSimpleName());
            list.add(item);
        }
        return list;
    }

    private static Map<String, Object> initServiceMap(String service_name) {
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put("full_name", service_name);
        meta.put("name", Hash.mur32((Object[])new Object[]{service_name}));
        meta.put("type", "SERVICE");
        meta.put("title", ResManager.loadKDString((String)"\u5fae\u670d\u52a1", (String)"ServiceInfo_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return meta;
    }

    public static MicroService parseService(String service) {
        String fullName = service.substring(service.lastIndexOf(47) + 1);
        String[] args = fullName.split("\\.");
        if (args.length < 3) {
            throw new IllegalArgumentException("\u5fae\u670d\u52a1\u53c2\u6570\u4e0d\u6b63\u786e\uff0c//\u540e\u9762\u5e94\u4e3aappId.serviceName.methodName\u6216cloudId.appId.serviceName.methodName\u7684\u683c\u5f0f!");
        }
        int index = fullName.indexOf("@isv");
        if (index > 0) {
            return ServiceInfo.invokeIsvService(fullName, index);
        }
        return ServiceInfo.invokeStandardService(args);
    }

    private static MicroService invokeStandardService(String[] args) {
        if (args.length == 3) {
            return new MicroService(args[0], args[1], args[2], null);
        }
        return new MicroService(args[0], args[1], args[2], args[3], null);
    }

    private static MicroService invokeIsvService(String fullName, int index) {
        String isv = fullName.substring(0, index + 4);
        String substring = fullName.substring(index + 5);
        String[] args1 = substring.split("\\.");
        Assert.isTrue((args1.length >= 3 ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u670d\u52a1\u53c2\u6570\u683c\u5f0f\u81f3\u5c113\u4e2a\uff0c\u5305\u542bappID, serviceName, method", (String)"ServiceInfo_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return new MicroService(isv, args1[0], args1[1], args1[2], null);
    }
}

