/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.ServiceFlowApiDispatcher;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.sf.trigger.ServiceFlowGenerator;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ConnectionUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.trace.TraceTask;

public class StartEventServiceFlow
implements NativeFunction,
Const {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(ScriptContext ctx, Object[] args) {
        if (args == null || args.length != 4) {
            throw new IscBizException(ResManager.loadKDString((String)"StartEventServiceFlow\u51fd\u6570\u9700\u63d0\u4f9b4\u4e2a\u53c2\u6570\uff1a\uff1a\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u3001\u53c2\u6570\u3001\u4ee3\u7406\u7528\u6237\u3001\u662f\u5426\u540c\u6b65\u6267\u884c\u3002", (String)"StartEventServiceFlow_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String flowNumber = D.s((Object)args[0]);
        Map<String, Object> filterMap = this.checkParam(args, 1);
        String proxyUser = D.s((Object)args[2]);
        boolean isSync = D.x((Object)args[3]);
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext(current, proxyUser);
            ServiceFlow serviceFlow = ServiceFlow.getSchema(flowNumber);
            this.checkValid(serviceFlow, flowNumber);
            long flowId = D.l((Object)serviceFlow.getFlow().getPkValue());
            Flow flow = ServiceFlowParser.getFlow(serviceFlow.getReleasedFlowId());
            EventStarterParser.EventStarter starter = (EventStarterParser.EventStarter)ServiceFlowParser.getStarter(flow);
            Map<String, Object> eventData = this.getEventData(flowId, filterMap, starter);
            if (isSync) {
                Map<String, Object> map = StartEventServiceFlow.createAndExecute(serviceFlow.getReleasedFlowId(), starter.getVarName(), eventData);
                return map;
            }
            Object object = ServiceFlowGenerator.generate(flowId, eventData);
            return object;
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> createAndExecute(long flowId, String varName, Map<String, Object> data) {
        HashMap<String, Object> flowData = new HashMap<String, Object>();
        flowData.put(varName, data);
        DynamicObject proc = ProcessRuntime.create(flowId, new Object[0], flowData, Collections.emptyMap());
        final long procInstId = proc.getLong("id");
        final FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
        runtime.setLoggerLevel(Logger.Level.WARN);
        ProcessRuntime.setRunning(procInstId, ProcessState.Created);
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", flowId));
        DataSourceResource.createConnectionPool();
        try {
            TraceStack.run(TraceType.EXE_SFP, proc, new TraceTask(){

                public void run() {
                    try {
                        runtime.resume();
                        ProcessRuntime.saveState(procInstId, runtime);
                    }
                    catch (Throwable e) {
                        ProcessRuntime.saveState(procInstId, runtime, e);
                        throw e;
                    }
                }
            });
        }
        finally {
            ConnectionManager.popResLicense();
            DataSourceResource.disposeConnectionPool();
        }
        return ServiceFlowApiDispatcher.getOutput(flowId, StartEventServiceFlow.getResult(flowId, runtime));
    }

    private static Pair<Long, Object[]> getResult(long procInstId, FlowRuntime runtime) {
        ProcessState state = ProcessRuntime.getState(runtime);
        if (state == ProcessState.Complete) {
            return new Pair((Object)procInstId, (Object)runtime.getOutput().toArray());
        }
        if (state == ProcessState.Terminated) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\uff08%1$s\uff09\u201c\uff08%2$s\uff09\u201d\u88ab\u64cd\u4f5c\u8005\u64a4\u9500\u3002", (String)"StartEventServiceFlow_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), runtime.getFlow().getTitle(), runtime.getId()));
        }
        return new Pair((Object)procInstId, null);
    }

    private Map<String, Object> checkParam(Object[] args, int i) {
        Object param = args[i];
        if (param instanceof Map) {
            Map paramMap = (Map)param;
            if (paramMap.isEmpty()) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8c03\u7528\u4e8b\u4ef6\u8865\u507f\u670d\u52a1\u6d41\u7a0b\u7684\u53c2\u6570\u8981\u6c42\u662fMap\u7c7b\u578b\uff0c\u4f46\u5b9e\u9645\u63d0\u4f9b\u7684\u53c2\u6570\u662f\u7a7amap", (String)"StartEventServiceFlow_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            return paramMap;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e8b\u4ef6\u8865\u507f\u670d\u52a1\u6d41\u7a0b\u7684\u53c2\u6570\u8981\u6c42\u662fMap\u7c7b\u578b\uff0c\u4f46\u5b9e\u9645\u63d0\u4f9b\u7684\u53c2\u6570\u662f\uff1a%s", (String)"StartEventServiceFlow_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getEventData(long serviceFlowId, Map<String, Object> filterMap, EventStarterParser.EventStarter starter) {
        List<Map<String, Object>> filters = this.getFilterList(filterMap);
        Map<String, Object> requires = this.prepareRequires(starter.getNodeInfo());
        ConnectionWrapper cn = null;
        ObjectReader<Map<String, Object>> reader = null;
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", serviceFlowId));
        try {
            DynamicObject meta = starter.getMeta();
            cn = ConnectionUtil.getConnectionByMeta(meta);
            String entityName = meta.getString("full_name");
            reader = ConnectionManager.query(cn, entityName, requires, filters, null);
            Map<String, Object> map = this.getResult(reader, filters, entityName);
            return map;
        }
        finally {
            ConnectionManager.popResLicense();
            DbUtil.close(reader);
            ConnectorUtil.close(cn);
        }
    }

    private StringBuilder buildErrorInfo(List<Map<String, Object>> filters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            if (i > 0) {
                sb.append(';');
            }
            Map<String, Object> filter = filters.get(i);
            sb.append(filter.get("filter_column"));
            sb.append('=');
            sb.append(filter.get("filter_value"));
        }
        return sb;
    }

    private Map<String, Object> getResult(ObjectReader<Map<String, Object>> reader, List<Map<String, Object>> filters, String entityName) {
        if (reader.getTotalCount() > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u67e5\u5230\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u53ea\u67091\u6761\u6570\u636e\u3002", (String)"StartEventServiceFlow_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.buildErrorInfo(filters).toString(), entityName));
        }
        Map result = (Map)reader.read();
        if (CollectionUtils.isEmpty(result)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u67091\u6761\u6570\u636e\u3002", (String)"StartEventServiceFlow_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.buildErrorInfo(filters).toString(), entityName));
        }
        return result;
    }

    private List<Map<String, Object>> getFilterList(Map<String, Object> filterMap) {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(filterMap.size());
        int i = 0;
        for (Map.Entry<String, Object> filter : filterMap.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("filter_left_bracket", Character.valueOf('('));
            map.put("filter_column", filter.getKey());
            map.put("filter_compare", "=");
            map.put("filter_value", filter.getValue());
            map.put("filter_right_bracket", Character.valueOf(')'));
            if (i > 0) {
                map.put("filter_link", "or");
            }
            filters.add(map);
            ++i;
        }
        return filters;
    }

    private Map<String, Object> prepareRequires(Map<String, Object> node) {
        List selectorEntry = (List)node.get("selector_entry");
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectorEntry.size());
        for (Map selector : selectorEntry) {
            String field = D.s(selector.get("field"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, path);
        }
        return requires;
    }

    private void checkValid(ServiceFlow serviceFlow, String flowNumber) {
        if (serviceFlow == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff1a%s\u5728\u73af\u5883\u4e2d\u4e0d\u5b58\u5728", (String)"StartEventServiceFlow_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flowNumber));
        }
        if (!"EVENT".equals(serviceFlow.getFlow().getString("init_mode"))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8865\u507f\u51fd\u6570\uff1aStartEventServiceFlow \u4ec5\u652f\u6301\u4e8b\u4ef6\u89e6\u53d1\u7c7b\u578b\u7684\u670d\u52a1\u6d41\u7a0b", (String)"StartEventServiceFlow_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!D.x((Object)serviceFlow.getFlow().getString("is_released"))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff1a%s\u672a\u53d1\u5e03\uff0c\u8bf7\u53d1\u5e03\u540e\u518d\u6267\u884c\u8865\u507f", (String)"StartEventServiceFlow_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flowNumber));
        }
        if (!D.x((Object)serviceFlow.getFlow().getString("enable")) && AppParameterServiceHelper.isEnableControl()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff1a%s\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u6267\u884c\u8865\u507f", (String)"StartEventServiceFlow_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flowNumber));
        }
    }

    public String name() {
        return "StartEventServiceFlow";
    }
}

