/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self.serviceEvent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.platform.core.connector.self.EntityInfo;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.EventField;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.ServiceEvent;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class AccountEvent
implements ServiceEvent {
    public static final String PROTOCOL = "account_event";
    private static final String META_NUMBER = "ai_eventclass";
    private String number;
    private String name;
    private Map<String, EventField> systemFieldMap;
    private Map<String, EventField> headFieldMap;
    private Map<String, String> entryNameMap;
    private Map<String, Map<String, EventField>> entryFieldMap;
    private Set<String> refEntity;

    private static String getRemarks() {
        return ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u770b\u83dc\u5355\uff1a\u8d22\u52a1\u4e91-\u4f1a\u8ba1\u4e8b\u4ef6\u5e93-\u5916\u90e8\u6570\u636e\u63a5\u5165-\u5916\u90e8\u6570\u636e\u6a21\u578b", (String)"AccountEvent_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static String getResultScript() {
        return String.format(ResManager.loadKDString((String)"//\u6b64\u811a\u672c\u7531\u8fde\u63a5\u5668\u81ea\u52a8\u751f\u6210\uff0c\u4e25\u7981\u4fee\u6539", (String)"AccountEvent_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\nvar res = String.ParseJson($result);\nif(res.success){\n  return {\"id\":res.data[0].id,\"type\":\"SAVE\"};\n}\nelse{\n" + String.format(ResManager.loadKDString((String)"  throw \"\u8fd4\u56de\u7ed3\u679c\u548c\u9519\u8bef\u539f\u56e0\uff1a\"+$result;", (String)"AccountEvent_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n}";
    }

    public AccountEvent() {
        this.systemFieldMap = new LinkedHashMap<String, EventField>();
        this.headFieldMap = new LinkedHashMap<String, EventField>();
        this.entryNameMap = new LinkedHashMap<String, String>();
        this.entryFieldMap = new LinkedHashMap<String, Map<String, EventField>>();
        this.refEntity = new HashSet<String>();
    }

    public AccountEvent(String number) {
        this.number = number;
        this.systemFieldMap = new LinkedHashMap<String, EventField>();
        this.headFieldMap = new LinkedHashMap<String, EventField>();
        this.entryNameMap = new LinkedHashMap<String, String>();
        this.entryFieldMap = new LinkedHashMap<String, Map<String, EventField>>();
        this.refEntity = new HashSet<String>();
        Map<String, Object> resultMap = AccountEvent.invokeMicroServiceGetModelInfo(number);
        this.initFieldMap(resultMap);
    }

    private void initFieldMap(Map<String, Object> modelMap) {
        this.name = D.s((Object)modelMap.get("name"));
        List allFieldCfgs = (List)this.getMapPathValue(modelMap, "datas", "datas", "datas");
        for (Map fieldCfg : allFieldCfgs) {
            String cfgNumber = D.s(fieldCfg.get("number"));
            if ("$SYSTEM".equals(cfgNumber)) {
                this.systemFieldMap.putAll(this.getChildField(fieldCfg));
                continue;
            }
            if (cfgNumber.startsWith("$HEAD|")) {
                this.headFieldMap.putAll(this.getChildField(fieldCfg));
                continue;
            }
            if (!cfgNumber.startsWith("$ENTRY|")) continue;
            String entryName = cfgNumber.substring(7);
            Map<String, EventField> fieldMap = this.getChildField(fieldCfg);
            this.entryFieldMap.put(entryName, fieldMap);
            this.entryNameMap.put(entryName, D.s(fieldCfg.get("name")));
        }
    }

    private static Map<String, Object> invokeMicroServiceGetModelInfo(String number) {
        Object resultJson = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"ExtDataModelService", (String)"getDataModelByNumber", (Object[])new Object[]{number});
        Map resultMap = (Map)Json.toObject((String)D.s((Object)resultJson));
        if (resultMap == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u4f1a\u8ba1\u4e8b\u4ef6\u5916\u90e8\u6a21\u578b\u3002%2$s", (String)"AccountEvent_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number, AccountEvent.getRemarks()));
        }
        return resultMap;
    }

    private Map<String, EventField> getChildField(Map<String, Object> map) {
        List fieldListMap = (List)this.getMapPathValue(map, "datas", "datas", "datas");
        if (fieldListMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, EventField> fieldMap = new HashMap<String, EventField>(fieldListMap.size());
        for (Map m : fieldListMap) {
            EventField field = (EventField)JSON.parseObject((String)Json.toString((Object)m, (boolean)true), (TypeReference)new TypeReference<EventField>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            fieldMap.put(field.getNumber(), field);
        }
        return fieldMap;
    }

    private <T> T getMapPathValue(Map<String, Object> details, String ... path) {
        Object current = details;
        for (String key : path) {
            if (current == null) {
                return null;
            }
            if (!(current instanceof Map)) {
                String message = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5916\u90e8\u6570\u636e\u6a21\u578b\u8fd4\u56de\u7684\u6570\u636e\u5931\u8d25\uff0cKey[%1$s]\u9700\u8981\u8bbf\u95ee\u7684\u5bf9\u8c61\u7c7b\u578b\u662f\u201c%2$s\u201d\u3002", (String)"AccountEvent_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, current.getClass().getName());
                throw new IllegalArgumentException(message);
            }
            current = current.get(key);
        }
        return (T)current;
    }

    @Override
    public List<Map<String, Object>> getServiceInfo() {
        ArrayList<Map<String, Object>> metaSchemaList = new ArrayList<Map<String, Object>>();
        metaSchemaList.add(this.getBaseMetaInfo());
        metaSchemaList.add(this.getDataMetaschema());
        metaSchemaList.addAll(this.getDataEntryMetaschema());
        metaSchemaList.addAll(this.getRefBaseData());
        return metaSchemaList;
    }

    private List<Map<String, Object>> getRefBaseData() {
        ArrayList<Map<String, Object>> metaInfoList = new ArrayList<Map<String, Object>>();
        for (String metaNumber : this.refEntity) {
            List<Map<String, Object>> metaInfos = EntityInfo.getEntityInfoList(metaNumber);
            metaInfoList.addAll(metaInfos);
        }
        return metaInfoList;
    }

    private Map<String, Object> getBaseMetaInfo() {
        String fullname = "account_event://" + this.number;
        HashMap<String, Object> metaInfo = new HashMap<String, Object>();
        metaInfo.put("type", MetaType.SERVICE.name());
        metaInfo.put("full_name", fullname);
        metaInfo.put("name", Hash.mur32((Object[])new Object[]{fullname}));
        metaInfo.put("title", String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b/%s", (String)"AccountEvent_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name));
        metaInfo.put("remark", AccountEvent.getRemarks());
        metaInfo.put("result_jst_tag", AccountEvent.getResultScript());
        metaInfo.put("result_jst", ResManager.loadKDString((String)"//\u9ed8\u8ba4\u8f6c\u6362\u7ed3\u679c", (String)"AccountEvent_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        metaInfo.put("params", this.getCommonField());
        metaInfo.put("properties", this.getCommonField());
        return metaInfo;
    }

    private List<Map<String, Object>> getCommonField() {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>(this.systemFieldMap.size() + 2);
        properties.add(this.createFixProp("eventclass", ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u7f16\u7801", (String)"AccountEvent_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "string", "", new String[0]));
        for (Map.Entry<String, EventField> entry : this.systemFieldMap.entrySet()) {
            String fieldName = entry.getKey();
            EventField field = entry.getValue();
            String dataSchema = "";
            String remark = "";
            if (field.isBaseProp()) {
                this.refEntity.add(field.getRefBaseProp());
                dataSchema = field.getRefBaseProp();
            } else if (field.isAssistProp()) {
                this.refEntity.add("bos_assistantdata_detail");
                dataSchema = "bos_assistantdata_detail";
                DynamicObject assist = BusinessDataServiceHelper.loadSingle((Object)field.getRefAssistProp(), (String)"bos_assistantdatagroup");
                remark = assist.getLocaleString("name").toString();
            }
            properties.add(this.createFixProp(fieldName, field.getName(), field.getIscDataSchemaDatatype(), dataSchema, remark));
        }
        String dataSchema = Hash.mur32((Object[])new Object[]{this.getDataFullname()});
        properties.add(this.createFixProp("data", ResManager.loadKDString((String)"\u5916\u90e8\u81ea\u5b9a\u4e49\u6570\u636e", (String)"AccountEvent_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), MetaType.STRUCT.name(), dataSchema, new String[0]));
        return properties;
    }

    private String getDataFullname() {
        return "account_event." + this.number + ".data";
    }

    private String getDataEntryFullname(String entryFieldName) {
        return this.getDataFullname() + "." + entryFieldName;
    }

    private Map<String, Object> createFixProp(String name, String label, String dataType, String dataSchema, String ... remark) {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("name", name);
        prop.put("label", label);
        prop.put("data_type", dataType);
        prop.put("is_nullable", Boolean.FALSE);
        if (dataSchema != null) {
            prop.put("data_schema", dataSchema);
        }
        if (remark.length > 0) {
            prop.put("remark", remark[0]);
        }
        return prop;
    }

    private Map<String, Object> getDataMetaschema() {
        String fullname = this.getDataFullname();
        HashMap<String, Object> metaInfo = new HashMap<String, Object>();
        metaInfo.put("type", MetaType.STRUCT.name());
        metaInfo.put("full_name", fullname);
        metaInfo.put("name", Hash.mur32((Object[])new Object[]{fullname}));
        metaInfo.put("title", String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b.%s.\u81ea\u5b9a\u4e49\u6a21\u578b\u7ed3\u6784", (String)"AccountEvent_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name));
        metaInfo.put("properties", this.getDataProperties());
        return metaInfo;
    }

    private List<Map<String, Object>> getDataProperties() {
        HashMap<String, Object> prop;
        String fieldName;
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>(this.headFieldMap.size() + this.entryNameMap.size());
        for (Map.Entry<String, EventField> entry : this.headFieldMap.entrySet()) {
            fieldName = entry.getKey();
            EventField field = entry.getValue();
            prop = new HashMap<String, Object>();
            prop.put("name", fieldName);
            prop.put("label", field.getName());
            prop.put("data_type", field.getIscDataSchemaDatatype());
            prop.put("is_nullable", Boolean.FALSE);
            if (field.isBaseProp()) {
                this.refEntity.add(field.getRefBaseProp());
                prop.put("data_schema", field.getRefBaseProp());
            } else if (field.isAssistProp()) {
                this.refEntity.add("bos_assistantdata_detail");
                prop.put("data_schema", "bos_assistantdata_detail");
                DynamicObject assist = BusinessDataServiceHelper.loadSingle((Object)field.getRefAssistProp(), (String)"bos_assistantdatagroup");
                prop.put("remark", assist.getLocaleString("name").toString());
            }
            properties.add(prop);
        }
        for (Map.Entry<String, Object> entry : this.entryNameMap.entrySet()) {
            fieldName = entry.getKey();
            String entryName = (String)entry.getValue();
            prop = new HashMap();
            prop.put("name", fieldName);
            prop.put("label", entryName);
            prop.put("data_type", "ENTRIES");
            prop.put("is_nullable", Boolean.FALSE);
            prop.put("data_schema", Hash.mur32((Object[])new Object[]{this.getDataEntryFullname(fieldName)}));
            properties.add(prop);
        }
        return properties;
    }

    private List<Map<String, Object>> getDataEntryMetaschema() {
        ArrayList<Map<String, Object>> metaInfoList = new ArrayList<Map<String, Object>>(this.entryNameMap.size());
        for (Map.Entry<String, String> entry : this.entryNameMap.entrySet()) {
            String entryField = entry.getKey();
            String entryName = entry.getValue();
            HashMap<String, Object> metaInfo = new HashMap<String, Object>();
            String fullname = this.getDataEntryFullname(entryField);
            metaInfo.put("type", MetaType.STRUCT.name());
            metaInfo.put("full_name", fullname);
            metaInfo.put("name", Hash.mur32((Object[])new Object[]{fullname}));
            metaInfo.put("title", String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b.%1$s.\u81ea\u5b9a\u4e49\u6a21\u578b\u7ed3\u6784.%2$s", (String)"AccountEvent_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name, entryName));
            metaInfo.put("properties", this.getDataEntryMetaschemaProperties(entryField));
            metaInfoList.add(metaInfo);
        }
        return metaInfoList;
    }

    private List<Map<String, Object>> getDataEntryMetaschemaProperties(String entryField) {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>(this.entryFieldMap.get(entryField).size());
        for (Map.Entry<String, EventField> entry : this.entryFieldMap.get(entryField).entrySet()) {
            String fieldName = entry.getKey();
            EventField field = entry.getValue();
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("name", fieldName);
            prop.put("label", field.getName());
            prop.put("data_type", field.getIscDataSchemaDatatype());
            prop.put("is_nullable", Boolean.FALSE);
            if (field.isBaseProp()) {
                this.refEntity.add(field.getRefBaseProp());
                prop.put("data_schema", field.getRefBaseProp());
            } else if (field.isAssistProp()) {
                this.refEntity.add("bos_assistantdata_detail");
                prop.put("data_schema", "bos_assistantdata_detail");
                DynamicObject assist = BusinessDataServiceHelper.loadSingle((Object)field.getRefAssistProp(), (String)"bos_assistantdatagroup");
                prop.put("remark", assist.getLocaleString("name").toString());
            }
            properties.add(prop);
        }
        return properties;
    }
}

