/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self.triggerhandler;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.TriggerHandler;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class EventDispatcher {
    private static final Log log = LogFactory.getLog(EventDispatcher.class);
    private static Map<String, TriggerHandler> eventHandlers = new HashMap<String, TriggerHandler>(8);

    private static void registerExternalEventHandlers(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String type = D.s((Object)entry.getKey());
            String className = D.s((Object)entry.getValue());
            if (type == null || className == null) continue;
            EventDispatcher.innerRegister(type, className);
        }
    }

    private static void innerRegister(String type, String className) {
        try {
            if (eventHandlers.containsKey(type)) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\uff08%s\uff09\u5df2\u6ce8\u518c\uff01", (String)"EventDispatcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
            }
            TriggerHandler triggerHandler = (TriggerHandler)ReflectionUtil.newInstance((String)className);
            eventHandlers.put(type, triggerHandler);
        }
        catch (Throwable e) {
            log.warn("\u6ce8\u518c\u4e8b\u4ef6\u5904\u7406\u7c7b\u3010" + className + "\u3011\u5931\u8d25\uff1a", e);
        }
    }

    public static Object dispatch(String trigger_type, long trigger_id, Object data) {
        List<?> list = EventDispatcher.wrapList(data);
        TriggerHandler triggerHandler = eventHandlers.get(trigger_type);
        if (triggerHandler != null) {
            return triggerHandler.handle(trigger_id, list);
        }
        throw new UnsupportedOperationException("TODO-trigger_type=" + trigger_type);
    }

    private static List<?> wrapList(Object data) {
        if (data == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"EventDispatcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (data instanceof Map) {
            return Collections.singletonList(data);
        }
        if (data instanceof List) {
            return (List)data;
        }
        if (data instanceof Collection) {
            return new ArrayList((Collection)data);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6570\u636e\u4ec5\u652f\u6301Map\u6216List\u7c7b\u578b\uff0c\u5f53\u524d\u6570\u636e\u7c7b\u578b\uff1a%1$s\uff0c\u6570\u636e\u503c\uff1a%2$s", (String)"EventDispatcher_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data.getClass(), data));
    }

    private void clear() {
        eventHandlers.clear();
    }

    static {
        try {
            InputStream in = JobEngine.class.getClassLoader().getResourceAsStream("iscb/event_handler.properties");
            try {
                if (in != null) {
                    Properties properties = new Properties();
                    properties.load(in);
                    EventDispatcher.registerExternalEventHandlers(properties);
                }
            }
            finally {
                DbUtil.close((InputStream)in);
            }
        }
        catch (Throwable e) {
            log.warn("\u521d\u59cb\u5316\u5916\u90e8\u4e8b\u4ef6\u5904\u7406\u7c7b\u5931\u8d25\uff1a", e);
        }
    }
}

