/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sunftp;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.dt.D;
import sun.net.ftp.FtpDirEntry;

public class FtpFile {
    public static final String FILE_NAME = "fileName";
    public static final String FILE_SIZE = "fileSize";
    public static final String FILE_EXT = "fileExt";
    public static final String MODIFY_TIME = "modifyTime";
    public static final String FILE_CONTENT = "fileContent";
    private String fileName;
    private final long fileSize;
    private final String fileExt;
    private final String fileType;
    private final Object fileContent;
    private final String modifyTime;
    private final FtpDirEntry.Type type;

    public FtpFile(FtpDirEntry ftpFile) {
        this(ftpFile.getName(), ftpFile.getSize(), null, null, ftpFile.getLastModified(), ftpFile.getType());
    }

    public FtpFile(FtpDirEntry ftpFile, Object fileContent) {
        this(ftpFile.getName(), ftpFile.getSize(), null, fileContent, ftpFile.getLastModified(), ftpFile.getType());
    }

    public FtpFile(FtpDirEntry ftpFile, Throwable e) {
        this(ftpFile.getName(), ftpFile.getSize(), null, null, ftpFile.getLastModified(), ftpFile.getType());
    }

    public FtpFile(String fileName, long fileSize, String fileType, Object fileContent, Date lastModified, FtpDirEntry.Type type) {
        this.fileName = FtpUtil.getName(fileName);
        this.fileSize = fileSize;
        this.fileExt = FtpUtil.getSuffix(fileName);
        this.fileType = fileType;
        this.fileContent = fileContent;
        this.modifyTime = D.format((Date)lastModified, (String)"yyyy-MM-dd HH:mm:ss");
        this.type = type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public String getFileType() {
        return this.fileType;
    }

    public Object getFileContent() {
        return this.fileContent;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public FtpDirEntry.Type getType() {
        return this.type;
    }

    public Map<String, Object> toMap(Object fileContent) {
        Map<String, Object> map = this.toMap();
        map.put(FILE_CONTENT, fileContent);
        return map;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(FILE_NAME, this.fileName);
        map.put(FILE_SIZE, this.fileSize);
        map.put(FILE_EXT, this.fileExt);
        map.put(MODIFY_TIME, this.modifyTime);
        map.put("type", (Object)this.type);
        return map;
    }
}

