/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sunftp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.util.FileType;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpFile;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpDirEntry;
import sun.net.ftp.FtpProtocolException;

public class FtpUtil {
    private static final Log LOG = LogFactory.getLog(FtpUtil.class);
    public static final char SLASH = '/';
    public static final String SLASH_STR = "/";
    public static final char BACKSLASH = '\\';
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final int INDEX_NOT_FOUND = -1;
    public static final char DOT = '.';
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final long MAX_FILE_SIZE = 0x3200000L;

    public static List<Map<String, Object>> getFtpFileMap(List<FtpFile> list, FtpDirEntry.Type type) {
        List<FtpFile> files = FtpUtil.getFtpFiles(list, type);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(files.size());
        for (FtpFile file : files) {
            result.add(file.toMap());
        }
        return result;
    }

    public static List<FtpFile> getFtpFiles(List list, final FtpDirEntry.Type type) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return FtpUtil.filterFtpFiles(list, new Predicate<FtpFile>(){

            @Override
            public boolean test(FtpFile ftpFile) {
                return FtpUtil.filterFtpFile(ftpFile, type);
            }
        });
    }

    public static List<Map<String, Object>> getFtpFileMap(FtpConnectionWrapper cn, String dirPath, FtpDirEntry.Type type) {
        List<FtpFile> files = FtpUtil.getFtpFiles(cn, dirPath, type);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(files.size());
        for (FtpFile file : files) {
            result.add(file.toMap());
        }
        return result;
    }

    public static List<FtpFile> getFtpFiles(FtpConnectionWrapper cn, String dirPath, final FtpDirEntry.Type type) {
        List<FtpFile> list = cn.list(dirPath);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return FtpUtil.filterFtpFiles(list, new Predicate<FtpFile>(){

            @Override
            public boolean test(FtpFile ftpFile) {
                return FtpUtil.filterFtpFile(ftpFile, type);
            }
        });
    }

    private static boolean filterFtpFile(FtpFile ftpFile, FtpDirEntry.Type type) {
        if (type == null) {
            return ftpFile.getType() == FtpDirEntry.Type.FILE || ftpFile.getType() == FtpDirEntry.Type.DIR;
        }
        return ftpFile.getType() == type;
    }

    public static InputStream getFileStream(Object fileContent) {
        if (fileContent == null) {
            return null;
        }
        if (fileContent instanceof byte[]) {
            return new ByteArrayInputStream((byte[])fileContent);
        }
        throw new IscFtpException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b %s\u3002", (String)"FtpUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fileContent.getClass().getCanonicalName());
    }

    public static DynamicObject getDbLinkId(String cnNumber) {
        if (StringUtil.isEmpty((String)cnNumber)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u8fde\u63a5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject database = ConnectionConfig.getByNumber(cnNumber);
        if (database == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7f16\u7801[%s]\u4e0d\u5b58\u5728\u3002", (String)"FtpUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cnNumber));
        }
        return database;
    }

    public static FtpConnectionWrapper getFtpConnection(String cnNumber) {
        DynamicObject database = FtpUtil.getDbLinkId(cnNumber);
        ConnectionWrapper cn = ConnectionManager.getConnection(database.getLong("id"));
        return (FtpConnectionWrapper)cn;
    }

    public static List<FtpFile> list(FtpClient client, String path, Charset charset) {
        List<String> nameList;
        Iterator<FtpDirEntry> ftpFiles;
        try {
            ftpFiles = client.listFiles(path);
        }
        catch (Throwable e) {
            LOG.warn("\u83b7\u53d6\u5217\u8868\u5931\u8d25", e);
            return FtpUtil.getFiles(client, path, charset);
        }
        ArrayList<FtpFile> files = new ArrayList<FtpFile>(16);
        if (ftpFiles != null) {
            while (ftpFiles.hasNext()) {
                FtpDirEntry entry = ftpFiles.next();
                files.add(new FtpFile(entry));
            }
        }
        if (!CollectionUtils.isEmpty(nameList = FtpUtil.getNames(client, path, charset)) && files.size() == nameList.size()) {
            for (int i = 0; i < files.size(); ++i) {
                FtpFile file = (FtpFile)files.get(i);
                if (!StringUtil.isEmpty((String)file.getFileName())) continue;
                file.setFileName(FtpUtil.getName(nameList.get(i)));
            }
        }
        return files;
    }

    public static List<FtpFile> getFiles(FtpClient client, String path, Charset charset) {
        List<String> nameList = FtpUtil.getNames(client, path, charset);
        if (CollectionUtils.isEmpty(nameList)) {
            return Collections.emptyList();
        }
        ArrayList<FtpFile> entryList = new ArrayList<FtpFile>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(client.list(path), charset));){
            List lines = br.lines().collect(Collectors.toList());
            if (lines.size() != nameList.size()) {
                throw new IscFtpException(ResManager.loadKDString((String)"\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FtpUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yy hh:mma", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            for (int index = 0; index < lines.size(); ++index) {
                String str = (String)lines.get(index);
                String[] arr = str.split(" ");
                if ("<DIR>".equals(arr[9])) {
                    entryList.add(FtpUtil.getFtpFile(nameList.get(index), -1L, FtpDirEntry.Type.DIR, dateFormat.parse(arr[0] + " " + arr[2])));
                    continue;
                }
                String sizeStr = null;
                for (int i = 3; i < arr.length && "".equals(sizeStr = arr[i]); ++i) {
                }
                entryList.add(FtpUtil.getFtpFile(nameList.get(index), D.l((Object)sizeStr), FtpDirEntry.Type.FILE, dateFormat.parse(arr[0] + " " + arr[2])));
            }
        }
        catch (Exception e) {
            throw new IscFtpException(e);
        }
        return entryList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getNames(FtpClient client, String path, Charset charset) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(client.nameList(path), charset));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    private static FtpFile getFtpFile(String name, long size, FtpDirEntry.Type type, Date lastModified) {
        return new FtpFile(name, size, null, null, lastModified, type);
    }

    public static List<FtpFile> filterFtpFiles(List<FtpFile> ftpFiles, Predicate<FtpFile> filter) {
        if (ftpFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<FtpFile> result = new ArrayList<FtpFile>(ftpFiles.size() - 2 <= 0 ? ftpFiles.size() : ftpFiles.size() - 2);
        for (FtpFile ftpFile : ftpFiles) {
            String fileName = ftpFile.getFileName();
            if (StringUtil.equals((String)".", (String)fileName) || StringUtil.equals((String)"..", (String)fileName) || null != filter && !filter.test(ftpFile)) continue;
            result.add(ftpFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readFileContent(FtpClient client, PathInfo pathInfo, String fileName, long restartOffset) throws Exception {
        client.setRestartOffset(restartOffset);
        Throwable throwable = null;
        try (InputStream inputStream = client.getFileStream(pathInfo.getDirPath() + fileName);){
            block25: {
                byte[] byArray;
                try {
                    if (pathInfo.getFileType() != FileType.BIN) break block25;
                    byArray = FtpUtil.readBytes(inputStream);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            client.completePending();
                        }
                        catch (Throwable e) {
                            LOG.warn("ftpClient.completePending \u6267\u884c\u5f02\u5e38\u3002", e);
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                try {
                    client.completePending();
                }
                catch (Throwable e) {
                    LOG.warn("ftpClient.completePending \u6267\u884c\u5f02\u5e38\u3002", e);
                }
                return byArray;
            }
            String string = FtpUtil.readString(pathInfo.getCharset(), inputStream);
            try {
                client.completePending();
            }
            catch (Throwable e) {
                LOG.warn("ftpClient.completePending \u6267\u884c\u5f02\u5e38\u3002", e);
            }
            return string;
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int readSize;
            byte[] buffer = new byte[8192];
            while ((readSize = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readSize);
                outputStream.flush();
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static String readString(Charset charset, InputStream inputStream) throws IOException {
        byte[] bytes = FtpUtil.readBytes(inputStream);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static void delete(FtpClient client, String path) throws Exception {
        client.deleteFile(path);
    }

    public static void rmdir(FtpClient client, String dirPath, Charset charset) throws Exception {
        List<FtpFile> dirs = FtpUtil.list(client, dirPath, charset);
        if (dirs == null) {
            return;
        }
        for (FtpFile ftpFile : dirs) {
            String name = ftpFile.getFileName();
            String childPath = dirPath + (dirPath.endsWith(SLASH_STR) ? "" : Character.valueOf('/')) + name;
            if (ftpFile.getType() == FtpDirEntry.Type.DIR) {
                if (".".equals(name) || "..".equals(name)) continue;
                FtpUtil.rmdir(client, childPath, charset);
                continue;
            }
            FtpUtil.delete(client, childPath);
        }
        client.removeDirectory(dirPath);
    }

    public static void mkdir(FtpClient client, String dirPath) throws Exception {
        if (!dirPath.equals(SLASH_STR)) {
            String[] dirs = dirPath.split(SLASH_STR);
            StringBuilder childPath = new StringBuilder(SLASH_STR);
            for (String dir : dirs) {
                if (StringUtil.isEmpty((String)dir)) continue;
                childPath.append(childPath.toString().endsWith(SLASH_STR) ? "" : Character.valueOf('/')).append(dir);
                try {
                    client.changeDirectory(childPath.toString());
                }
                catch (FtpProtocolException e) {
                    client.makeDirectory(childPath.toString());
                }
            }
        }
    }

    public static boolean exists(FtpClient client, String dirPath) throws Exception {
        if (dirPath.lastIndexOf(47) == dirPath.length() - 1) {
            return FtpUtil.existDirectory(client, dirPath);
        }
        String path = dirPath.substring(0, dirPath.lastIndexOf(47));
        String fileName = dirPath.substring(dirPath.lastIndexOf(47) + 1);
        return FtpUtil.existDirectory(client, path) && FtpUtil.existFile(client, path, fileName);
    }

    public static boolean existDirectory(FtpClient client, String dirPath) throws Exception {
        if (!dirPath.equals(SLASH_STR)) {
            String[] dirs = dirPath.split(SLASH_STR);
            StringBuilder childPath = new StringBuilder(SLASH_STR);
            for (String dir : dirs) {
                if (StringUtil.isEmpty((String)dir)) continue;
                childPath.append(childPath.toString().endsWith(SLASH_STR) ? "" : Character.valueOf('/')).append(dir);
                try {
                    client.changeDirectory(childPath.toString());
                }
                catch (FtpProtocolException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean existFile(FtpClient client, String dirPath, String fileName) throws Exception {
        Iterator<FtpDirEntry> ftpFiles;
        Iterator<FtpDirEntry> it = ftpFiles = client.listFiles(dirPath);
        while (it.hasNext()) {
            FtpDirEntry item = it.next();
            if (!FtpDirEntry.Type.FILE.equals((Object)item.getType()) || !fileName.equals(item.getName())) continue;
            return true;
        }
        return false;
    }

    public static void createNotExistDir(FtpClient client, String dirPath, Charset charset) throws Exception {
        if (!dirPath.equals(SLASH_STR)) {
            String[] dirs = dirPath.split(SLASH_STR);
            StringBuilder childPath = new StringBuilder(SLASH_STR);
            for (String dir : dirs) {
                if (StringUtil.isEmpty((String)dir)) continue;
                List<String> dirNameList = FtpUtil.getNames(client, childPath.toString(), charset);
                childPath.append(childPath.toString().endsWith(SLASH_STR) ? "" : Character.valueOf('/')).append(dir);
                if (dirNameList.contains(childPath.toString()) || dirNameList.contains(dir)) continue;
                client.makeDirectory(childPath.toString());
            }
        }
    }

    public static long getMaxFileSize(String att8) {
        long maxSize;
        if (StringUtil.isEmpty((String)att8)) {
            return 0x3200000L;
        }
        if ((att8 = att8.toUpperCase(Locale.ENGLISH)).endsWith("KB")) {
            maxSize = D.l((Object)att8.substring(0, att8.indexOf("KB"))) * 1024L;
        } else if (att8.endsWith("B")) {
            maxSize = D.l((Object)att8.substring(0, att8.indexOf(66)));
        } else if (att8.endsWith("M")) {
            maxSize = D.l((Object)att8.substring(0, att8.indexOf(77))) * 1024L * 1024L;
        } else {
            throw new IscFtpException(ResManager.loadKDString((String)"[\u6700\u5927\u53ef\u8bfb\u6587\u4ef6\u5927\u5c0f]\u89e3\u6790\u5931\u8d25\u3002", (String)"FtpUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return Math.min(0x3200000L, maxSize);
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (FtpUtil.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!FtpUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static String getSuffix(String fileName) {
        return FtpUtil.extName(fileName);
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return FtpUtil.containsAny(ext, '/', '\\') ? "" : ext;
    }

    public static boolean containsAny(String str, char ... testChars) {
        if (!StringUtil.isEmpty((String)str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!FtpUtil.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        return FtpUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(char[] array, char value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }
}

