/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.trace;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.isc.iscb.platform.core.connector.trace.SqlDebugRuntime;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.misc.StringUtil;

public class SqlLogItem {
    private String connDesc;
    private Timestamp startTime;
    private Timestamp endTime;
    private long timespan;
    private String sql;
    private DebugCoordinator debugCoordinator;

    public SqlLogItem(String connDesc, String sql, DebugCoordinator debugCoordinator) {
        this.connDesc = connDesc;
        this.sql = sql;
        this.debugCoordinator = debugCoordinator;
    }

    public static SqlLogItem startRecord(String connDesc, String sql) {
        DebugCoordinator debugCoordinator = (DebugCoordinator)DebugCoordinator.REF.get();
        if (debugCoordinator.isLoggerEnabled()) {
            SqlLogItem sqlLogItem = new SqlLogItem(connDesc, sql, debugCoordinator);
            sqlLogItem.start();
            return sqlLogItem;
        }
        return null;
    }

    public static void endRecord(SqlLogItem item, Throwable ex) {
        if (item != null) {
            item.end(ex);
        }
    }

    public static void endRecord(SqlLogItem item) {
        if (item != null) {
            item.end(null);
        }
    }

    private void start() {
        this.startTime = new Timestamp(System.currentTimeMillis());
    }

    private void end(Throwable ex) {
        this.endTime = new Timestamp(System.currentTimeMillis());
        this.timespan = this.endTime.getTime() - this.startTime.getTime();
        this.debugCoordinator.info((DebuggableRuntime)new SqlDebugRuntime(this.connDesc, this.sql), 1, (Object)this.toString(ex));
    }

    private String toString(Throwable ex) {
        if (ex != null) {
            return this.toString() + "\r\nerror : " + StringUtil.getCascadeMessage((Throwable)ex);
        }
        return this.toString();
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String startTimeZone = TimeUtil.getInteTime(new Date(this.startTime.getTime()), sdf);
        return this.connDesc + "execute at : " + startTimeZone + " \r\ncost : " + this.timespan + " ms \r\nsql : " + this.sql;
    }
}

