/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.webapi;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.connector.webapi.DynamicObjectContext;
import kd.isc.iscb.platform.core.connector.webapi.ReloginFunction;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.platform.core.connector.wechat.CallWechatByCloudPlatform;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskWorker;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.trace.TraceItem;
import kd.isc.iscb.util.trace.TraceManager;

public class SessionCache {
    private static final ReadLockFreeMap<String, ReadLockFreeMap<Long, Item>> caches = new ReadLockFreeMap();
    private static final Log log = LogFactory.getLog(TaskWorker.class);

    public static void clearCache() {
        SessionCache.getCache().clear();
    }

    public static void removeLoginInfo(DynamicObject cfg) {
        ReadLockFreeMap<Long, Item> cache = SessionCache.getCache();
        long id = D.l((Object)cfg.get("id"));
        cache.remove(id);
    }

    public static Object getLoginInfo(DynamicObject cfg, Script loginScript, Map<String, Object> extensions) {
        long id;
        ReadLockFreeMap<Long, Item> cache = SessionCache.getCache();
        Item item = (Item)cache.get(id = D.l((Object)cfg.get("id")));
        if (item != null) {
            return item.loginInfo;
        }
        TraceItem current = TraceManager.current();
        item = current == null || current.isDisableTrace() ? SessionCache.createSession(cache, id, cfg, loginScript, extensions) : SessionCache.createSessionWithoutTrace(cfg, loginScript, extensions, cache, id, current);
        return item.loginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Item createSessionWithoutTrace(DynamicObject cfg, Script loginScript, Map<String, Object> extensions, Map<Long, Item> cache, long id, TraceItem current) {
        current.disableTrace();
        try {
            Item item = SessionCache.createSession(cache, id, cfg, loginScript, extensions);
            return item;
        }
        finally {
            current.enableTrace();
        }
    }

    private static Item createSession(Map<Long, Item> cache, long id, DynamicObject cfg, Script loginScript, Map<String, Object> extensions) {
        Item item = new Item();
        item.connectionId = id;
        try {
            item.loginInfo = SessionCache.eval(cfg, loginScript, extensions);
        }
        catch (Exception e) {
            String linkName = D.s((Object)cfg.get("name"));
            String linkNumber = D.s((Object)cfg.get("number"));
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u3010%1$s\uff08%2$s\uff09\u3011\u7684\u8fde\u63a5\u7c7b\u578b\u767b\u5f55\u811a\u672c\u6267\u884c\u5f02\u5e38\u3002", (String)"SessionCache_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), linkName, linkNumber), (Throwable)e);
        }
        item.extensions = extensions;
        cache.put(id, item);
        SessionCache.createRefreshTask(item);
        return item;
    }

    private static void createRefreshTask(Item item) {
        SessionRefresher task = new SessionRefresher(item);
        int delay = SessionCache.getDelayTime(item);
        ScheduleManager.submit((Task)task, delay);
    }

    private static int getDelayTime(Item item) {
        long diff;
        long refreshTime;
        int delay = 900;
        if (item.loginInfo instanceof Map && (refreshTime = D.l(((Map)item.loginInfo).get("$refreshTime"))) > 0L && (diff = (refreshTime - System.currentTimeMillis()) / 1000L) > 0L) {
            delay = Math.max(5, (int)diff);
        }
        return delay;
    }

    public static Object eval(DynamicObject cfg, Script script, Map<String, Object> extensions) {
        Map<String, Object> ctx = SessionCache.createContext(cfg, null, extensions);
        return script.eval(ctx);
    }

    static Map<String, Object> createContext(DynamicObject cfg, Object session, Map<String, Object> extensions) {
        if ("@#is_custom_page".equals(D.s((Object)cfg.get("attr5")))) {
            return SessionCache.getCustomContext(cfg, session);
        }
        return SessionCache.getContext(cfg, session, extensions);
    }

    private static Map<String, Object> getContext(DynamicObject cfg, Object session, Map<String, Object> extensions) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(extensions);
        ctx.put("$website", SessionCache.getWebsite(cfg));
        ctx.put("$protocal", cfg.get("http_protocal"));
        ctx.put("$ip", cfg.get("server_ip"));
        ctx.put("$port", cfg.get("server_port"));
        ctx.put("$user", cfg.get("user"));
        ctx.put("$password", cfg.get("password"));
        ctx.put("$lang", cfg.get("icid"));
        ctx.put("$data_center", cfg.get("data_center"));
        ctx.put("$session", session);
        ctx.put("$web_app", cfg.get("web_app"));
        ctx.put("$tenant_id", cfg.get("tenant"));
        ctx.put("$account_id", cfg.get("account"));
        ctx.put("$app_id", cfg.get("appid"));
        ctx.put("$app_securet", cfg.get("appsecret"));
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("callWechatByCloudPlatform", new CallWechatByCloudPlatform());
        ctx.put("this", new DynamicObjectContext(cfg));
        return ctx;
    }

    private static String getWebsite(DynamicObject cfg) {
        String protocal = D.s((Object)cfg.get("http_protocal"));
        int port = D.i((Object)cfg.get("server_port"));
        if (port <= 0) {
            port = "https".equals(protocal) ? 443 : 80;
        }
        return protocal + "://" + cfg.get("server_ip") + ":" + port;
    }

    private static Map<String, Object> getCustomContext(DynamicObject cfg, Object session) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$website", SessionCache.getWebsite(cfg));
        ctx.put("$protocal", cfg.get("http_protocal"));
        ctx.put("$ip", cfg.get("server_ip"));
        ctx.put("$port", cfg.get("server_port"));
        ctx.put("$session", session);
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("callWechatByCloudPlatform", new CallWechatByCloudPlatform());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("http_protocal", cfg.get("http_protocal"));
        map.put("server_ip", cfg.get("server_ip"));
        map.put("server_port", cfg.get("server_port"));
        String json = D.s((Object)cfg.get("attr_e1"));
        if (json != null) {
            Map params = (Map)Json.toObject((String)json);
            map.putAll(params);
        }
        ctx.put("this", map);
        return ctx;
    }

    private static ReadLockFreeMap<Long, Item> getCache() {
        String account = RequestContext.get().getAccountId();
        ReadLockFreeMap cache = (ReadLockFreeMap)caches.get((Object)account);
        if (cache == null) {
            caches.put((Object)account, (Object)new ReadLockFreeMap());
            cache = (ReadLockFreeMap)caches.get((Object)account);
        }
        return cache;
    }

    public static Object evalRefresh(DynamicObject cfg, Script script, Object loginInfo, Map<String, Object> extensions) {
        try (ConnectionWrapper cn = ConnectionManager.getConnection(cfg.getLong("id"));){
            Map<String, Object> ctx = SessionCache.createContext(cn.getConfig(), loginInfo, extensions);
            ctx.put("Relogin", new ReloginFunction(cn));
            Object object = script.eval(ctx);
            return object;
        }
    }

    private static class Item {
        private long connectionId;
        private volatile Object loginInfo;
        private Map<String, Object> extensions;

        private Item() {
        }
    }

    private static final class SessionRefresher
    implements LightTask {
        private final Item item;
        private String id = UUID.randomUUID().toString();

        private SessionRefresher(Item item) {
            this.item = item;
        }

        @Override
        public void run() {
            if (SessionCache.getCache().get((Object)this.item.connectionId) != this.item) {
                return;
            }
            try {
                TraceManager.disableTrace();
                Object loginInfo = this.evalRefreshScript(this.item);
                this.refreshLoginInfo(this.item, loginInfo);
                int delay = SessionCache.getDelayTime(this.item);
                ScheduleManager.submit((Task)this, delay);
            }
            catch (Throwable e) {
                ReadLockFreeMap cache = SessionCache.getCache();
                cache.remove(this.item.connectionId);
                log.warn("\u5237\u65b0\u4f1a\u8bdd(" + this.item.connectionId + ")\u5931\u8d25\uff01", e);
            }
        }

        private void refreshLoginInfo(Item item, Object loginInfo) {
            item.loginInfo = loginInfo;
        }

        private Object evalRefreshScript(Item item) {
            try (ConnectionWrapper cn = ConnectionManager.getConnection(item.connectionId);){
                WebApiConnectionFactory factory = (WebApiConnectionFactory)cn.getFactory();
                Map<String, Object> ctx = SessionCache.createContext(cn.getConfig(), item.loginInfo, item.extensions);
                ctx.put("Relogin", new ReloginFunction(cn));
                Object object = factory.getRefreshScript().eval(ctx);
                return object;
            }
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

