/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.webapi;

import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.webapi.ReloginFunction;
import kd.isc.iscb.platform.core.connector.webapi.SessionCache;
import kd.isc.iscb.platform.core.connector.webapi.SupportWebhookEvent;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.util.script.Script;

public class SupportWebhookWebApiFactory
extends WebApiConnectionFactory
implements SupportWebhookEvent {
    private Script registerWebhookEventScript;
    private Script unregisterWebhookEventScript;
    private Script webhookMsgHandleScript;

    @Override
    public void bindWebhookEventScript(String registerWebhookEventScript, String unregisterWebhookEventScript, String webhookMsgHandleScript) {
        this.registerWebhookEventScript = Script.compile((String)registerWebhookEventScript);
        this.unregisterWebhookEventScript = Script.compile((String)unregisterWebhookEventScript);
        this.webhookMsgHandleScript = Script.compile((String)webhookMsgHandleScript);
    }

    @Override
    public boolean supportWebhookEvent() {
        return true;
    }

    @Override
    public void registerWebhookEvent(ConnectionWrapper cn, Map<String, Object> event) {
        try {
            Map<String, Object> ctx = this.generateCtx(cn);
            ctx.put("$data", event);
            this.registerWebhookEventScript.eval(ctx);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    @Override
    public void unregisterWebhookEvent(ConnectionWrapper cn, Map<String, Object> event) {
        try {
            Map<String, Object> ctx = this.generateCtx(cn);
            ctx.put("$data", event);
            this.unregisterWebhookEventScript.eval(ctx);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    @Override
    public Object webhookMsgHandle(ConnectionWrapper cn, Map<String, Object> data) {
        try {
            Map<String, Object> ctx = SessionCache.createContext(cn.getConfig(), null, this.getExtensions());
            ctx.put("$data", data);
            return this.webhookMsgHandleScript.eval(ctx);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    private Map<String, Object> generateCtx(ConnectionWrapper cn) {
        Map<String, Object> ctx = this.generateCtx(cn.getConfig());
        ctx.put("Relogin", new ReloginFunction(cn));
        return ctx;
    }
}

